<?php

namespace App\Exports;

use App\Models\Classroom;
use LaravelMultipleGuards\Traits\FindGuard;
use App\Models\Exam;
use App\Models\Subject;
use App\Models\Trimester;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Date;
use Maatwebsite\Excel\Concerns\WithFooter;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use PhpOffice\PhpSpreadsheet\Worksheet\MemoryDrawing;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup;
use PhpOffice\PhpSpreadsheet\Worksheet\PageSetup\Image;

class AllpautaSubject implements FromView, ShouldAutoSize, WithEvents
{
    use FindGuard;
    private $condition;
    public $user;
    public $schoolName, $subjectName, $className;

    public function __construct($condition)
    {
        $this->condition = $condition;

        $this->schoolName = 'COLÉGIO POLITÉCNICO DE MOÇAMBIQUE'; // Replace with your school name // Fetch subject name
        $this->className = Classroom::query()->where('id', $this->condition['class_id'])->first()->name; // Fetch class name
    }

    
    public function view(): View
    {
        // Montar a consulta
        $query = Exam::query()
            ->select('exams.student_id', 'exams.classroom_id', 'exams.trimester_id') // Campos desejados
            ->distinct('exams.student_id') // Remover duplicados
            ->join('users', 'exams.student_id', '=', 'users.id') // Relacionar com a tabela users
            ->with(['subject', 'student']) // Relacionamentos
            ->where('exams.classroom_id', $this->condition['class_id'])
            ->where('exams.year', $this->condition['year'])
            ->where('exams.trimester_id', '2')
            ->orderBy('users.name');

        // Depurar a consulta gerada
        //dd($query->toSql(), $query->getBindings());

        // Executar a consulta e retornar a view
        return view('exports.allpautasubject', [
            'models' => $query->get(),
            "classname" => $this->className,
            "class_id" => $this->condition['class'],
        ]);
    }



    public function registerEvents(): array
    {
        $logoPath = public_path('assets/images/logo.png');
        $this->user = $this->findGuardType()->user();

        
        return [
            AfterSheet::class => function (AfterSheet $event) use ($logoPath) {
                // Set the height of the logo row
                $event->sheet->getRowDimension(1)->setRowHeight(80); // Adjust image height as needed

                // Create a drawing and set the image
                $drawing = new Drawing();
                $drawing->setPath($logoPath);
                $drawing->setWorksheet($event->sheet->getDelegate());
                $drawing->setCoordinates('D1'); // Adjust the cell coordinates as needed
                $drawing->setHeight(80); // Adjust image height as needed

                // Formata todas as células numéricas para ter 2 casas decimais
                $lastRow = $event->sheet->getHighestRow();
                $event->sheet->getStyle('C2:SM'.$lastRow)
                    ->getNumberFormat()
                    ->setFormatCode('0.00');

                // Add the school name in the same cell as the logo
                if($this->condition['trimester_id'] == "pauta"){
                $trimesterNameCell = $event->sheet->getCell('C1');
                $trimesterNameCell->setValue($this->condition['class']." classe - " .$this->className." -  Pauta Final "); // Use the school name from the view

                }else{
                  
                    $trimesterNameCell = $event->sheet->getCell('C1');
                $trimesterNameCell->setValue($this->condition['class']." classe - ".$this->condition['trimester_id']. ''); // Use the school name from the view
                }

                // Add the school name in the same cell as the logo
                $schoolNameCell = $event->sheet->getCell('D1');
                $schoolNameCell->setValue($this->schoolName); // Use the school name from the view
                
                // Remove the background color of the first row
                $event->sheet->getStyle('1:1')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_NONE);

                // Set font color for the first row
                $event->sheet->getStyle('1:1')->getFont()->getColor()
                    ->setARGB(\PhpOffice\PhpSpreadsheet\Style\Color::COLOR_BLACK);

                // Make the first row bold
                $event->sheet->getStyle('1:1')->getFont()->setBold(true);
            },

            /* AfterSheet::class => function (AfterSheet $event) {
                // Set protection
                // Check user role
                if ($this->user->role == 0) {
                    //no protetctions
                }
                else {
                    // Set protection if the user role is 0
                    $event->sheet->getDelegate()->getProtection()->setSheet(true);
                }
            }, */

        ];
    }



    public function headings(): array
    {
        return [
            'Subject: ' . $this->subjectName,
            'Class: ' . $this->className,
            '', // Add more columns as needed
        ];
    }
}
