<?php

namespace App\Exports;

use App\Models\Noticeboard;
use App\Models\Classroom;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class ComunicadosExport implements FromCollection, WithHeadings, ShouldAutoSize, WithStyles
{
    protected $filters;

    public function __construct($filters = [])
    {
        $this->filters = $filters;
    }

    public function collection()
    {
        $query = Noticeboard::query();

        // Aplicar filtros
        if (!empty($this->filters['search'])) {
            $query->where('title', 'like', '%' . $this->filters['search'] . '%');
        }

        if (!empty($this->filters['type'])) {
            $query->where('type', $this->filters['type']);
        }

        if (!empty($this->filters['class'])) {
            $classroomIds = Classroom::where('class', $this->filters['class'])->pluck('id');
            $query->whereIn('class_id', $classroomIds);
        }

        if (!empty($this->filters['turma'])) {
            $query->where('class_id', $this->filters['turma']);
        }

        $comunicados = $query->orderByDesc('created_at')->get();

        return $comunicados->map(function ($comunicado) {
            $get_class = null;
            $get_student = null;

            if (!empty($comunicado->class_id)) {
                $get_class = Classroom::where("id", $comunicado->class_id)->first();
            }
            if (!empty($comunicado->student_id)) {
                $get_student = \App\Models\User::where("id", $comunicado->student_id)->first();
            }

            $para = '';
            if ($comunicado->type == 'all') {
                $para = 'Todos';
            } elseif ($comunicado->type == 'class') {
                $para = 'Classe';
            } elseif ($comunicado->type == 'student') {
                $para = 'Estudante';
            }

            return [
                'para' => $para,
                'classe' => $get_class ? $get_class->class . 'ª Classe ' . $get_class->name : '-',
                'estudante' => $get_student ? $get_student->name : '-',
                'descricao' => strip_tags($comunicado->title),
                'ficheiro' => $comunicado->media_name ?: '-',
                'ficheiro_url' => $comunicado->media_url ?: null,
                'data' => \Carbon\Carbon::parse($comunicado->created_at)->format('d/m/Y H:i'),
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Para',
            'Classe',
            'Estudante',
            'Descrição',
            'Ficheiro',
            'Data de Lançamento',
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }
}
