<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use Maatwebsite\Excel\Concerns\WithColumnWidths;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Border;

class PaymentReferencesTemplateExport implements FromArray, WithHeadings, WithStyles, WithColumnWidths
{
    public function array(): array
    {
        // Dados de exemplo
        return [
            [
                'CPMA-1234',
                '500.00',
                'Mensalidade Janeiro 2025',
                'Janeiro',
                '2025',
                '30',
                '2025-01-15'
            ],
            [
                'CPMA-5678',
                '750.00',
                'Mensalidade Janeiro + Material',
                'Janeiro',
                '2025',
                '30',
                '2025-01-15'
            ],
            [
                'CPMA-9999',
                '600.00',
                'Propina Fevereiro',
                'Fevereiro',
                '2025',
                '60',
                '2025-02-01'
            ],
        ];
    }

    public function headings(): array
    {
        return [
            'Código Estudante',
            'Valor (MT)',
            'Descrição',
            'Mês (Janeiro-Dezembro)',
            'Ano',
            'Validade (dias)',
            'Data Início'
        ];
    }

    public function styles(Worksheet $sheet)
    {
        return [
            // Header styling
            1 => [
                'font' => [
                    'bold' => true,
                    'size' => 12,
                    'color' => ['rgb' => 'FFFFFF']
                ],
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => '4472C4']
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => '000000']
                    ]
                ]
            ],
            // Example rows styling
            'A2:G4' => [
                'fill' => [
                    'fillType' => Fill::FILL_SOLID,
                    'startColor' => ['rgb' => 'E7E6E6']
                ],
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => Border::BORDER_THIN,
                        'color' => ['rgb' => 'CCCCCC']
                    ]
                ]
            ],
        ];
    }

    public function columnWidths(): array
    {
        return [
            'A' => 20,  // Código Estudante
            'B' => 15,  // Valor
            'C' => 40,  // Descrição
            'D' => 25,  // Mês
            'E' => 10,  // Ano
            'F' => 18,  // Validade (dias)
            'G' => 18,  // Data Início
        ];
    }
}
