<?php

namespace App\Http\Livewire\Admin\Category;

use App\Models\Category;
use App\Models\Book;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Livewire\WithPagination;
use Note\Note;

class ListCategories extends Component
{
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        $this->delete = Category::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        $check = Book::query()->where('category_id', $this->delete->id)->get();
        if (count($check) >= 1) {
            $this->alert('warning', 'Desculpe, este modelo tem subscritores.');
            return back();
        }
        Category::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(Admin::class, 'Categoria', 'Deletado com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Deletado com sucesso ');
        $this->reset();


    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function render()
    {
        return view('livewire.admin.category.list-categories', [
                'models' => $this->readyToLoad
                    ? Category::query()
                        ->latest('updated_at')
                        ->where(function ($query) {
                            $query->orWhere('name', 'like', '%' . $this->search . '%')
                                ->orWhere('slug', 'like', '%' . $this->search . '%');
                        })
                        ->paginate(10)
                    : []
            ]
        );
    }
}
