<?php

namespace App\Http\Livewire\Auth\Admin;

use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Illuminate\Contracts\Auth\Authenticatable;
use Livewire\Component;

class AdminLogin extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use LivewireAlert;

    public $email;
    public $password;
    public $remember;

    protected array $rules = [
        'email' => ['required', 'string', 'email', 'exists:admins'],
        'password' => ['required', 'string'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    /**
     * login the user here
     * @return RedirectResponse
     */
    public function login()
    {
        $this->validate();

        if (Auth::guard('admin')->attempt(['email' => $this->email, 'password' => $this->password, 'is_active' => true], $this->remember)) {
            // Authentication passed...
            return redirect()->route('admin.home');
        }

        $this->reset(['password']);
        $this->alert('error', 'As credenciais fornecidas não correspondem aos nossos registros.');
    }

    public function render()
    {
        return view('livewire.auth.admin.admin-login')->layout('layouts.auth');
    }
}
