<?php

namespace App\Http\Livewire\Guardian;

use App\Models\Exam;
use App\Models\ExamConfiguration;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class Notas extends Component
{
    public $search;
    public $years = [];

    protected $listeners = ['studentSwitched' => '$refresh'];

    public function mount()
    {
        $this->search = Carbon::now()->year;
        $this->years  = array_combine(
            range(Carbon::now()->year, 2023),
            range(Carbon::now()->year, 2023)
        );
        $this->years[Carbon::now()->year] = 'Ano Corrente';
    }

    public function getActiveStudentProperty(): ?User
    {
        $id = Session::get('guardian_student_id');
        $g  = Auth::guard('guardian')->user();
        if (!$id || !$g) return null;
        return $g->students()->with('classroom')->find($id);
    }

    public function render()
    {
        $st     = $this->active_student;
        $models = collect([]);

        if ($st) {
            $models = Exam::where('student_id', $st->id)
                ->where('trimester_id', 1)
                ->where('year', $this->search)
                ->with('subject')
                ->latest('updated_at')
                ->get();
        }

        return view('livewire.guardian.notas', [
            'active_student' => $st,
            'models'         => $models,
            'years'          => $this->years,
            'search'         => $this->search,
        ])->layout('layouts.app');
    }
}
