<?php

namespace App\Http\Livewire\Guardian;

use App\Models\PaymentReference;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class Pagamentos extends Component
{
    public $selectedYear;

    protected $listeners = ['studentSwitched' => '$refresh'];

    public function mount()
    {
        $this->selectedYear = now()->year;
    }

    public function getActiveStudentProperty(): ?User
    {
        $id = Session::get('guardian_student_id');
        $g  = Auth::guard('guardian')->user();
        if (!$id || !$g) return null;
        return $g->students()->with('classroom')->find($id);
    }

    public function render()
    {
        $st   = $this->active_student;
        $year = $this->selectedYear ?? date('Y');

        $payment_references = collect([]);
        $totalExpected = 0;
        $totalPaid     = 0;
        $totalPending  = 0;
        $totalOverdue  = 0;

        if ($st) {
            $payment_references = PaymentReference::where('student_id', $st->id)
                ->where('fee_year', $year)
                ->whereIn('approval_status', ['approved', 'pending_approval'])
                ->latest()
                ->get();

            foreach ($payment_references as $ref) {
                $amount = (float) ($ref->amount ?? 0);
                $totalExpected += $amount;
                if ($ref->status === 'paid') {
                    $totalPaid += $amount;
                } elseif ($ref->expires_at && $ref->expires_at < now() && $ref->status !== 'paid') {
                    $totalOverdue += $amount;
                } else {
                    $totalPending += $amount;
                }
            }
        }

        $paidPercentage = $totalExpected > 0 ? round(($totalPaid / $totalExpected) * 100, 1) : 0;

        return view('livewire.guardian.pagamentos', [
            'active_student'    => $st,
            'payment_references'=> $payment_references,
            'totalExpected'     => $totalExpected,
            'totalPaid'         => $totalPaid,
            'totalPending'      => $totalPending,
            'totalOverdue'      => $totalOverdue,
            'paidPercentage'    => $paidPercentage,
            'currentYear'       => $year,
        ])->layout('layouts.app');
    }
}
