<?php

namespace App\Http\Livewire\User;

use App\Models\Classroom;
use App\Models\Exam;
use App\Models\Subject;
use App\Models\Downloadsetings;
use App\Models\EnrollmentRenewal;
use App\Models\PaymentConfirmation;
use App\Models\Noticeboard;
use App\Models\SystemSetting;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use App\Charts\UserChart;
use App\Charts\UserPieChart;
use App\Models\Admin;
use Carbon\Carbon;

class UserHome extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use FindGuard;

    public $account;
    public $orders;
    public $user;
    private $seo_pie_chart;
    private $chart3;
    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    // public function charts()
    // {

    //     //seo chart graph
    //     // line  chart for users
    //     $answer = new Exam();
    //     $days = [];

    //     // get the days in names like Monday,Tuesday and so on...
    //     for ($i = 0; $i < 7; $i++) {
    //         $days[] = Carbon::now()->subDays($i)->format('d');
    //     }
    //     $answers = $answer
    //         ->oldest()
    //         ->select('updated_at')
    //         ->whereDate('updated_at', '>=', today()->subDays(6)->format('Y-m-d'))
    //         ->whereDate('updated_at', '<=', today()->format('Y-m-d'))
    //         ->get()
    //         ->groupBy(fn($val) => Carbon::parse($val->updated_at)->format('d'));

    //     $this->chart3 = new UserChart();
    //     $this->chart3->labels(['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab']);
    //     $this->chart3->dataset('Coleções semanais', 'line', [
    //         isset($answers[$days[6]]) ? count($answers[$days[6]]) : 0,
    //         isset($answers[$days[5]]) ? count($answers[$days[5]]) : 0,
    //         isset($answers[$days[4]]) ? count($answers[$days[4]]) : 0,
    //         isset($answers[$days[3]]) ? count($answers[$days[3]]) : 0,
    //         isset($answers[$days[2]]) ? count($answers[$days[2]]) : 0,
    //         isset($answers[$days[1]]) ? count($answers[$days[1]]) : 0,
    //         isset($answers[$days[0]]) ? count($answers[$days[0]]) : 0
    //     ])->backgroundcolor('#ffc107')->color('#0000ff');

    //     //seo pie chart
    //     $this->seo_pie_chart = new UserPieChart();
    //     $this->seo_pie_chart->labels(['Testes', 'Disciplinas', 'Professores']);
    //     $this->seo_pie_chart->dataset('Testes', 'pie', [
    //         count(Exam::query()->get()->where('student_id', $this->user->id)),
    //         count(Subject::query()->get()),
    //         count(Classroom::query()->get())
    //     ])->backgroundColor(collect(['#7158e2', '#3ae374', '#ff3838', '#ffc107']))->color(collect(['#7d5fff', '#32ff7e', '#ff4d4d', '#0000ff']));
    //     return [
    //         $this->seo_pie_chart,
    //         $this->chart3,
    //     ];
    // }

    public function render()
    {
        $this->user = $this->findGuardType()->user();

        // Buscar informações da turma/classe do estudante
        $classroom = Classroom::find($this->user->classroom_id);

        $classs =  \App\Models\TeacherSubject::query()->where("classroom_id",$this->user->classroom_id)->count() ?? 0;

        return view('livewire.user.user-home', [
            'exams' => $this->readyToLoad ? count(Exam::query()->where('student_id', $this->user->id)->get()) : 0,
            'subjects' => $classs,
            'teachers' => $this->readyToLoad ? count(Admin::query()->where('role', 2)->get()) : 0,
            'classes' => $this->readyToLoad ? count(Classroom::query()->get()) : 0,
            'notifications' => Downloadsetings::query()->orWhere("type","all")->orWhere("class_id",$this->user->classroom_id)->count(),
            'notifications_payment' => PaymentConfirmation::query()->where(function ($query) {
                                   $query->where('student_id', $this->user->id)
                                   ->where('class_id', $this->user->classroom_id);
                                    })
                                   ->orWhere('type', 'all')
                                   ->count(),
            'noticeboard' => Noticeboard::query()->where(function($q) {
                    $q->where("type","all")->orWhere("class_id",$this->user->classroom_id);
                })->latest()->take(4)->get(),

            // Informações adicionais do estudante
            'classroom_name' => $classroom->name ?? 'N/A',
            'class_grade' => $classroom->class ?? 'N/A',
            'academic_year' => now()->year,

            // Renovação de matrícula
            'renewalOpen' => (bool) SystemSetting::get('renewal_period_open', false, 'enrollment'),
            'renewalYear' => (string) SystemSetting::get('renewal_academic_year', (string) now()->year, 'enrollment'),
            'studentRenewal' => EnrollmentRenewal::where('student_id', $this->user->id)
                ->where('academic_year', SystemSetting::get('renewal_academic_year', (string) now()->year, 'enrollment'))
                ->first(),
        ]);
    }
}
