<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class EnrollmentRenewal extends Model
{
    use Uuids, SoftDeletes;

    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'student_id',
        'from_classroom_id',
        'to_classroom_id',
        'from_class',
        'to_class',
        'academic_year',
        'status',
        'confirmed_by',
        'confirmed_at',
        'cancelled_at',
        'transitioned_at',
        'notes',
    ];

    protected $casts = [
        'confirmed_at'    => 'datetime',
        'cancelled_at'    => 'datetime',
        'transitioned_at' => 'datetime',
    ];

    public function student(): BelongsTo
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function fromClassroom(): BelongsTo
    {
        return $this->belongsTo(Classroom::class, 'from_classroom_id');
    }

    public function toClassroom(): BelongsTo
    {
        return $this->belongsTo(Classroom::class, 'to_classroom_id');
    }

    public function confirmedBy(): BelongsTo
    {
        return $this->belongsTo(Admin::class, 'confirmed_by');
    }

    public function scopePendente($query)
    {
        return $query->where('status', 'pendente');
    }

    public function scopeConfirmada($query)
    {
        return $query->where('status', 'confirmada');
    }

    public function scopeCancelada($query)
    {
        return $query->where('status', 'cancelada');
    }

    public function isPendente(): bool
    {
        return $this->status === 'pendente';
    }

    public function isConfirmada(): bool
    {
        return $this->status === 'confirmada';
    }

    public function isTransitioned(): bool
    {
        return $this->transitioned_at !== null;
    }

    public function scopeNotTransitioned($query)
    {
        return $query->whereNull('transitioned_at');
    }
}
