<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeType extends Model
{
    use HasFactory;

    protected $table = 'fee_type';

    protected $fillable = [
        'name',
        'fees_code',
        'description',
        'iva_applicable',
        'price_includes_iva',
        'default_price',
        'iva_notes',
    ];

    protected $casts = [
        'iva_applicable' => 'boolean',
        'price_includes_iva' => 'boolean',
        'default_price' => 'decimal:2',
    ];

    /**
     * Get the fee masters associated with this fee type
     */
    public function feeMasters()
    {
        return $this->hasMany(FeeMaster1::class, 'fee_type_id');
    }

    /**
     * Scope to get fee types with IVA applicable
     */
    public function scopeWithIva($query)
    {
        return $query->where('iva_applicable', true);
    }

    /**
     * Scope to get fee types without IVA
     */
    public function scopeWithoutIva($query)
    {
        return $query->where('iva_applicable', false);
    }
}
