<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fee_assign extends Model
{
    use HasFactory;
    protected $table = 'fee_assign';
    protected $fillable = [
        'student_id',
        'fee_group_id',
        'status',
        'day',
        'month',
        'year',
        'pay_type',
        'pay_id',
        'pay_day',
        'pay_month',
        'pay_year',
        'discount',
        'fine',
        'amount',
        'transaction_id',
        'reference_number',
        'payment_date'
    ];

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function feeGroup()
    {
        return $this->belongsTo(FeeStructure::class, 'fee_group_id');
    }

    public function paymentReference()
    {
        return $this->hasOne(PaymentReference::class, 'student_id', 'student_id')
            ->where('fee_month', $this->month)
            ->where('fee_year', $this->year);
    }

    public function receiptNumber()
    {
        return $this->hasOne(ReceiptNumber::class, 'record_id', 'id')
            ->where('receipt_type', 'fee_assign');
    }
}
