<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Illuminate\Database\Eloquent\SoftDeletes;

class SendSms extends Model
{
    //use HasFactory;
    use HasFactory, Uuids, SoftDeletes, HasSlug;
    protected $fillable = [
        'title',
        'type',
        'class_id',
        'student_id',
        'description',
        'slug',
        'media_name',
        'media_url',
        'created_by',
        'total_sent',
        'success_count',
        'fail_count'
    ];


    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug')
            ->slugsShouldBeNoLongerThan(200);
    }
}
