<?php

namespace App\Models;

use App\Traits\Uuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SmsLog extends Model
{
    use HasFactory, Uuids;

    protected $table = 'sms_logs';

    protected $fillable = [
        'gateway',
        'phone_number',
        'message',
        'message_id',
        'status',
        'error',
        'response',
        'scheduled_at',
        'sent_by',
    ];

    protected $casts = [
        'scheduled_at' => 'datetime',
    ];

    /**
     * Scope for successful messages
     */
    public function scopeSent($query)
    {
        return $query->where('status', 'sent');
    }

    /**
     * Scope for failed messages
     */
    public function scopeFailed($query)
    {
        return $query->where('status', 'failed');
    }

    /**
     * Scope for a specific gateway
     */
    public function scopeGateway($query, string $gateway)
    {
        return $query->where('gateway', $gateway);
    }

    /**
     * Get the user who sent this SMS
     */
    public function sender()
    {
        return $this->belongsTo(Admin::class, 'sent_by');
    }
}
