<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Blade;
use App\Models\PaymentReference;
use App\Observers\PaymentReferenceObserver;
use Carbon\Carbon;



class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot()
    {
        JsonResource::withoutWrapping();

        // Configurar locale para português
        setlocale(LC_TIME, 'pt_PT.utf8', 'pt_BR.utf8', 'portuguese');
        Carbon::setLocale('pt_BR');

        // Set global JSON response behavior
        response()->macro('json', function ($value = null, $status = 200, array $headers = [], $options = 0) {
            return response()->json($value, $status, $headers, $options | JSON_UNESCAPED_UNICODE);
        });

        // Register observers
        PaymentReference::observe(PaymentReferenceObserver::class);

        // Register custom Blade directives for admin permissions
        $this->registerBladeDirectives();
    }

    /**
     * Register custom Blade directives for permission checks
     */
    protected function registerBladeDirectives()
    {
        // @hasPermission('permission.key')
        Blade::if('hasPermission', function ($permission) {
            $admin = auth()->guard('admin')->user();
            return $admin && $admin->hasPermission($permission);
        });

        // @canAdmin('permission.key')
        Blade::if('canAdmin', function ($permission) {
            $admin = auth()->guard('admin')->user();
            return $admin && $admin->hasPermission($permission);
        });

        // @isPca - Check if current admin is PCA (Super Admin)
        Blade::if('isPca', function () {
            $admin = auth()->guard('admin')->user();
            return $admin && $admin->isPca();
        });

        // @hasRole(1) - Check if admin has specific role
        Blade::if('hasRole', function ($role) {
            $admin = auth()->guard('admin')->user();
            return $admin && $admin->role == $role;
        });

        // @hasAnyPermission(['perm1', 'perm2'])
        Blade::if('hasAnyPermission', function ($permissions) {
            $admin = auth()->guard('admin')->user();
            if (!$admin) {
                return false;
            }
            foreach ($permissions as $permission) {
                if ($admin->hasPermission($permission)) {
                    return true;
                }
            }
            return false;
        });

        // @hasAllPermissions(['perm1', 'perm2'])
        Blade::if('hasAllPermissions', function ($permissions) {
            $admin = auth()->guard('admin')->user();
            if (!$admin) {
                return false;
            }
            foreach ($permissions as $permission) {
                if (!$admin->hasPermission($permission)) {
                    return false;
                }
            }
            return true;
        });
    }
}
