<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exams', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('trimester_id')->nullable();
            $table->string('student_id')->nullable();
            $table->string('subject_id')->nullable();
            $table->string('classroom_id')->nullable();
            $table->string('ACS1a')->default(0);
            $table->string('ACS2a')->default(0);
            $table->string('MACS')->nullable();
            $table->string('AT')->nullable();
            $table->string('MT')->nullable();
	 $table->string('year')->nullable();
            $table->boolean('is_active')->default(true);
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exams');
    }
};
