<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('group', 50)->default('general'); // sms, email, payment, etc.
            $table->string('key', 100);
            $table->text('value')->nullable();
            $table->string('type', 20)->default('string'); // string, boolean, number, json
            $table->string('description')->nullable();
            $table->timestamps();

            // Unique key per group
            $table->unique(['group', 'key']);
            $table->index('group');
        });

        // Insert default SMS settings
        $this->seedDefaultSmsSettings();
    }

    /**
     * Seed default SMS settings
     */
    private function seedDefaultSmsSettings(): void
    {
        $settings = [
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'gateway',
                'value' => 'movitel',
                'type' => 'string',
                'description' => 'Gateway SMS activo (movitel ou twilio)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'movitel_api_url',
                'value' => 'https://sms.itcore.app/api/http/sms/send',
                'type' => 'string',
                'description' => 'URL da API Movitel/ITCORE',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'movitel_api_token',
                'value' => '',
                'type' => 'string',
                'description' => 'Token da API Movitel/ITCORE',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'movitel_sender_id',
                'value' => 'COPMOZ',
                'type' => 'string',
                'description' => 'Sender ID para Movitel',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'twilio_sid',
                'value' => '',
                'type' => 'string',
                'description' => 'Twilio Account SID',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'twilio_token',
                'value' => '',
                'type' => 'string',
                'description' => 'Twilio Auth Token',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'twilio_from',
                'value' => 'COPMOZ',
                'type' => 'string',
                'description' => 'Twilio From Number/Name',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'country_code',
                'value' => '258',
                'type' => 'string',
                'description' => 'Código do país (Moçambique: 258)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id' => \Illuminate\Support\Str::uuid(),
                'group' => 'sms',
                'key' => 'log_messages',
                'value' => 'true',
                'type' => 'boolean',
                'description' => 'Guardar log de mensagens enviadas',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        \Illuminate\Support\Facades\DB::table('system_settings')->insert($settings);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('system_settings');
    }
};
