<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('pos_sales', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('sale_number')->unique(); // POS-2025-00001
            $table->uuid('user_id')->nullable(); // Estudante (opcional)
            $table->uuid('cashier_id'); // Admin/Funcionário que fez a venda

            $table->decimal('subtotal', 10, 2);
            $table->decimal('discount', 10, 2)->default(0);
            $table->decimal('tax', 10, 2)->default(0); // IVA se aplicável
            $table->decimal('total', 10, 2);

            $table->enum('payment_method', ['cash', 'mpesa', 'emola', 'bank_transfer', 'credit']); // Métodos de pagamento
            $table->enum('status', ['completed', 'pending', 'cancelled'])->default('completed');

            $table->text('notes')->nullable();
            $table->timestamp('sale_date');

            $table->timestamps();
            $table->softDeletes();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('pos_sales');
    }
};
