<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('receipt_numbers')) {
            Schema::create('receipt_numbers', function (Blueprint $table) {
                $table->id();
                $table->string('receipt_type', 20)->comment('fee_assign ou payment_reference');
                $table->unsignedBigInteger('record_id')->comment('ID do registro original');
                $table->string('receipt_number', 20)->unique()->comment('Número do recibo (ex: 000001/2025)');
                $table->timestamp('issued_at')->comment('Data de emissão do recibo');
                $table->string('issued_by', 50)->comment('admin ou student');
                $table->unsignedBigInteger('user_id')->nullable()->comment('ID do usuário que gerou');
                $table->timestamps();

                // Índices para performance
                $table->index(['receipt_type', 'record_id']);
                $table->index('issued_at');
                $table->index('issued_by');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('receipt_numbers');
    }
};
