<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            if (!Schema::hasColumn('payment_references', 'valid_from')) {
                $table->dateTime('valid_from')->nullable()->after('reference_number');
            }
            if (!Schema::hasColumn('payment_references', 'classe')) {
                $table->string('classe')->nullable()->after('student_id');
            }
            if (!Schema::hasColumn('payment_references', 'turma')) {
                $table->string('turma')->nullable()->after('classe');
            }
            if (!Schema::hasColumn('payment_references', 'academic_year')) {
                $table->string('academic_year', 20)->nullable()->after('fee_year');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            $table->dropColumn(['valid_from', 'classe', 'turma', 'academic_year']);
        });
    }
};
