<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            // Campo para controlar o 2º lembrete (1 dia antes)
            $table->boolean('reminder_sent_final')->default(false)->after('reminder_sent_at');
            $table->timestamp('reminder_sent_final_at')->nullable()->after('reminder_sent_final');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_references', function (Blueprint $table) {
            $table->dropColumn(['reminder_sent_final', 'reminder_sent_final_at']);
        });
    }
};
