<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('pre_enrollments', function (Blueprint $table) {
            // Dados pessoais extra
            $table->string('marital_status')->nullable()->after('candidate_origin');
            $table->string('nationality')->nullable()->after('marital_status');
            $table->string('nuit')->nullable()->after('nationality');
            $table->boolean('chronic_disease')->default(false)->after('nuit');
            $table->string('chronic_disease_details')->nullable()->after('chronic_disease');

            // Documento extra
            $table->string('document_issue_place')->nullable()->after('document_id');
            $table->date('document_expiry_date')->nullable()->after('document_issue_place');

            // Morada (residência)
            $table->string('address_province')->nullable()->after('candidate_address');
            $table->string('address_district')->nullable()->after('address_province');
            $table->string('address_bairro')->nullable()->after('address_district');
            $table->string('address_street')->nullable()->after('address_bairro');
            $table->string('address_house_number')->nullable()->after('address_street');
            $table->string('candidate_whatsapp')->nullable()->after('candidate_phone');

            // Filiação extra
            $table->string('father_phone')->nullable()->after('father_name');
            $table->string('mother_phone')->nullable()->after('mother_name');

            // Contacto emergência
            $table->string('emergency_contact_name')->nullable()->after('guardian_address');
            $table->string('emergency_contact_phone')->nullable()->after('emergency_contact_name');

            // Académico extra
            $table->string('desired_shift')->nullable()->after('desired_classroom_id');

            // Encarregado extra (para Termo de Compromisso)
            $table->string('guardian_document_id')->nullable()->after('guardian_address');
            $table->string('guardian_document_issue_place')->nullable()->after('guardian_document_id');
            $table->date('guardian_document_issue_date')->nullable()->after('guardian_document_issue_place');
            $table->string('guardian_bairro')->nullable()->after('guardian_document_issue_date');
            $table->string('guardian_quarteirao')->nullable()->after('guardian_bairro');
            $table->string('guardian_workplace')->nullable()->after('guardian_quarteirao');
        });
    }

    public function down(): void
    {
        Schema::table('pre_enrollments', function (Blueprint $table) {
            $table->dropColumn([
                'marital_status', 'nationality', 'nuit',
                'chronic_disease', 'chronic_disease_details',
                'document_issue_place', 'document_expiry_date',
                'address_province', 'address_district', 'address_bairro',
                'address_street', 'address_house_number', 'candidate_whatsapp',
                'father_phone', 'mother_phone',
                'emergency_contact_name', 'emergency_contact_phone',
                'desired_shift',
                'guardian_document_id', 'guardian_document_issue_place',
                'guardian_document_issue_date', 'guardian_bairro',
                'guardian_quarteirao', 'guardian_workplace',
            ]);
        });
    }
};
