<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Fee_assign;
use App\Models\User;
use App\Models\FeeStructure;
use Carbon\Carbon;

class TestPaymentSeeder extends Seeder
{
    public function run()
    {
        // Get first student and fee group
        $student = User::first();
        $feeGroup = FeeStructure::first();
        
        if (!$student || !$feeGroup) {
            $this->command->error('Necessário ter pelo menos 1 estudante e 1 estrutura de taxas');
            return;
        }

        // Create payments for last 7 days with varying amounts
        $amounts = [1500, 2300, 1800, 2500, 1200, 3000, 2200];
        
        for ($i = 6; $i >= 0; $i--) {
            $date = Carbon::now()->subDays($i);
            
            // Create 1-3 payments per day
            $paymentsPerDay = rand(1, 3);
            
            for ($j = 0; $j < $paymentsPerDay; $j++) {
                Fee_assign::create([
                    'student_id' => $student->id,
                    'fee_group_id' => $feeGroup->id,
                    'status' => 'paid',
                    'day' => $date->day,
                    'month' => $date->month,
                    'year' => $date->year,
                    'pay_type' => 'cash',
                    'pay_id' => null,
                    'pay_day' => $date->day,
                    'pay_month' => $date->month,
                    'pay_year' => $date->year,
                    'discount' => 0,
                    'fine' => 0,
                    'amount' => $amounts[$i] + rand(-300, 300),
                    'created_at' => $date,
                    'updated_at' => $date,
                ]);
            }
        }
        
        $this->command->info('Dados de teste de pagamento criados com sucesso!');
    }
}
