<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Fee_assign;
use App\Models\User;
use App\Models\FeeStructure;
use Carbon\Carbon;

class TestPaymentSeeder6Months extends Seeder
{
    public function run()
    {
        $student = User::first();
        $feeGroup = FeeStructure::first();
        
        if (!$student || !$feeGroup) {
            $this->command->error('Necessário ter pelo menos 1 estudante e 1 estrutura de taxas');
            return;
        }

        // Criar pagamentos para os últimos 6 meses (1 por semana)
        $weeksToCreate = 24; // ~6 meses
        
        for ($i = $weeksToCreate; $i >= 0; $i--) {
            $date = Carbon::now()->subWeeks($i);
            
            // Criar 1-2 pagamentos por semana
            $paymentsPerWeek = rand(1, 2);
            
            for ($j = 0; $j < $paymentsPerWeek; $j++) {
                $paymentDate = $date->copy()->addDays(rand(0, 6));
                
                Fee_assign::create([
                    'student_id' => $student->id,
                    'fee_group_id' => $feeGroup->id,
                    'status' => 'paid',
                    'day' => $paymentDate->day,
                    'month' => $paymentDate->month,
                    'year' => $paymentDate->year,
                    'pay_type' => 'cash',
                    'pay_id' => null,
                    'pay_day' => $paymentDate->day,
                    'pay_month' => $paymentDate->month,
                    'pay_year' => $paymentDate->year,
                    'discount' => 0,
                    'fine' => 0,
                    'amount' => rand(1500, 3500),
                    'created_at' => $paymentDate,
                    'updated_at' => $paymentDate,
                ]);
            }
        }
        
        $this->command->info('Dados de teste para 6 meses criados com sucesso!');
    }
}
