<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">Editar Staff</h5>
                            <form class="row g-3" wire:submit.prevent="submit">
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Nome completo</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror"
                                           id="name" required placeholder="Insira o nome completo..." wire:model="name">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Número celular</label>
                                    <input type="text" class="form-control @error('phone_number') is-invalid @enderror"
                                           id="phone_number" required placeholder="Insira o número celular..."
                                           wire:model="phone_number">
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <label for="title" class="form-label">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror"
                                           id="email" required placeholder="Insira o email..." wire:model="email">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                    <div class="col-md-6">
                                    <label for="title" class="form-label">Role/Função </label>
                                    <select class="form-control @error('role') is-invalid @enderror"
                                            id="role" wire:model="role"
                                            class="form-control input-lg dynamic">
                                        <option value="">Selecione o role</option>
                                        <option value="0">🔴 PCA (Super Admin)</option>
                                        <option value="1">🟡 Reg Academico</option>
                                        <option value="2">🔵 Professor</option>
                                        <option value="3">🟢 Diretor</option>
                                        <option value="4">🟣 Admin</option>
                                        <option value="5">⚫ Contabilidade</option>
                                        <option value="6">⚪ Secretaria</option>
                                    </select>
                                    @error('role')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="col-md-6">
                                    <input type="checkbox" class="form-check-input" id="exampleCheck1"
                                           {{ $is_active ? 'checked' : '' }}
                                           wire:model="is_active">
                                    <label class="switch pr-5 switch-primary mr-3"
                                           for="exampleCheck1">{{ $is_active ? 'Activo' : 'Inactivo' }}</label>
                                </div>

                                <div class="col-12 d-flex justify-content-between align-items-center mt-3">
                                    <!-- Botão para regenerar senha -->
                                    <button type="button" class="btn btn-danger"
                                            wire:click="generateAndSendNewPassword"
                                            wire:loading.attr="disabled"
                                            wire:target="generateAndSendNewPassword">
                                        <span wire:loading wire:target="generateAndSendNewPassword" class="spinner-border spinner-border-sm me-1"></span>
                                        <i wire:loading.remove wire:target="generateAndSendNewPassword" class="fas fa-key me-1"></i>
                                        Regenerar Senha
                                    </button>

                                    <button type="submit" class="btn btn-primary btn-lg"
                                            wire:loading.class="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:target="submit" wire:loading.class="spinner-border spinner-border-sm me-1"></span>
                                        <i wire:loading.remove wire:target="submit" class="fas fa-save me-1"></i>
                                        Guardar
                                    </button>
                                </div>
                            </form>
                            <hr>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
