<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card border-0 shadow">
                        <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                            <h2 class="h5 mb-0">
                                <i class="fas fa-edit me-2"></i>Editar Categoria
                            </h2>
                            <a href="{{ url()->previous() }}" class="btn btn-light btn-sm">
                                <i class="fas fa-arrow-left me-1"></i>Voltar
                            </a>
                        </div>
                        <div class="card-body p-4">
                            <div class="row justify-content-center">
                                <div class="col-12 col-md-10 col-lg-8 col-xl-7">
                                    <form wire:submit.prevent="submit">
                                        <div class="mb-3">
                                            <label for="name" class="form-label fw-semibold">Nome <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light"><i class="fas fa-tag"></i></span>
                                                <input type="text"
                                                       class="form-control @error('name') is-invalid @enderror"
                                                       id="name"
                                                       wire:model="name"
                                                       placeholder="Insira o nome da categoria..."
                                                       required>
                                            </div>
                                            @error('name')
                                                <div class="invalid-feedback d-block">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="d-flex justify-content-end border-top pt-4 mt-4">
                                            <button type="submit"
                                                    class="btn btn-primary px-5"
                                                    wire:loading.attr="disabled"
                                                    wire:target="submit">
                                                <span wire:loading wire:target="submit" class="spinner-border spinner-border-sm me-2"></span>
                                                <i wire:loading.remove wire:target="submit" class="fas fa-save me-2"></i>
                                                Atualizar
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
