<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body" wire:init="loadData">
                            <h5 class="card-title"> Estudantes da: {{ $model->name }}</h5>
                            <div class="row">
                                <div class="col-md-12">
                                    <input type="search" wire:model="search" placeholder="Pesquisar..."
                                        class="form-control">
                                </div>
                            </div>
                            <div class="table-responsive" wire:init="loadData">
                                @if (count($models))
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Nome</th>
                                                <th scope="col">Sexo</th>
                                                <th scope="col">Data nascimento</th>
                                                <th scope="col">ID do Estudante</th>
                                                <th scope="col">Turma</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Ver notas</th>

                                            </tr>
                                        </thead>
                                        <tbody>
                                            @php($count = 1)
                                            @foreach ($models as $model)
                                                <tr>
                                                    <th scope="row">{{ $count++ }}</th>
                                                    <td>{{ $model->name }}</td>
                                                    <td>{{ $model->sex }}</td>
                                                    <td>{{ $model->dob }}</td>
                                                    <td>{{ $model->student_id }}</td>

                                                    <td>{{ $model->class->name }}</td>
                                                    <td>{{ $model->class->class }} &nbsp;Classe </td>
                                                    <td>
                                                        <a class="btn btn primary"
                                                                        href="{{ route('admin.edit.class.students.academic', $model->slug) }}">Visualizar</a>

                                                    </td>

                                                </tr>
                                                     @endforeach
                                        </tbody>
                                    </table>
                                    <div class="row float-end">
                                        {{ $models->links() }}
                                    </div>
                                @else
                                    <br>
                                    <br>
                                    <div class="d-flex justify-content-center">
                                        <div wire:loading class="spinner-border text-primary" role="status">
                                            <span class="sr-only">Processando...</span>
                                        </div>
                                    </div>
                                    <p class="text-center"><B>Nenhum dado foi encontrado no momento.</B></p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
