<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card" style="border: 1px solid #e2e8f0; border-radius: 0;">
                        <div class="card-body" wire:init="loadData" style="padding: 2rem;">

                            <!-- Header Section -->
                            <div class="mb-4 pb-3" style="border-bottom: 2px solid #e2e8f0;">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h5 class="mb-2" style="color: #1e293b; font-weight: 600; font-size: 1.25rem; letter-spacing: -0.025em;">
                                            Notas do Estudante
                                        </h5>
                                        <p class="mb-0" style="color: #64748b; font-size: 0.95rem;">
                                            <strong style="color: #334155;">{{$model->name}}</strong> |
                                            ID: <span style="color: #64748b;">{{$model->student_id}}</span>
                                        </p>
                                    </div>
                                </div>
                            </div>

                            <!-- Filters Section -->
                            <div class="row mb-4">
                                <div class="col-md-5">
                                    <label class="form-label" style="color: #475569; font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Pesquisar por Disciplina</label>
                                    <input type="search"
                                           wire:model="search"
                                           placeholder="Digite o nome da disciplina..."
                                           class="form-control"
                                           style="border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem 0.875rem; font-size: 0.9375rem;">
                                </div>
                                <div class="col-md-3">
                                    <label class="form-label" style="color: #475569; font-size: 0.875rem; font-weight: 500; margin-bottom: 0.5rem;">Filtrar por Trimestre</label>
                                    <select wire:model="filterTrimester" class="form-select" style="border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem 0.875rem; font-size: 0.9375rem;">
                                        <option value="">Todos os Trimestres</option>
                                        <option value="1">1º Trimestre</option>
                                        <option value="2">2º Trimestre</option>
                                        <option value="3">3º Trimestre</option>
                                    </select>
                                </div>
                                <div class="col-md-2 d-flex align-items-end">
                                    @if($search || $filterTrimester)
                                        <button wire:click="$set('search', ''); $set('filterTrimester', '')"
                                                class="btn w-100"
                                                style="background-color: #f1f5f9; color: #475569; border: 1px solid #cbd5e1; border-radius: 0; padding: 0.625rem; font-size: 0.875rem; font-weight: 500;">
                                            Limpar Filtros
                                        </button>
                                    @endif
                                </div>
                            </div>

                            <!-- Tables Grid -->
                            <div class="row">
                                @php
                                    $teachers = [];
                                @endphp
                                @foreach($teacher as $teach)
                                    @php
                                        $teachers[] = $teach->subject_id;
                                    @endphp
                                @endforeach

                                <!-- 1st Trimester -->
                                <div class="col-md-4">
                                    <div class="mb-4" style="border: 1px solid #e2e8f0;">
                                        <div class="px-3 py-2" style="background-color: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                                            <h6 class="mb-0" style="color: #1e293b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                                                1º Trimestre
                                            </h6>
                                        </div>
                                        <div class="table-responsive" wire:init="loadData">
                                            @if(count($models))
                                                <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                    <thead style="background-color: #f1f5f9;">
                                                        <tr>
                                                            <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">MACS</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                            <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($models->where('trimester_id', 1)->sortBy('subject.name') as $model)
                                                            @if(in_array( $model->subject->id,$teachers))
                                                            <tr style="border-bottom: 1px solid #f1f5f9;">
                                                                <td style="color: #1e293b; font-weight: 500; padding: 0.625rem 0.75rem;">{{ $model->subject->name }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model->ACS1a, 1) }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model->ACS2a, 1) }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem; background-color: #fafafa;">{{ number_format(($model->ACS2a + $model->ACS1a) * 0.5, 1) }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model->AT, 1) }}</td>
                                                                <td class="text-center" style="color: #1e293b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #e0e7ff;">{{ round((($model->ACS2a + $model->ACS1a)  + $model->AT) /3) }}</td>
                                                            </tr>
                                                            @endif
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            @else
                                                <div class="text-center py-4">
                                                    <p class="text-muted mb-0" style="font-size: 0.875rem;">Nenhum dado disponível</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- 2nd Trimester -->
                                <div class="col-md-4">
                                    <div class="mb-4" style="border: 1px solid #e2e8f0;">
                                        <div class="px-3 py-2" style="background-color: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                                            <h6 class="mb-0" style="color: #1e293b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                                                2º Trimestre
                                            </h6>
                                        </div>
                                        <div class="table-responsive" wire:init="loadData">
                                            @if(count($models))
                                                <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                    <thead style="background-color: #f1f5f9;">
                                                        <tr>
                                                            <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">MACS</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                            <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($models->where('trimester_id', 2)->sortBy('subject.name') as $model2)
                                                        @if(in_array( $model2->subject->id,$teachers))
                                                            <tr style="border-bottom: 1px solid #f1f5f9;">
                                                                <td style="color: #1e293b; font-weight: 500; padding: 0.625rem 0.75rem;">{{ $model2->subject->name }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model2->ACS1a, 1) }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model2->ACS2a, 1) }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem; background-color: #fafafa;">{{ number_format(($model2->ACS2a + $model2->ACS1a) * 0.5, 1) }}</td>
                                                                <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model2->AT, 1) }}</td>
                                                                <td class="text-center" style="color: #1e293b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #e0e7ff;">{{ round((($model2->ACS2a + $model2->ACS1a)  + $model2->AT) /3) }}</td>
                                                            </tr>
                                                         @endif
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            @else
                                                <div class="text-center py-4">
                                                    <p class="text-muted mb-0" style="font-size: 0.875rem;">Nenhum dado disponível</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <!-- 3rd Trimester -->
                                <div class="col-md-4">
                                    <div class="mb-4" style="border: 1px solid #e2e8f0;">
                                        <div class="px-3 py-2" style="background-color: #f8fafc; border-bottom: 1px solid #e2e8f0;">
                                            <h6 class="mb-0" style="color: #1e293b; font-size: 0.875rem; font-weight: 600; text-transform: uppercase; letter-spacing: 0.05em;">
                                                3º Trimestre
                                            </h6>
                                        </div>
                                        <div class="table-responsive" wire:init="loadData">
                                            @if(count($models))
                                                <table class="table table-sm mb-0" style="font-size: 0.875rem;">
                                                    <thead style="background-color: #f1f5f9;">
                                                        <tr>
                                                            <th style="color: #64748b; font-weight: 600; padding: 0.625rem 0.75rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">Disciplina</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS1</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">ACS2</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">MACS</th>
                                                            <th class="text-center" style="color: #64748b; font-weight: 600; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0;">AT</th>
                                                            <th class="text-center" style="color: #1e293b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #e0e7ff;">MT</th>
                                                            @php
                                                                $hasNEColumn = false;
                                                                $neColumnLabel = 'NE';
                                                                $class_id = 0;
                                                                $year = date('Y');

                                                                // Primeiro, obter a classe e ano do primeiro registro do 3º trimestre
                                                                foreach($models->where('trimester_id', 3) as $model3) {
                                                                    if(in_array($model3->subject->id, $teachers)) {
                                                                        $class_id = \App\Models\Classroom::query()->where("id", $model3->classroom_id)->first()->class ?? 0;
                                                                        $year = $model3->year ?? date('Y');
                                                                        break;
                                                                    }
                                                                }

                                                                // Usar o sistema dinâmico de configuração de exames
                                                                if ($class_id > 0) {
                                                                    $current_ne_subjects = \App\Models\ExamConfiguration::getSubjectsWithExam($class_id, null, $year);

                                                                    // Verificar se há alguma disciplina do professor que tenha exame configurado
                                                                    foreach($models->where('trimester_id', 3) as $model3) {
                                                                        if(in_array($model3->subject->id, $teachers) && in_array($model3->subject->name, $current_ne_subjects)) {
                                                                            $hasNEColumn = true;
                                                                            $neColumnLabel = ($class_id == 3) ? 'AF' : 'NE';
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            @endphp
                                                            @if($hasNEColumn)
                                                                <th class="text-center" style="color: #991b1b; font-weight: 700; padding: 0.625rem 0.5rem; font-size: 0.75rem; text-transform: uppercase; letter-spacing: 0.05em; border-bottom: 1px solid #e2e8f0; background-color: #fee2e2;">{{ $neColumnLabel }}</th>
                                                            @endif
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @php
                                                            // Obter configurações de exame para esta turma/ano
                                                            $class_id_body = 0;
                                                            $year_body = date('Y');
                                                            $current_ne_subjects_body = [];

                                                            foreach($models->where('trimester_id', 3) as $model3_temp) {
                                                                if(in_array($model3_temp->subject->id, $teachers)) {
                                                                    $class_id_body = \App\Models\Classroom::query()->where("id", $model3_temp->classroom_id)->first()->class ?? 0;
                                                                    $year_body = $model3_temp->year ?? date('Y');
                                                                    break;
                                                                }
                                                            }

                                                            if ($class_id_body > 0) {
                                                                $current_ne_subjects_body = \App\Models\ExamConfiguration::getSubjectsWithExam($class_id_body, null, $year_body);
                                                            }
                                                        @endphp

                                                        @foreach($models->where('trimester_id', 3)->sortBy('subject.name') as $model3)
                                                            @if(in_array( $model3->subject->id,$teachers))
                                                                <tr style="border-bottom: 1px solid #f1f5f9;">
                                                                    <td style="color: #1e293b; font-weight: 500; padding: 0.625rem 0.75rem;">{{ $model3->subject->name }}</td>
                                                                    <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model3->ACS1a, 1) }}</td>
                                                                    <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model3->ACS2a, 1) }}</td>
                                                                    <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem; background-color: #fafafa;">{{ number_format(($model3->ACS2a + $model3->ACS1a) * 0.5, 1) }}</td>
                                                                    <td class="text-center" style="color: #475569; padding: 0.625rem 0.5rem;">{{ number_format($model3->AT, 1) }}</td>
                                                                    <td class="text-center" style="color: #1e293b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #e0e7ff;">{{ round((($model3->ACS2a + $model3->ACS1a)  + $model3->AT) /3) }}</td>

                                                                    @if(in_array($model3->subject->name, $current_ne_subjects_body))
                                                                        <td class="text-center" style="color: #991b1b; font-weight: 600; padding: 0.625rem 0.5rem; background-color: #fee2e2;">{{ number_format(floatval($model3->NE ?? 0), 1) }}</td>
                                                                    @endif
                                                                </tr>
                                                            @endif
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            @else
                                                <div class="text-center py-4">
                                                    <p class="text-muted mb-0" style="font-size: 0.875rem;">Nenhum dado disponível</p>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

