<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-dark fw-bold">
                            <i class="fas fa-file-download me-2 text-primary"></i>Lista de Matrizes
                        </h1>
                        <p class="text-muted mb-0">
                            Gerencie e visualize as matrizes disponíveis no sistema
                        </p>
                    </div>
                    @if(!isset($student))
                    <div class="text-end">
                        <a href="{{ route('admin.add.download') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Nova Matriz
                        </a>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Statistics Cards -->
        @if(!isset($student))
        <div class="row mb-4">
            <div class="col-md-3 mb-3">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <div class="rounded p-3" style="background-color: #e7f3ff;">
                                    <i class="fas fa-file-alt fa-2x" style="color: #0066cc;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="text-muted mb-1 small">Total de Matrizes</h6>
                                <h3 class="mb-0 fw-bold" style="color: #0066cc;">{{ count($models) ? $models->total() : 0 }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <div class="rounded p-3" style="background-color: #e8f5e9;">
                                    <i class="fas fa-filter fa-2x" style="color: #00a65a;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="text-muted mb-1 small">Filtros Ativos</h6>
                                @php
                                    $activeFilters = 0;
                                    if($selectedClass) $activeFilters++;
                                    if($selectedTurma) $activeFilters++;
                                    if($search) $activeFilters++;
                                    if($filter) $activeFilters++;
                                @endphp
                                <h3 class="mb-0 fw-bold" style="color: #00a65a;">{{ $activeFilters }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <div class="rounded p-3" style="background-color: #fff3e0;">
                                    <i class="fas fa-check-circle fa-2x" style="color: #ff9800;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="text-muted mb-1 small">Selecionados</h6>
                                <h3 class="mb-0 fw-bold" style="color: #ff9800;">{{ count($selectedIds) }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card shadow-sm border-0 h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <div class="rounded p-3" style="background-color: #f3e5f5;">
                                    <i class="fas fa-graduation-cap fa-2x" style="color: #9c27b0;"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <h6 class="text-muted mb-1 small">Classe Filtrada</h6>
                                <h3 class="mb-0 fw-bold" style="color: #9c27b0;">{{ $selectedClass ?: 'Todas' }}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Filters Card -->
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-dark">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                        @php
                            $activeFilters = 0;
                            if($selectedClass) $activeFilters++;
                            if($selectedTurma) $activeFilters++;
                            if($search) $activeFilters++;
                            if($filter) $activeFilters++;
                        @endphp
                        @if($activeFilters > 0)
                            <span class="badge bg-info ms-2">{{ $activeFilters }} ativo{{ $activeFilters > 1 ? 's' : '' }}</span>
                        @endif
                    </h5>
                    <div class="d-flex gap-2">
                        @if(!isset($student))
                        <div class="btn-group" role="group">
                            <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                                <i class="fa fa-file-pdf me-1"></i>PDF
                            </button>
                            <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                                <i class="fa fa-file-excel me-1"></i>Excel
                            </button>
                        </div>
                        @endif
                        @if($activeFilters > 0)
                        <button wire:click="$set('selectedClass', ''); $set('selectedTurma', ''); $set('search', ''); $set('filter', '')"
                                class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-times me-1"></i>Limpar Filtros
                        </button>
                        @endif
                    </div>
                </div>

                <div class="row g-3">
                    @if(!isset($student))
                        <!-- Classe (apenas para admin) -->
                        <div class="col-md-3">
                            <label for="selectedClass" class="form-label">Classe</label>
                            <select class="form-select" wire:model="selectedClass">
                                <option value="">Todas as Classes</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- Turma (apenas para admin) -->
                        <div class="col-md-3">
                            <label for="selectedTurma" class="form-label">Turma</label>
                            <select class="form-select" wire:model="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                                <option value="">Todas as Turmas</option>
                                @foreach($turmas as $turma)
                                    <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif

                    <!-- Pesquisar -->
                    <div class="col-md-{{ isset($student) ? '6' : '3' }}">
                        <label for="search" class="form-label">Pesquisar</label>
                        <div class="input-group">
                            <input type="text" class="form-control"
                                   wire:model.debounce.300ms="search"
                                   placeholder="Digite...">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                        </div>
                    </div>

                    <!-- Filtrar Por Campo -->
                    <div class="col-md-{{ isset($student) ? '6' : '3' }}">
                        <label for="filter" class="form-label">Campo</label>
                        <select class="form-select" wire:model="filter">
                            <option value="">Todos</option>
                            <option value="title">Título</option>
                            <option value="description">Descrição</option>
                            @if(!isset($student))
                                <option value="student">Estudante</option>
                                <option value="type">Tipo</option>
                            @endif
                            <option value="year">Ano</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Matrizes Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body p-0">
                <div class="d-flex justify-content-between align-items-center p-4 border-bottom">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-table me-2"></i>Matrizes
                        @if(count($models))
                            <span class="badge bg-primary ms-2">{{ $models->total() }}</span>
                        @endif
                    </h5>

                    @if(!isset($student))
                        <div class="d-flex gap-2">
                            @if(count($selectedIds) > 0)
                                <button type="button" wire:click="bulkDelete" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash me-1"></i>Apagar Selecionados ({{ count($selectedIds) }})
                                </button>
                            @endif
                            <div class="dropdown">
                                <button type="button" class="btn btn-outline-danger btn-sm dropdown-toggle"
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fas fa-trash-alt me-1"></i>Eliminação em Massa
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end shadow" style="min-width: 250px;">
                                    <li>
                                        <h6 class="dropdown-header text-danger fw-bold">
                                            <i class="fas fa-exclamation-triangle me-2"></i>Operações de Eliminação
                                        </h6>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('all')">
                                            <i class="fas fa-trash-alt me-2 text-danger"></i>
                                            <span class="text-dark">Eliminar Todas as Matrizes</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('byTurma')">
                                            <i class="fas fa-users me-2 text-primary"></i>
                                            <span class="text-dark">Eliminar por Turma</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('byClasse')">
                                            <i class="fas fa-graduation-cap me-2 text-primary"></i>
                                            <span class="text-dark">Eliminar por Classe</span>
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" wire:click.prevent="openBulkDeleteModal('byDateRange')">
                                            <i class="fas fa-calendar-alt me-2 text-info"></i>
                                            <span class="text-dark">Eliminar por Período</span>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="table-responsive" wire:init="loadData">
                    @if(count($models))
                        <form wire:submit.prevent="bulkDelete">
                            <table class="table table-hover align-middle mb-0 matrizes-table">
                                <thead class="bg-light">
                                    <tr>
                                        @if(!isset($student))
                                            <th width="50px" class="ps-4">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" wire:model="selectAll">
                                                </div>
                                            </th>
                                        @endif
                                        <th>#</th>
                                        @if(!isset($student))
                                            <th>Para</th>
                                        @endif
                                        <th>Classe</th>
                                        <th>Estudante</th>
                                        <th>Título</th>
                                        <th>Descrição</th>
                                        <th>Ficheiro</th>
                                        <th>Data de Lançamento</th>
                                        @if(!isset($student))
                                            <th class="text-end pe-4">Ações</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($models as $model)
                                        @php
                                            $get_class = $model->class_id ? \App\Models\Classroom::find($model->class_id) : null;
                                            $get_student = $model->student_id ? \App\Models\User::find($model->student_id) : null;
                                            $get_download = \App\Models\Downloadcenter::where("slug", $model->download_id)->first();
                                            $get_files = \App\Models\Downloadfile::where("download_id", $model->download_id)->get();
                                            $user = Auth::user();

                                            $title = match($model->type) {
                                                'all' => 'Todos',
                                                'student' => 'Estudante',
                                                'class' => 'Classe',
                                                default => 'Indefinido'
                                            };

                                            $typeBadgeColor = match($model->type) {
                                                'all' => 'primary',
                                                'student' => 'info',
                                                'class' => 'success',
                                                default => 'secondary'
                                            };
                                        @endphp

                                        @if(isset($student) && (empty($model->student_id) || $model->student_id == $user->id))
                                            <tr>
                                                <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                                <td>
                                                    @if($get_class)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-graduation-cap text-primary me-2"></i>
                                                            <span>{{ $get_class->class }} Classe - {{ $get_class->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_student)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-user text-info me-2"></i>
                                                            <span>{{ $get_student->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <strong class="text-dark">{{ $get_download->title }}</strong>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <span class="text-muted">{{ Str::limit($get_download->description, 50) }}</span>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @forelse($get_files as $file)
                                                        <a href="{{ $file->media_url }}" target="_blank" class="text-decoration-none">
                                                            <i class="fas fa-file-download text-success me-1"></i>
                                                            <span class="text-primary">{{ Str::limit($file->media_name, 30) }}</span>
                                                        </a><br>
                                                    @empty
                                                        <span class="text-muted">Nenhum arquivo</span>
                                                    @endforelse
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-calendar text-muted me-2"></i>
                                                        <span class="text-muted">{{ $model->created_at->format('d/m/Y H:i') }}</span>
                                                    </div>
                                                </td>
                                            </tr>
                                        @elseif(!isset($student))
                                            <tr>
                                                <td class="ps-4">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" wire:model="selectedIds" value="{{ $model->id }}">
                                                    </div>
                                                </td>
                                                <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                                <td><span class="badge bg-{{ $typeBadgeColor }}">{{ $title }}</span></td>
                                                <td>
                                                    @if($get_class)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-graduation-cap text-primary me-2"></i>
                                                            <span>{{ $get_class->class }} Classe - {{ $get_class->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_student)
                                                        <div class="d-flex align-items-center">
                                                            <i class="fas fa-user text-info me-2"></i>
                                                            <span>{{ $get_student->name }}</span>
                                                        </div>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <strong class="text-dark">{{ $get_download->title }}</strong>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if($get_download)
                                                        <span class="text-muted">{{ Str::limit($get_download->description, 50) }}</span>
                                                    @else
                                                        <span class="text-muted">-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @forelse($get_files as $file)
                                                        <a href="{{ $file->media_url }}" target="_blank" class="text-decoration-none">
                                                            <i class="fas fa-file-download text-success me-1"></i>
                                                            <span class="text-primary">{{ Str::limit($file->media_name, 30) }}</span>
                                                        </a><br>
                                                    @empty
                                                        <span class="text-muted">Nenhum arquivo</span>
                                                    @endforelse
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <i class="fas fa-calendar text-muted me-2"></i>
                                                        <span class="text-muted">{{ $model->created_at->format('d/m/Y H:i') }}</span>
                                                    </div>
                                                </td>
                                                <td class="pe-4">
                                                    <div class="d-flex justify-content-end gap-2 action-cell">
                                                        <a href="{{ route('admin.edit.Download', $model->download_id) }}"
                                                           class="btn btn-sm btn-outline-primary"
                                                           title="Editar">
                                                            <i class="fas fa-edit"></i>
                                                        </a>
                                                        <button type="button"
                                                                wire:click="submit('{{ $model->download_id }}')"
                                                                class="btn btn-sm btn-outline-danger"
                                                                title="Apagar">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </form>

                        <div class="d-flex justify-content-center p-4 border-top">
                            {{ $models->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="mb-3">
                                <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
                                    <span class="visually-hidden">Carregando...</span>
                                </div>
                                <p class="mt-3 mb-0">Processando...</p>
                            </div>
                            <div wire:loading.remove>
                                <i class="fas fa-inbox text-muted" style="font-size: 3rem;"></i>
                                <h5 class="mt-3">Nenhuma matriz encontrada</h5>
                                <p class="text-muted">Ajuste os filtros para encontrar matrizes ou adicione novas</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Bulk Delete Modal -->
    @if($showBulkDeleteModal)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-light">
                    <h5 class="modal-title text-dark">
                        <i class="fas fa-trash-alt me-2 text-danger"></i>
                        @if($bulkDeleteType === 'all') Eliminação em Massa - Todas as Matrizes
                        @elseif($bulkDeleteType === 'byTurma') Eliminação em Massa - Por Turma
                        @elseif($bulkDeleteType === 'byClasse') Eliminação em Massa - Por Classe
                        @elseif($bulkDeleteType === 'byDateRange') Eliminação em Massa - Por Período
                        @endif
                    </h5>
                    <button type="button" class="btn-close" wire:click="closeBulkDeleteModal"></button>
                </div>
                <div class="modal-body">
                    @if($bulkDeleteType === 'all')
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <strong>ATENÇÃO!</strong> Esta ação irá eliminar TODAS as matrizes do sistema permanentemente.
                        </div>
                        <p>Tem certeza de que deseja continuar?</p>
                    @elseif($bulkDeleteType === 'byTurma')
                        <div class="mb-3">
                            <label class="form-label">Selecione a Classe</label>
                            <select class="form-select" wire:model="bulkDeleteSelectedClass">
                                <option value="">Selecione uma classe</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                                @endforeach
                            </select>
                        </div>
                        @if($bulkDeleteSelectedClass)
                            <div class="mb-3">
                                <label class="form-label">Selecione a Turma</label>
                                <select class="form-select" wire:model="bulkDeleteSelectedTurma">
                                    <option value="">Selecione uma turma</option>
                                    @foreach(\App\Models\Classroom::where('class', $bulkDeleteSelectedClass)->get() as $turma)
                                        <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        @endif
                        <div class="alert alert-warning">
                            <i class="fas fa-info-circle me-2"></i>
                            Todas as matrizes da turma selecionada serão eliminadas.
                        </div>
                    @elseif($bulkDeleteType === 'byClasse')
                        <div class="mb-3">
                            <label class="form-label">Selecione a Classe</label>
                            <select class="form-select" wire:model="bulkDeleteSelectedClass">
                                <option value="">Selecione uma classe</option>
                                @foreach($classes as $class)
                                    <option value="{{ $class->class }}">{{ $class->class }}ª Classe</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="alert alert-warning">
                            <i class="fas fa-info-circle me-2"></i>
                            Todas as matrizes de todas as turmas da classe selecionada serão eliminadas.
                        </div>
                    @elseif($bulkDeleteType === 'byDateRange')
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Data Inicial</label>
                                <input type="date" class="form-control" wire:model="bulkDeleteFromDate">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Data Final</label>
                                <input type="date" class="form-control" wire:model="bulkDeleteToDate">
                            </div>
                        </div>
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle me-2"></i>
                            Todas as matrizes criadas entre as datas selecionadas serão eliminadas.
                        </div>
                    @endif
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-secondary" wire:click="closeBulkDeleteModal">
                        <i class="fas fa-times me-1"></i>Cancelar
                    </button>
                    <button type="button" class="btn btn-danger" wire:click="confirmBulkDelete">
                        <i class="fas fa-trash me-1"></i>Confirmar Eliminação
                    </button>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>

<style>
    /* Professional Table Styling */
    .matrizes-table {
        font-size: 14px;
    }

    .matrizes-table thead th {
        font-weight: 600;
        text-transform: uppercase;
        font-size: 11px;
        letter-spacing: 0.5px;
        color: #6c757d;
        border-bottom: 2px solid #dee2e6;
        padding: 0.75rem;
        background-color: #f8f9fa;
    }

    .matrizes-table tbody td {
        padding: 0.75rem;
        vertical-align: middle;
        border-bottom: 1px solid #e9ecef;
    }

    .matrizes-table tbody tr {
        transition: background-color 0.2s ease;
    }

    .matrizes-table tbody tr:hover {
        background-color: #f8f9fa;
    }

    /* Dropdown Menu Enhancement */
    .dropdown-menu {
        border: 1px solid #dee2e6;
        border-radius: 0.375rem;
    }

    .dropdown-item {
        padding: 0.5rem 1rem;
        transition: background-color 0.15s ease;
    }

    .dropdown-item:hover {
        background-color: #f8f9fa;
    }

    .dropdown-header {
        padding: 0.5rem 1rem;
        font-size: 0.875rem;
    }

    /* Action Buttons */
    .action-cell .btn {
        transition: all 0.2s ease;
    }

    .action-cell .btn:hover {
        transform: translateY(-1px);
    }

    /* Badges */
    .badge {
        padding: 0.35rem 0.65rem;
        font-weight: 500;
        font-size: 0.75rem;
    }

    /* Form Controls */
    .form-check-input {
        cursor: pointer;
    }

    .form-check-input:checked {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }

    .input-group-text {
        background-color: #f8f9fa;
        border-left: none;
    }

    .input-group .form-control {
        border-right: none;
    }

    .input-group .form-control:focus {
        border-color: #ced4da;
        box-shadow: none;
    }

    .input-group .form-control:focus + .input-group-text {
        border-color: #86b7fe;
    }

    /* Disabled States */
    .form-select:disabled {
        background-color: #e9ecef;
        cursor: not-allowed;
        opacity: 0.6;
    }

    /* Card Enhancement */
    .card {
        border: 1px solid #dee2e6;
    }

    .card:hover {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }

    @media (max-width: 768px) {
        .matrizes-table {
            font-size: 12px;
        }

        .matrizes-table thead {
            display: none;
        }

        .matrizes-table tbody tr {
            display: block;
            margin-bottom: 1rem;
            border: 1px solid #dee2e6;
            border-radius: 0.25rem;
        }

        .matrizes-table tbody td {
            display: block;
            text-align: right;
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #f0f0f0;
        }

        .matrizes-table tbody td:last-child {
            border-bottom: none;
        }

        .action-cell {
            justify-content: flex-end !important;
        }
    }
</style>
