<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="fee-management-form">
                                <div class="card border-0 shadow">
                                    <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                                        <h2 class="h5 mb-0">
                                            <i class="fas fa-file-invoice-dollar me-2"></i>
                                            @if($editingId)
                                                Editar Plano de Taxas
                                            @else
                                                Adicionar Plano de Taxas
                                            @endif
                                        </h2>
                                        @if($editingId)
                                            <span class="badge bg-warning text-dark">
                                                <i class="fas fa-edit me-1"></i>Modo de Edição
                                            </span>
                                        @endif
                                    </div>
                                    
                                    <div class="card-body p-4">
                                        <form wire:submit.prevent="store" class="needs-validation" novalidate>
                                            <!-- Section 1: Basic Information -->
                                            <div class="row mb-4">
                                                <div class="col-md-6 mb-3">
                                                    <label for="fee_name" class="form-label fw-semibold">Designação da Taxa <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-tag"></i>
                                                        </span>
                                                        <input type="text" class="form-control form-control-lg" id="fee_name"
                                                               wire:model="fee_name" placeholder="Ex: Propina, Transporte..." required>
                                                    </div>
                                                    @error('fee_name') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <label for="monthly_fee_grade_7_12" class="form-label fw-semibold">Valor Mensal <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">MT</span>
                                                        <input type="number" class="form-control form-control-lg" id="monthly_fee_grade_7_12"
                                                               wire:model="monthly_fee_grade_7_12" required>
                                                        <span class="input-group-text bg-light">,00</span>
                                                    </div>
                                                    @error('monthly_fee_grade_7_12') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                            </div>

                                            <!-- Section 2: Payment Settings -->
                                            <div class="row mb-4">
                                                <div class="col-md-3 mb-3">
                                                    <label for="payment_start_day" class="form-label fw-semibold">Dia de Início <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-calendar-day"></i>
                                                        </span>
                                                        <input type="number" class="form-control form-control-lg" id="payment_start_day"
                                                               wire:model="payment_start_day" min="1" max="31" required>
                                                    </div>
                                                    @error('payment_start_day') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-3 mb-3">
                                                    <label for="payment_due_day" class="form-label fw-semibold">Dia de Vencimento <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-calendar-check"></i>
                                                        </span>
                                                        <input type="number" class="form-control form-control-lg" id="payment_due_day"
                                                               wire:model="payment_due_day" min="1" max="31" required>
                                                    </div>
                                                    @error('payment_due_day') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label fw-semibold">Tipo de Multa <span class="text-danger">*</span></label>
                                                    <div class="btn-group w-100 shadow-sm" role="group">
                                                        <input type="radio" class="btn-check" wire:model="penalty_type"
                                                               value="percentage" id="percentage" required>
                                                        <label class="btn btn-outline-primary" for="percentage">
                                                            <i class="fas fa-percent me-2"></i> Porcentagem
                                                        </label>
                                                        
                                                        <input type="radio" class="btn-check" wire:model="penalty_type"
                                                               value="fixed" id="fixed" required>
                                                        <label class="btn btn-outline-primary" for="fixed">
                                                            <i class="fas fa-money-bill-wave me-2"></i> Valor Fixo
                                                        </label>
                                                    </div>
                                                    @error('penalty_type') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                            </div>

                                            <!-- Conditional Late Fee Field -->
                                            <div class="row mb-4">
                                                @if($penalty_type === 'percentage')
                                                <div class="col-md-6 mb-3">
                                                    <label for="late_penalty_percentage" class="form-label fw-semibold">Percentual de Multa <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">%</span>
                                                        <input type="number" class="form-control form-control-lg" id="late_penalty_percentage"
                                                               wire:model="late_penalty_percentage" required>
                                                    </div>
                                                    @error('late_penalty_percentage') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                @endif
                                                
                                                @if($penalty_type === 'fixed')
                                                <div class="col-md-6 mb-3">
                                                    <label for="late_penalty_fixed" class="form-label fw-semibold">Valor Fixo da Multa <span class="text-danger">*</span></label>
                                                    <div class="input-group">
                                                        <span class="input-group-text bg-light">MT</span>
                                                        <input type="number" class="form-control form-control-lg" id="late_penalty_fixed"
                                                               wire:model="late_penalty_fixed" required>
                                                        <span class="input-group-text bg-light">,00</span>
                                                    </div>
                                                    @error('late_penalty_fixed') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                @endif
                                            </div>

                                            <!-- Section 3: Application Period -->
                                            <div class="row mb-4">
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label fw-semibold">Ano Académico <span class="text-danger">*</span></label>
                                                    <div class="input-group mb-3">
                                                        <span class="input-group-text bg-light">
                                                            <i class="fas fa-calendar-alt"></i>
                                                        </span>
                                                        <input type="text" class="form-control form-control-lg"
                                                               wire:model="academic_year"
                                                               placeholder="Ex: 2025/2026"
                                                               required>
                                                    </div>
                                                    <small class="text-muted">
                                                        <i class="fas fa-info-circle me-1"></i>
                                                        Para taxas de matrícula que atravessam anos, especifique o período (ex: 2025/2026)
                                                    </small>
                                                    @error('academic_year') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror

                                                    <label class="form-label fw-semibold mt-4">Meses de Cobrança <span class="text-danger">*</span></label>
                                                    <div class="card border-0 shadow-sm">
                                                        <div class="card-body p-3">
                                                            <div class="row">
                                                                @foreach([
                                                                    'Janeiro',
                                                                    'Fevereiro',
                                                                    'Março',
                                                                    'Abril',
                                                                    'Maio',
                                                                    'Junho',
                                                                    'Julho',
                                                                    'Agosto',
                                                                    'Setembro',
                                                                    'Outubro',
                                                                    'Novembro',
                                                                    'Dezembro'
                                                                ] as $month)
                                                                    <div class="col-4 mb-2">
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                   wire:model="months" value="{{ $month }}"
                                                                                   id="month_{{ $month }}">
                                                                            <label class="form-check-label" for="month_{{ $month }}">
                                                                                {{ $month }}
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @error('months') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                </div>
                                                
                                                <div class="col-md-6 mb-3">
                                                    <label class="form-label fw-semibold">Classes Aplicáveis <span class="text-danger">*</span></label>
                                                    <div class="card border-0 shadow-sm">
                                                        <div class="card-body p-3">
                                                            <div class="row">
                                                                @for($i = 1; $i <= 12; $i++)
                                                                    <div class="col-4 mb-2">
                                                                        <div class="form-check">
                                                                            <input class="form-check-input" type="checkbox"
                                                                                   wire:model="grades" value="{{ $i }}"
                                                                                   id="grade_{{ $i }}">
                                                                            <label class="form-check-label" for="grade_{{ $i }}">
                                                                                {{ $i }}ª Classe
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                @endfor
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @error('grades') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                    
                                                    <div class="mt-4">
                                                        <label class="form-label fw-semibold">Estado do Plano <span class="text-danger">*</span></label>
                                                        <div class="btn-group w-100 shadow-sm" role="group">
                                                            <input type="radio" class="btn-check" wire:model="active"
                                                                   value="1" id="active_1" required>
                                                            <label class="btn btn-outline-success" for="active_1">
                                                                <i class="fas fa-check-circle me-2"></i> Ativo
                                                            </label>
                                                            
                                                            <input type="radio" class="btn-check" wire:model="active"
                                                                   value="0" id="active_0" required>
                                                            <label class="btn btn-outline-danger" for="active_0">
                                                                <i class="fas fa-times-circle me-2"></i> Inativo
                                                            </label>
                                                        </div>
                                                        @error('active') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                    </div>

                                                    <!-- Payment Method Configuration -->
                                                    <div class="mt-4">
                                                        <div class="card border-primary shadow-sm">
                                                            <div class="card-header bg-primary text-white">
                                                                <h6 class="mb-0">
                                                                    <i class="fas fa-cog me-2"></i>Método de Geração de Referências
                                                                </h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="form-check form-switch">
                                                                    <input class="form-check-input" type="checkbox" wire:model="is_manual" id="is_manual_main">
                                                                    <label class="form-check-label" for="is_manual_main">
                                                                        <strong>Pagamento Manual</strong>
                                                                    </label>
                                                                </div>
                                                                <small class="text-muted mt-2 d-block">
                                                                    <i class="fas fa-info-circle me-1"></i>
                                                                    @if($is_manual)
                                                                        <strong class="text-primary">✓ Ativado:</strong> A instituição gera as referências manualmente para os estudantes.
                                                                    @else
                                                                        <strong class="text-success">Desativado:</strong> Os estudantes geram suas próprias referências automaticamente.
                                                                    @endif
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- IVA Configuration Section -->
                                                    <div class="mt-4">
                                                        <div class="card border-primary">
                                                            <div class="card-header bg-primary text-white">
                                                                <h6 class="mb-0"><i class="fas fa-file-invoice-dollar me-2"></i>Configuração de IVA</h6>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="mb-3">
                                                                    <div class="form-check form-switch">
                                                                        <input class="form-check-input" type="checkbox" wire:model="iva_applicable" id="iva_applicable">
                                                                        <label class="form-check-label" for="iva_applicable">
                                                                            <strong>IVA Aplicável</strong>
                                                                            <br><small class="text-muted">Marque se esta taxa está sujeita a IVA</small>
                                                                        </label>
                                                                    </div>
                                                                </div>

                                                                @if($iva_applicable)
                                                                <div class="mb-3">
                                                                    <div class="form-check form-switch">
                                                                        <input class="form-check-input" type="checkbox" wire:model="price_includes_iva" id="price_includes_iva">
                                                                        <label class="form-check-label" for="price_includes_iva">
                                                                            <strong>Preço Inclui IVA</strong>
                                                                            <br><small class="text-muted">Marque se o preço mostrado ao cliente já inclui o IVA</small>
                                                                        </label>
                                                                    </div>
                                                                </div>

                                                                <div class="mb-3">
                                                                    <label class="form-label">Notas sobre IVA</label>
                                                                    <textarea wire:model="iva_notes" class="form-control" rows="2" placeholder="Informações adicionais sobre IVA para esta taxa..."></textarea>
                                                                    @error('iva_notes') <div class="invalid-feedback d-block">{{ $message }}</div> @enderror
                                                                </div>
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Submit Section -->
                                            <div class="d-flex justify-content-between border-top pt-4">
                                                <button type="button" class="btn btn-outline-secondary px-4" wire:click="cancel">
                                                    <i class="fas fa-times me-2"></i> Cancelar
                                                </button>
                                                
                                                <button type="submit" class="btn btn-primary px-4" wire:loading.attr="disabled">
                                                    <span wire:loading wire:target="store" class="spinner-border spinner-border-sm me-2"></span>
                                                    <i wire:loading.remove wire:target="store" class="fas fa-save me-2"></i>
                                                    @if($editingId)
                                                        Atualizar Plano
                                                    @else
                                                        Guardar Plano
                                                    @endif
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <style>
                                .fee-management-form {
                                    max-width: 1200px;
                                    margin: 0 auto;
                                }
                                
                                .card {
                                    border-radius: 0.5rem;
                                    overflow: hidden;
                                }
                                
                                .form-control, .btn, .input-group-text {
                                    border-radius: 0.375rem;
                                }
                                
                                .btn-check:checked + .btn-outline-primary {
                                    background-color: var(--bs-primary);
                                    color: white;
                                }
                                
                                .btn-check:checked + .btn-outline-success {
                                    background-color: var(--bs-success);
                                    color: white;
                                }
                                
                                .btn-check:checked + .btn-outline-danger {
                                    background-color: var(--bs-danger);
                                    color: white;
                                }
                                
                                .form-check-input:checked {
                                    background-color: var(--bs-primary);
                                    border-color: var(--bs-primary);
                                }
                                
                                .input-group-text {
                                    transition: all 0.2s;
                                }
                                
                                .form-control:focus, .form-check-input:focus {
                                    box-shadow: 0 0 0 0.25rem rgba(13, 110, 253, 0.25);
                                }
                            </style>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
