 {{-- Ficheiro: resources/views/livewire/admin/student-finance-details.blade.php --}}
<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="student-header">
                <div class="student-info-card">
                    <div class="student-avatar">{{ strtoupper(substr(preg_replace('/(\B.|\s)/', '', $student->name), 0, 2)) }}</div>
                    <div class="student-details">
                        <h2>{{ $student->name }}</h2>
                        <p>ID: <strong>{{ $student->student_id }}</strong> | Classe: <strong>{{ $student->class->class ?? 'N/A' }}</strong> | Turma: <strong>{{ $student->class->name ?? 'N/A' }}</strong></p>
                    </div>
                    <div class="year-filter-wrapper">
                        <label for="yearFilter" class="form-label text-white">Ano Letivo</label>
                        <select id="yearFilter" class="form-select" wire:model="selectedYear">
                            @for ($i = now()->year; $i >= now()->year - 3; $i--)
                                <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                </div>
            </div>

            @php
                // Usar dados do controller (widgetData)
                $totalAnnualValue = $widgetData['total_annual_value'] ?? 0;
                $totalPaid = $widgetData['total_net_received'] ?? 0;
                $totalDue = $widgetData['total_due'] ?? 0;
                $totalOverdueBase = $widgetData['total_overdue_base'] ?? 0;
                $totalFinesPaid = $widgetData['total_fines_paid'] ?? 0;
                $totalDiscountsGiven = $widgetData['total_discounts_given'] ?? 0;
                $paymentRate = $widgetData['payment_rate'] ?? 0;
                $monthsWithFees = $widgetData['months_with_fees'] ?? 0;
                $monthsPaidCount = $widgetData['months_paid_count'] ?? 0;
                $currentYear = $selectedYear ?? now()->year;
            @endphp

            <div class="summary-widgets-grid">
                <div class="summary-widget">
                    <div class="icon-wrapper total"><i class="fas fa-calendar-alt"></i></div>
                    <div class="text-wrapper"><span class="label">Total Anual (Base)</span><span class="value">{{ number_format($totalAnnualValue, 2, ',', '.') }} MT</span></div>
                </div>

                <div class="summary-widget">
                    <div class="icon-wrapper paid"><i class="fas fa-wallet"></i></div>
                    <div class="text-wrapper"><span class="label">Total Arrecadado</span><span class="value">{{ number_format($totalPaid, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper due"><i class="fas fa-hourglass-half"></i></div>
                    <div class="text-wrapper"><span class="label">Pendente (no prazo)</span><span class="value">{{ number_format($totalDue, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper overdue"><i class="fas fa-clock"></i></div>
                    <div class="text-wrapper"><span class="label">Em Atraso (base)</span><span class="value">{{ number_format($totalOverdueBase, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper fines"><i class="fas fa-exclamation-triangle"></i></div>
                    <div class="text-wrapper"><span class="label">Multas Pagas</span><span class="value">{{ number_format($totalFinesPaid, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget">
                    <div class="icon-wrapper discounts"><i class="fas fa-tags"></i></div>
                    <div class="text-wrapper"><span class="label">Descontos Concedidos</span><span class="value">{{ number_format($totalDiscountsGiven, 2, ',', '.') }} MT</span></div>
                </div>
                <div class="summary-widget compliance">
                    <span class="label">Taxa de Cumprimento</span>
                    <div class="progress mt-1" style="height: 8px;">
                        <div class="progress-bar" role="progressbar" style="width: {{ $paymentRate }}%;" aria-valuenow="{{ $paymentRate }}">{{ $paymentRate }}%</div>
                    </div>
                    <small class="description">{{ $monthsPaidCount }} de {{ $monthsWithFees }} meses pagos</small>
                </div>
            </div>

            <!-- Referências de Pagamento Agrupadas por Mês -->
            @if(isset($payment_references) && $payment_references->count() > 0)
            <div class="fee-section" style="margin-bottom: 2rem;">
                <div class="section-header" style="margin-bottom: 1.5rem;">
                    <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 1rem;">
                        <div>
                            <h2 style="margin: 0; font-size: 22px; color: #2c3e50; font-weight: 600;">
                                <i class="fas fa-receipt"></i>
                                Detalhes de Pagamento do Estudante
                            </h2>
                            <p style="margin: 5px 0 0 0; color: #6c757d; font-size: 14px;">
                                Todas as referências geradas (plano de taxas e manuais) - Total: {{ $payment_references->count() }} referência(s)
                            </p>
                        </div>
                        <div style="display: flex; gap: 1rem; align-items: center; flex-wrap: wrap;">
                            <!-- Filtros de Status -->
                            <div class="fee-filters" style="display: flex; gap: 0.5rem;">
                                <button class="filter-btn active" data-filter-ref="all">Todos</button>
                                <button class="filter-btn" data-filter-ref="paid">Pagos</button>
                                <button class="filter-btn" data-filter-ref="approved">Aprovados</button>
                                <button class="filter-btn" data-filter-ref="pending">Pendentes</button>
                                <button class="filter-btn" data-filter-ref="expired">Expirados</button>
                            </div>

                            <!-- Botões de Exportação -->
                            <div class="btn-group" role="group">
                                <button class="btn btn-danger btn-sm" wire:click="exportPdf" title="Exportar para PDF">
                                    <i class="fas fa-file-pdf me-1"></i>PDF
                                </button>
                                <button class="btn btn-success btn-sm" wire:click="exportExcel" title="Exportar para Excel">
                                    <i class="fas fa-file-excel me-1"></i>Excel
                                </button>
                                <button class="btn btn-info btn-sm text-white" onclick="window.print()" title="Imprimir">
                                    <i class="fas fa-print me-1"></i>Imprimir
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <x-payment-references-grouped
                    :references="$payment_references"
                    :showActions="true"
                    :showCheckboxes="false"
                    mode="detailed"
                />
            </div>
            @endif
        </div>
    </div>
    
    <div class="modal fade" id="collectFeeModal" tabindex="-1" role="dialog" aria-labelledby="collectFeeModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content payment-modal">
                <form wire:submit.prevent="collectFee">
                    <!-- Header Compacto -->
                    <div class="modal-header border-0 text-white position-relative" style="background: linear-gradient(135deg, #28a745 0%, #20c997 100%); padding: 1.25rem;">
                        <div class="w-100">
                            <h5 class="modal-title fw-bold mb-0">
                                <i class="fas fa-credit-card me-2"></i>Processar Pagamento
                            </h5>
                            <small class="opacity-75">{{ $student->name }} • ID: {{ $student->student_id }}</small>
                        </div>
                        <button type="button" class="btn-close btn-close-white position-absolute top-50 end-0 translate-middle-y me-3" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body p-4" style="background-color: #f8f9fa;">
                        <input type="hidden" wire:model.defer="month" id="hidden_month">
                        <input type="hidden" wire:model.defer="year" id="hidden_year">

                        <!-- Valores Compactos -->
                        <div class="row g-3 mb-4">
                            <div class="col-6">
                                <label class="form-label small fw-semibold text-muted">
                                    <i class="fas fa-money-bill-wave text-primary me-1"></i>Base
                                </label>
                                <input type="number" class="form-control" id="modal_amount_base" readonly style="font-weight: 600;">
                            </div>
                            <div class="col-6">
                                <label class="form-label small fw-semibold text-muted">
                                    <i class="fas fa-exclamation-triangle text-warning me-1"></i>Multa
                                </label>
                                <input type="number" step="0.01" class="form-control" id="modal_fine" readonly style="font-weight: 600;">
                            </div>
                            <div class="col-6">
                                <label class="form-label small fw-semibold text-muted">
                                    <i class="fas fa-percentage text-success me-1"></i>Desconto
                                </label>
                                <input type="number" step="0.01" class="form-control" id="modal_discount" wire:model.defer="discount" min="0" placeholder="0.00">
                            </div>
                            <div class="col-6">
                                <label class="form-label small fw-semibold text-muted">
                                    <i class="fas fa-credit-card text-info me-1"></i>Método
                                </label>
                                <select class="form-select" wire:model.live="paymentMode" required>
                                    <option value="Cash">💵 Dinheiro</option>
                                    <option value="POS">💳 POS</option>
                                </select>
                            </div>
                            @if($paymentMode === 'POS')
                            <div class="col-12">
                                <label class="form-label small fw-semibold text-muted">
                                    <i class="fas fa-hashtag text-primary me-1"></i>ID Transação POS *
                                </label>
                                <input type="text" class="form-control" wire:model.defer="transactionId" placeholder="Digite o ID da transação" required>
                            </div>
                            @endif
                        </div>

                        <!-- Total em Destaque -->
                        <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #e8f5e9 0%, #f1f8f4 100%);">
                            <div class="card-body p-3 text-center">
                                <small class="text-muted d-block mb-1">Total a Pagar</small>
                                <h3 class="mb-0 fw-bold text-success" id="total-amount-display">0,00 MT</h3>
                                <input type="hidden" wire:model.defer="amount" id="hidden_total_amount">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer bg-white border-top p-3">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>Cancelar
                        </button>
                        <button type="submit" class="btn btn-success px-4" wire:loading.attr="disabled">
                            <span wire:loading.remove>
                                <i class="fas fa-check me-1"></i>Confirmar Pagamento
                            </span>
                            <span wire:loading>
                                <i class="fas fa-spinner fa-spin me-1"></i>Processando...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal: Ver Detalhes da Referência -->
    @if($showReferenceModal && $selectedReference)
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.6); animation: fadeIn 0.3s ease;">
        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable" style="animation: slideUp 0.3s ease;">
            <div class="modal-content border-0 shadow-lg">
                <!-- Header com gradiente -->
                <div class="modal-header border-0 text-white position-relative overflow-hidden" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 1.5rem;">
                    <div class="position-relative w-100">
                        <h5 class="modal-title fw-bold mb-0">
                            <i class="fas fa-file-invoice me-2"></i>Detalhes da Referência de Pagamento
                        </h5>
                        <small class="d-block mt-1 opacity-75">Referência #{{ $selectedReference['reference_number'] }}</small>
                    </div>
                    <button type="button" class="btn-close btn-close-white position-absolute top-50 end-0 translate-middle-y me-3" wire:click="closeReferenceModal"></button>
                </div>

                <div class="modal-body p-4" style="background-color: #f8f9fa;">
                    <!-- Status Badge Grande -->
                    <div class="text-center mb-4">
                        @php
                            $statusConfig = match($selectedReference['status']) {
                                'paid' => ['bg' => 'success', 'icon' => 'check-circle', 'text' => 'PAGO'],
                                'pending' => ['bg' => 'warning', 'icon' => 'clock', 'text' => 'PENDENTE'],
                                'expired' => ['bg' => 'danger', 'icon' => 'exclamation-triangle', 'text' => 'EXPIRADO'],
                                'cancelled' => ['bg' => 'secondary', 'icon' => 'ban', 'text' => 'CANCELADO'],
                                default => ['bg' => 'light', 'icon' => 'question-circle', 'text' => 'DESCONHECIDO']
                            };
                        @endphp
                        <div class="badge bg-{{ $statusConfig['bg'] }} px-4 py-2 rounded-pill" style="font-size: 1.1rem;">
                            <i class="fas fa-{{ $statusConfig['icon'] }} me-2"></i>{{ $statusConfig['text'] }}
                        </div>
                    </div>

                    <!-- Dados do Estudante -->
                    <div class="card border-0 shadow-sm mb-3">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; background-color: #e7f3ff;">
                                    <i class="fas fa-user-graduate fa-lg" style="color: #667eea;"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0 fw-bold">Dados do Estudante</h6>
                                    <small class="text-muted">Informações do beneficiário</small>
                                </div>
                            </div>
                            <div class="row g-3">
                                <div class="col-md-8">
                                    <div class="d-flex align-items-start">
                                        <i class="fas fa-id-card text-primary me-2 mt-1"></i>
                                        <div class="flex-grow-1">
                                            <small class="text-muted d-block mb-1">Nome Completo</small>
                                            <strong class="d-block">{{ $selectedReference['student_name'] }}</strong>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="d-flex align-items-start">
                                        <i class="fas fa-graduation-cap text-success me-2 mt-1"></i>
                                        <div class="flex-grow-1">
                                            <small class="text-muted d-block mb-1">Classe</small>
                                            <strong class="d-block">{{ $selectedReference['class'] }}ª Classe</strong>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Detalhes da Referência -->
                    <div class="card border-0 shadow-sm mb-3">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 50px; height: 50px; background-color: #fff4e5;">
                                    <i class="fas fa-receipt fa-lg" style="color: #ff9800;"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0 fw-bold">Informações de Pagamento</h6>
                                    <small class="text-muted">Dados para realizar o pagamento</small>
                                </div>
                            </div>

                            <div class="row g-3">
                                <!-- Referência -->
                                <div class="col-12">
                                    <div class="p-3 rounded" style="background-color: #f0f8ff; border-left: 4px solid #0066cc;">
                                        <small class="text-muted d-block mb-2">Número da Referência</small>
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h4 class="mb-0 fw-bold text-primary font-monospace">{{ $selectedReference['reference_number'] }}</h4>
                                            <button class="btn btn-outline-primary btn-sm" type="button"
                                                    onclick="navigator.clipboard.writeText('{{ $selectedReference['reference_number'] }}'); this.innerHTML='<i class=\'fas fa-check\'></i> Copiado!'; setTimeout(() => this.innerHTML='<i class=\'fas fa-copy\'></i> Copiar', 2000);">
                                                <i class="fas fa-copy"></i> Copiar
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Valor e Entidade -->
                                <div class="col-md-6">
                                    <div class="p-3 rounded" style="background-color: #e8f8f5;">
                                        <small class="text-muted d-block mb-1">Valor a Pagar</small>
                                        <h4 class="mb-0 fw-bold text-success">MT {{ number_format($selectedReference['amount'], 2, ',', '.') }}</h4>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="p-3 rounded" style="background-color: #fff0f6;">
                                        <small class="text-muted d-block mb-1">Código Entidade</small>
                                        <h4 class="mb-0 fw-bold" style="color: #c41e3a;">{{ $selectedReference['entity_code'] }}</h4>
                                    </div>
                                </div>

                                <!-- Mês/Ano e Expiração -->
                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <i class="fas fa-calendar text-info me-2 mt-1"></i>
                                        <div>
                                            <small class="text-muted d-block mb-1">Período</small>
                                            <strong>{{ $selectedReference['fee_month'] }}/{{ $selectedReference['fee_year'] }}</strong>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="d-flex align-items-start">
                                        <i class="fas fa-hourglass-end text-warning me-2 mt-1"></i>
                                        <div>
                                            <small class="text-muted d-block mb-1">Expira em</small>
                                            <strong>{{ $selectedReference['expires_at'] ?? 'N/A' }}</strong>
                                        </div>
                                    </div>
                                </div>

                                @if($selectedReference['paid_at'])
                                <div class="col-12">
                                    <div class="alert alert-success mb-0" role="alert">
                                        <i class="fas fa-check-circle me-2"></i>
                                        <strong>Pagamento Confirmado!</strong> em {{ $selectedReference['paid_at'] }}
                                    </div>
                                </div>
                                @endif

                                <!-- Data de Geração -->
                                <div class="col-12">
                                    <small class="text-muted">
                                        <i class="fas fa-clock me-1"></i> Gerado em: {{ $selectedReference['created_at'] }}
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Instruções de Pagamento -->
                    <div class="card border-0 shadow-sm" style="background: linear-gradient(135deg, #e3f2fd 0%, #f3e5f5 100%);">
                        <div class="card-body p-4">
                            <h6 class="fw-bold mb-3">
                                <i class="fas fa-info-circle me-2" style="color: #0066cc;"></i>
                                Como Efetuar o Pagamento
                            </h6>
                            <div class="d-flex flex-column gap-2">
                                <div class="d-flex align-items-start">
                                    <span class="badge bg-primary rounded-circle me-3" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center;">1</span>
                                    <p class="mb-0 small">Dirija-se a qualquer <strong>ATM ou eBanking</strong> da Rede SIMO ou BCI</p>
                                </div>
                                <div class="d-flex align-items-start">
                                    <span class="badge bg-primary rounded-circle me-3" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center;">2</span>
                                    <p class="mb-0 small">Selecione <strong>Pagamentos</strong> → <strong>Referência</strong></p>
                                </div>
                                <div class="d-flex align-items-start">
                                    <span class="badge bg-primary rounded-circle me-3" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center;">3</span>
                                    <p class="mb-0 small">Insira a <strong>Entidade: {{ $selectedReference['entity_code'] }}</strong></p>
                                </div>
                                <div class="d-flex align-items-start">
                                    <span class="badge bg-primary rounded-circle me-3" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center;">4</span>
                                    <p class="mb-0 small">Insira a <strong>Referência: {{ $selectedReference['reference_number'] }}</strong></p>
                                </div>
                                <div class="d-flex align-items-start">
                                    <span class="badge bg-success rounded-circle me-3" style="width: 24px; height: 24px; display: flex; align-items: center; justify-content: center;">
                                        <i class="fas fa-check" style="font-size: 0.7rem;"></i>
                                    </span>
                                    <p class="mb-0 small">Confirme o <strong>valor: MT {{ number_format($selectedReference['amount'], 2, ',', '.') }}</strong> e finalize</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer bg-white border-top p-3">
                    <button type="button" class="btn btn-outline-secondary" wire:click="closeReferenceModal">
                        <i class="fas fa-times me-2"></i>Fechar
                    </button>
                    <button type="button" class="btn btn-primary" wire:click="downloadReferencePdf">
                        <i class="fas fa-download me-2"></i>Baixar PDF
                    </button>
                    @if(isset($selectedReference['status']) && $selectedReference['status'] !== 'paid' && isset($selectedReference['approval_status']) && $selectedReference['approval_status'] === 'approved')
                    <button type="button" class="btn btn-success"
                            wire:click="closeReferenceModal"
                            onclick="setTimeout(() => closeModalAndOpenPayment('{{ $selectedReference['fee_month'] }}', {{ $selectedReference['fee_year'] }}, {{ $selectedReference['amount'] }}, 0, 0), 300)">
                        <i class="fas fa-credit-card me-2"></i>Registrar Pagamento
                    </button>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <style>
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    @keyframes slideUp {
        from {
            transform: translateY(50px);
            opacity: 0;
        }
        to {
            transform: translateY(0);
            opacity: 1;
        }
    }
    </style>
    @endif
</div>

<style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap');
    :root { --primary-color: #667eea; --success-color: #28a745; --warning-color: #ffc107; --danger-color: #dc3545; --info-color: #0dcaf0; }
    .page-content { background: #f4f7f6; font-family: 'Poppins', sans-serif; }
    .main-wrapper { max-width: 1600px; margin: 0 auto; }
    .student-header { background: linear-gradient(135deg, var(--primary-color) 0%, #764ba2 100%); color: #fff; padding: 25px; border-radius: 18px; margin-bottom: 30px; box-shadow: 0 10px 30px rgba(0,0,0,.1); }
    .student-info-card { display: flex; align-items: center; gap: 20px; flex-wrap: wrap; }
    .student-avatar { width: 70px; height: 70px; border-radius: 50%; background: #fff; color: var(--primary-color); display: flex; align-items: center; justify-content: center; font-size: 28px; font-weight: 700; flex-shrink: 0; }
    .student-details { flex-grow: 1; } .student-details h2 { margin: 0 0 5px; font-size: 26px; font-weight: 600; }
    .year-filter-wrapper { margin-left: auto; background: rgba(255, 255, 255, 0.1); padding: 8px 12px; border-radius: 12px; }
    .year-filter-wrapper .form-select { background-color: transparent; color: white; border: 1px solid rgba(255, 255, 255, 0.3); font-weight: 600; padding: 5px 10px; }
    .year-filter-wrapper .form-select option { color: #333; }
    
    .summary-widgets-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px; }
    .summary-widget { background: #fff; border-radius: 15px; padding: 20px; box-shadow: 0 8px 25px rgba(0,0,0,.05); display: flex; align-items: center; gap: 15px; }
    .summary-widget .icon-wrapper { font-size: 24px; width: 50px; height: 50px; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #fff; flex-shrink: 0; }
    .summary-widget .icon-wrapper.total { background: #6c757d; } .summary-widget .icon-wrapper.paid { background: var(--success-color); }
    .summary-widget .icon-wrapper.due { background: var(--primary-color); } .summary-widget .icon-wrapper.overdue { background: var(--warning-color); }
    .summary-widget .icon-wrapper.fines { background: var(--danger-color); } .summary-widget .icon-wrapper.discounts { background: var(--info-color); }
    .summary-widget .text-wrapper { flex-grow: 1; }
    .summary-widget .label { font-size: 13px; color: #666; margin-bottom: 2px; display: block; }
    .summary-widget .value { font-size: 22px; font-weight: 700; color: #333; }
    .summary-widget.compliance { display: block; }
    .summary-widget.compliance .progress-bar { background-color: var(--primary-color); }
    .summary-widget.compliance .description { font-size: 12px; color: #888; margin-top: 5px; }

    .fee-section { background: #fff; border-radius: 18px; padding: 25px; box-shadow: 0 5px 20px rgba(0,0,0,.08); }
    .section-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px; margin-bottom: 25px; padding-bottom: 15px; border-bottom: 1px solid #eee; }
    .section-header h2 { font-size: 20px; font-weight: 600; }
    .fee-filters { display: flex; gap: 10px; }
    .filter-btn { padding: 8px 16px; border: 1px solid #ddd; border-radius: 20px; background: #fff; cursor: pointer; transition: all .3s ease; font-size: 14px; font-weight: 500; }
    .filter-btn.active, .filter-btn:hover { background: var(--primary-color); color: #fff; border-color: var(--primary-color); }
    .fee-table-container { overflow-x: auto; } .fee-table { width: 100%; border-collapse: collapse; }
    .fee-table thead th { text-align: left; padding: 15px 12px; font-size: 12px; font-weight: 600; color: #666; border-bottom: 2px solid #f0f2f5; text-transform: uppercase; }
    .fee-table tbody tr { transition: background-color 0.2s ease; } .fee-table tbody tr:hover { background-color: #f8f9fa; }
    .fee-table tbody td { padding: 12px; border-bottom: 1px solid #f0f2f5; vertical-align: middle; font-size: 14px; }
    .fee-badge { background: #e3f2fd; color: #1565c0; padding: 4px 8px; border-radius: 12px; font-size: 11px; }
    .status-badge { padding: 6px 12px; border-radius: 20px; font-size: 11px; font-weight: 600; display: inline-flex; align-items: center; gap: 5px;}
    .status-paid { background: #e8f5e9; color: #2e7d32; } .status-pending { background: #e3f2fd; color: #1565c0; }
    .status-overdue { background: #fff3e0; color: #f57c00; }
    .gap-2 { gap: 0.5rem; }
    .badge.bg-success { background-color: #28a745 !important; color: white; padding: 6px 12px; font-size: 12px; font-weight: 600; }
    /* Estilos do Modal (completos) */
    .payment-modal { border-radius: 15px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); }
    .payment-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 25px 30px; border: none; }
    .header-content { display: flex; align-items: center; }
    .header-icon { width: 50px; height: 50px; background: rgba(255,255,255,0.2); border-radius: 12px; display: flex; align-items: center; justify-content: center; margin-right: 15px; font-size: 20px; }
    .header-text h5 { font-size: 22px; font-weight: 700; margin: 0; } .modal-subtitle { opacity: 0.9; margin: 3px 0 0 0; font-size: 14px; }
    .btn-close-custom { background: rgba(255,255,255,0.2); border: none; width: 35px; height: 35px; border-radius: 50%; color: white; font-size: 16px; transition: all 0.3s ease; }
    .btn-close-custom:hover { background: rgba(255,255,255,0.3); transform: rotate(90deg); }
    .payment-body { padding: 30px; background: #f8f9fa; } .payment-overview { margin-bottom: 20px; }
    .overview-card { background: white; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); }
    .overview-card .card-header { background: #f8f9fa; padding: 15px 20px; border-bottom: 1px solid #e0e0e0; }
    .overview-card .card-header h6 { margin: 0; font-weight: 600; font-size: 14px; }
    .overview-card .card-content { padding: 20px; }
    .info-group label { display: block; font-size: 11px; color: #666; text-transform: uppercase; font-weight: 600; }
    .info-group span { font-size: 15px; font-weight: 600; color: #333; }
    .payment-form-section { background: white; border-radius: 12px; padding: 25px; margin-bottom: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); }
    .form-group-enhanced { margin-bottom: 20px; }
    .form-label-enhanced { display: flex; align-items: center; font-weight: 600; color: #333; margin-bottom: 8px; font-size: 14px; }
    .input-group-enhanced { display: flex; }
    .form-control-enhanced { border: 1px solid #e0e0e0; padding: 10px 15px; font-size: 15px; flex: 1; outline: none; transition: all 0.3s ease; border-radius: 8px; }
    .form-control-enhanced:focus { border-color: #667eea; box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.2); }
    .form-control-enhanced[readonly] { background-color: #e9ecef; cursor: not-allowed; }
    .payment-summary-section { background: white; border-radius: 12px; padding: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); border: 2px solid #e3f2fd; text-align: center; }
    .total-display .total-label { font-size: 14px; margin-bottom: 8px; text-transform: uppercase; font-weight: 600; }
    .total-display .total-amount { font-size: 36px; font-weight: 900; }
    .payment-footer { background: #f8f9fa; padding: 20px 30px; border-top: 1px solid #e0e0e0; display: flex; justify-content: flex-end; gap: 15px; }
    .btn-cancel, .btn-confirm { padding: 12px 25px; border-radius: 8px; font-weight: 600; border: none; }
    .btn-cancel { background: #6c757d; color: white; }
    .btn-confirm { background: linear-gradient(45deg, #4caf50, #8bc34a); color: white; }
    .section-header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 20px; }
    .header-actions { display: flex; align-items: center; flex-wrap: wrap; gap: 20px; }
    .btn-group .btn-sm { font-size: 14px; padding: 8px 16px; }
    @media (max-width: 992px) {
        .fee-table thead { display: none; }
        .fee-table tbody tr { display: block; margin-bottom: 15px; border: 1px solid #e9ecef; border-radius: 10px; padding: 15px; }
        .fee-table tbody td { display: flex; justify-content: space-between; align-items: center; padding: 10px 0; border-bottom: 1px solid #f1f3f4; }
        .fee-table tbody td:last-child { border-bottom: none; }
        .fee-table tbody td::before { content: attr(data-label); font-weight: 600; color: #495057; min-width: 100px; }
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
                          
    const filterButtons = document.querySelectorAll('.filter-btn');
    const paymentModalEl = document.getElementById('collectFeeModal');
                          
    if (filterButtons.length > 0) {
        const tableRows = document.querySelectorAll('.fee-table tbody tr[data-status]');
        filterButtons.forEach(button => {
            button.addEventListener('click', function() {
                filterButtons.forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
                const filterValue = this.getAttribute('data-filter');
                tableRows.forEach(row => {
                    const displayStyle = (filterValue === 'all' || row.getAttribute('data-status') === filterValue)
                        ? (window.innerWidth <= 992 ? 'block' : 'table-row')
                        : 'none';
                    row.style.display = displayStyle;
                });
            });
        });
    }

    
    if (paymentModalEl) {
        const paymentModal = new bootstrap.Modal(paymentModalEl);
        const modalElements = {
            amountBase: document.getElementById('modal_amount_base'),
            fine: document.getElementById('modal_fine'),
            discount: document.getElementById('modal_discount'),
            totalDisplay: document.getElementById('total-amount-display'),
            hiddenTotalAmount: document.getElementById('hidden_total_amount'),
        };

        const updateModalTotal = () => {
            const base = parseFloat(modalElements.amountBase.value) || 0;
            const fine = parseFloat(modalElements.fine.value) || 0;
            const discount = parseFloat(modalElements.discount.value) || 0;
            const maxDiscount = base + fine;
            const validDiscount = Math.max(0, Math.min(discount, maxDiscount));
            if (discount !== validDiscount) modalElements.discount.value = validDiscount.toFixed(2);
            const total = base + fine - validDiscount;
            modalElements.totalDisplay.textContent = total.toLocaleString('pt-MZ', { style: 'currency', currency: 'MZN' });
            if (window.Livewire) {
                @this.set('amount', total.toFixed(2), true);
                @this.set('fine', fine.toFixed(2), true);
                @this.set('discount', validDiscount.toFixed(2), true);
            }
        };

        // Apenas desconto é editável, multa é calculada automaticamente
        ['input', 'change'].forEach(evt => {
            modalElements.discount.addEventListener(evt, updateModalTotal);
        });

        // Listener para mudança de método de pagamento (Livewire)
        window.addEventListener('paymentModeChanged', () => {
            console.log('Método de pagamento mudou - recalculando total');
            updateModalTotal();
        });

        window.openPaymentModal = function(month, year, baseAmount, fine, discount) {
            modalElements.amountBase.value = baseAmount.toFixed(2);
            modalElements.fine.value = fine.toFixed(2);
            modalElements.discount.value =  discount.toFixed(2);
            if (window.Livewire) {
                @this.set('month', month, true);
                @this.set('year', year, true);
                @this.set('fine', fine.toFixed(2), true);
                @this.set('discount', discount.toFixed(2), true);
            }
            updateModalTotal();
            paymentModal.show();
        };
    }

    if (window.Livewire) {
        // Fechar modal após salvar pagamento
        window.addEventListener('closeModal', () => {
            const modalInstance = bootstrap.Modal.getInstance(paymentModalEl);
            if (modalInstance) {
                modalInstance.hide();
            }
            // Recarregar página para mostrar dados atualizados
            setTimeout(() => {
                window.location.reload();
            }, 500);
        });

        window.addEventListener('paymentSuccess', event => {
            const modalInstance = bootstrap.Modal.getInstance(paymentModalEl);
            if(modalInstance) modalInstance.hide();
            Swal.fire({ icon: 'success', title: 'Sucesso!', text: event.detail.message, timer: 2500, showConfirmButton: false })
               .then(() => { window.location.reload(); });
        });
        window.addEventListener('paymentError', event => {
            Swal.fire({ icon: 'error', title: 'Erro!', text: event.detail.message });
        });

        // Event listeners para download de comprovativo e recibo
        window.addEventListener('download-receipt', event => {
            const data = event.detail;
            if (data.url) {
                window.open(data.url, '_blank');
                if (data.message) {
                    Swal.fire({ icon: 'success', title: 'Sucesso!', text: data.message, timer: 2000, showConfirmButton: false });
                }
            }
        });

        window.addEventListener('error', event => {
            const data = event.detail;
            if (data.message) {
                Swal.fire({ icon: 'error', title: 'Erro!', text: data.message });
            }
        });
    }

    // Filtros para tabela de referências (mesma lógica da tabela de mensalidades)
    const refFilterButtons = document.querySelectorAll('[data-filter-ref]');
    if (refFilterButtons.length > 0) {
        const refTableRows = document.querySelectorAll('.month-group-card table tbody tr[data-status]');

        refFilterButtons.forEach(button => {
            button.addEventListener('click', function() {
                refFilterButtons.forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
                const filterValue = this.getAttribute('data-filter-ref');

                // Filtrar linhas usando data-status (igual à tabela de mensalidades)
                refTableRows.forEach(row => {
                    const displayStyle = (filterValue === 'all' || row.getAttribute('data-status') === filterValue)
                        ? (window.innerWidth <= 992 ? 'block' : 'table-row')
                        : 'none';
                    row.style.display = displayStyle;
                });

                // Mostrar/ocultar grupos de mês baseado em linhas visíveis
                const monthGroups = document.querySelectorAll('.month-group-card');
                monthGroups.forEach(group => {
                    const visibleRows = group.querySelectorAll('table tbody tr[data-status]:not([style*="display: none"])');
                    group.style.display = visibleRows.length > 0 ? '' : 'none';
                });
            });
        });
    }
});

// Função para fechar modal de referência e abrir modal de pagamento
function closeModalAndOpenPayment(month, year, baseAmount, fine, discount) {
    // Fechar modal de referência via Livewire
    Livewire.emit('closeReferenceModal');

    // Aguardar um pouco e abrir modal de pagamento usando função existente
    setTimeout(() => {
        openPaymentModal(month, year, baseAmount || 0, fine || 0, discount || 0);
    }, 300);
}
</script>
