<div>
    <div class="page-content">
        <div class="main-wrapper">
            {{-- Header --}}
            <div class="row mb-4">
                <div class="col">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h4 class="card-title mb-1">
                                        <i class="fas fa-file-import text-primary me-2"></i>
                                        Importar Pagamentos
                                    </h4>
                                    <p class="text-muted mb-0">Importe pagamentos manuais a partir de ficheiro Excel</p>
                                </div>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="badge {{ $step >= 1 ? 'bg-primary' : 'bg-secondary' }} px-3 py-2">1. Upload</span>
                                    <i class="fas fa-chevron-right text-muted"></i>
                                    <span class="badge {{ $step >= 2 ? 'bg-primary' : 'bg-secondary' }} px-3 py-2">2. Preview</span>
                                    <i class="fas fa-chevron-right text-muted"></i>
                                    <span class="badge {{ $step >= 3 ? 'bg-primary' : 'bg-secondary' }} px-3 py-2">3. Resultado</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Flash Messages --}}
            @if(session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show">
                    <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            {{-- Step 1: Upload --}}
            @if($step == 1)
            <div class="row">
                <div class="col-lg-8">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="alert alert-info border-0">
                                <h6 class="alert-heading"><i class="fas fa-info-circle"></i> Importar Pagamentos Manuais</h6>
                                <p class="mb-1">Use esta funcionalidade para importar pagamentos realizados manualmente
                                   (dinheiro, banco, mobile) antes da activacao do sistema BMEPS.</p>
                                <p class="mb-0"><strong>Importante:</strong> O sistema verifica automaticamente se ja existe
                                   pagamento para cada mes/ano do estudante, evitando duplicatas.</p>
                            </div>

                            <div class="mb-4">
                                <button wire:click="downloadTemplate" class="btn btn-outline-primary">
                                    <i class="fas fa-download me-1"></i> Baixar Template Excel
                                </button>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">Ficheiro Excel (.xlsx)</label>
                                <input type="file" wire:model="excel_file"
                                       class="form-control @error('excel_file') is-invalid @enderror"
                                       accept=".xlsx,.xls">
                                @error('excel_file')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <div wire:loading wire:target="excel_file" class="mt-2">
                                    <div class="spinner-border spinner-border-sm text-primary" role="status"></div>
                                    <span class="text-muted">A processar ficheiro...</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4">
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-light">
                            <h6 class="mb-0"><i class="fas fa-table me-1"></i> Formato do Excel</h6>
                        </div>
                        <div class="card-body p-0">
                            <table class="table table-sm mb-0">
                                <thead class="table-light">
                                    <tr><th>Coluna</th><th>Exemplo</th></tr>
                                </thead>
                                <tbody>
                                    <tr><td>Numero Aluno</td><td><code>1234567</code></td></tr>
                                    <tr><td>Mes (01-12)</td><td><code>01</code></td></tr>
                                    <tr><td>Ano</td><td><code>2025</code></td></tr>
                                    <tr><td>Valor (MT)</td><td><code>2500.00</code></td></tr>
                                    <tr><td>Data Pagamento</td><td><code>15/01/2025</code></td></tr>
                                    <tr><td>Modo Pagamento</td><td><code>Cash</code></td></tr>
                                    <tr><td>Observacao</td><td><code>Secretaria</code></td></tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="card-footer bg-light">
                            <small class="text-muted">
                                <strong>Modo Pagamento:</strong> Cash, Bank, Mobile, POS, Dinheiro, Banco, M-Pesa, E-Mola
                            </small>
                        </div>
                    </div>
                </div>
            </div>
            @endif

            {{-- Step 2: Preview --}}
            @if($step == 2)
            <div class="row mb-3">
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm bg-success text-white">
                        <div class="card-body text-center py-3">
                            <h3 class="mb-0">{{ $valid_count }}</h3>
                            <small>Validos (serao importados)</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm bg-warning text-dark">
                        <div class="card-body text-center py-3">
                            <h3 class="mb-0">{{ $duplicate_count }}</h3>
                            <small>Duplicados (serao ignorados)</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm bg-danger text-white">
                        <div class="card-body text-center py-3">
                            <h3 class="mb-0">{{ $invalid_count }}</h3>
                            <small>Invalidos (serao ignorados)</small>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="table-responsive" style="max-height: 500px; overflow-y: auto;">
                        <table class="table table-sm table-bordered table-hover">
                            <thead class="table-dark sticky-top">
                                <tr>
                                    <th>#</th>
                                    <th>N. Aluno</th>
                                    <th>Nome</th>
                                    <th>Mes</th>
                                    <th>Ano</th>
                                    <th>Valor</th>
                                    <th>Data Pgto</th>
                                    <th>Modo</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($preview_data as $row)
                                <tr class="@if($row['status']==='valid') table-success
                                           @elseif($row['status']==='duplicate') table-warning
                                           @else table-danger @endif">
                                    <td>{{ $row['row_number'] }}</td>
                                    <td>{{ $row['numero_aluno'] }}</td>
                                    <td>{{ $row['student_name'] }}</td>
                                    <td>{{ str_pad($row['mes'], 2, '0', STR_PAD_LEFT) }}</td>
                                    <td>{{ $row['ano'] }}</td>
                                    <td class="text-end">{{ number_format($row['valor'], 2, ',', '.') }} MT</td>
                                    <td>{{ $row['data_pagamento'] }}</td>
                                    <td>{{ $row['modo_pagamento'] }}</td>
                                    <td>
                                        @if($row['status'] === 'valid')
                                            <span class="badge bg-success">Valido</span>
                                        @elseif($row['status'] === 'duplicate')
                                            <span class="badge bg-warning text-dark">Duplicado</span>
                                        @else
                                            <span class="badge bg-danger">Invalido</span>
                                        @endif
                                        @foreach($row['errors'] as $err)
                                            <br><small class="text-muted">{{ $err }}</small>
                                        @endforeach
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-between mt-3">
                        <button wire:click="resetImport" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i> Voltar
                        </button>
                        @if($valid_count > 0)
                        <button wire:click="confirmImport" class="btn btn-primary"
                                wire:loading.attr="disabled" wire:target="confirmImport">
                            <span wire:loading wire:target="confirmImport">
                                <span class="spinner-border spinner-border-sm" role="status"></span>
                            </span>
                            <i class="fas fa-check me-1"></i> Importar {{ $valid_count }} Pagamentos
                        </button>
                        @else
                        <button class="btn btn-secondary" disabled>
                            Nenhum pagamento valido para importar
                        </button>
                        @endif
                    </div>
                </div>
            </div>
            @endif

            {{-- Step 3: Results --}}
            @if($step == 3 && $import_result)
            <div class="row">
                <div class="col-lg-8 mx-auto">
                    <div class="alert alert-success border-0 shadow-sm">
                        <h5 class="alert-heading"><i class="fas fa-check-circle"></i> Importacao concluida!</h5>
                        <p class="mb-0">Os pagamentos foram registados com sucesso no sistema.</p>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="card border-success">
                                <div class="card-body text-center">
                                    <h2 class="text-success mb-0">{{ $import_result['imported'] }}</h2>
                                    <p class="text-muted mb-0">Importados</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-warning">
                                <div class="card-body text-center">
                                    <h2 class="text-warning mb-0">{{ $import_result['skipped'] }}</h2>
                                    <p class="text-muted mb-0">Ignorados</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-info">
                                <div class="card-body text-center">
                                    <h2 class="text-info mb-0">{{ $import_result['total'] }}</h2>
                                    <p class="text-muted mb-0">Total</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="text-center">
                        <button wire:click="resetImport" class="btn btn-primary">
                            <i class="fas fa-redo me-1"></i> Importar Novamente
                        </button>
                        <a href="{{ route('admin.fee.dashboard') }}" class="btn btn-outline-secondary ms-2">
                            <i class="fas fa-chart-bar me-1"></i> Dashboard Pagamentos
                        </a>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
