<div class="page-content">
    <div class="main-wrapper">
        <style>
            @media print {
                .no-print {
                    display: none !important;
                }
                .page-sidebar, .page-header, .btn {
                    display: none !important;
                }
                .receipt-container {
                    box-shadow: none !important;
                    margin: 0 !important;
                    padding: 20px !important;
                }
            }

            .receipt-container {
                max-width: 900px;
                margin: 0 auto;
                background: white;
                padding: 40px;
                box-shadow: 0 2px 10px rgba(0,0,0,0.08);
                border: 1px solid #e0e0e0;
            }

            /* Professional Header */
            .receipt-header {
                display: grid;
                grid-template-columns: 1fr auto;
                gap: 30px;
                padding-bottom: 25px;
                margin-bottom: 30px;
                border-bottom: 3px solid #2c3e50;
            }

            .company-info h1 {
                margin: 0 0 8px 0;
                font-size: 28px;
                font-weight: 700;
                color: #2c3e50;
                letter-spacing: -0.5px;
            }

            .company-info p {
                margin: 4px 0;
                font-size: 13px;
                color: #6c757d;
                line-height: 1.6;
            }

            .company-info .tagline {
                font-size: 12px;
                color: #95a5a6;
                font-style: italic;
                margin-top: 2px;
            }

            /* Receipt Number Box */
            .receipt-number-box {
                text-align: right;
                min-width: 220px;
            }

            .receipt-type {
                font-size: 11px;
                color: #7f8c8d;
                font-weight: 600;
                text-transform: uppercase;
                letter-spacing: 1.5px;
                margin-bottom: 8px;
            }

            .receipt-number {
                font-size: 24px;
                font-weight: 700;
                color: #2c3e50;
                font-family: 'Courier New', monospace;
                letter-spacing: 1px;
                margin-bottom: 12px;
            }

            .receipt-date {
                font-size: 13px;
                color: #6c757d;
            }

            .receipt-date strong {
                color: #2c3e50;
                font-weight: 600;
            }

            /* Info Grid - Professional Layout */
            .info-grid {
                display: grid;
                grid-template-columns: 1fr 1fr;
                gap: 25px;
                margin-bottom: 30px;
            }

            .info-section {
                background: #f8f9fa;
                padding: 18px;
                border-left: 4px solid #3498db;
            }

            .info-section h3 {
                font-size: 11px;
                font-weight: 700;
                color: #7f8c8d;
                text-transform: uppercase;
                letter-spacing: 1px;
                margin: 0 0 12px 0;
            }

            .info-item {
                display: flex;
                justify-content: space-between;
                padding: 6px 0;
                font-size: 13px;
            }

            .info-label {
                color: #6c757d;
                font-weight: 500;
            }

            .info-value {
                color: #2c3e50;
                font-weight: 600;
                text-align: right;
            }

            /* Items Table - ERP Style */
            .items-table {
                width: 100%;
                margin: 30px 0;
                border-collapse: collapse;
                border: 1px solid #dee2e6;
            }

            .items-table thead {
                background: linear-gradient(to bottom, #34495e, #2c3e50);
            }

            .items-table th {
                padding: 14px 12px;
                text-align: left;
                font-size: 11px;
                font-weight: 700;
                color: white;
                text-transform: uppercase;
                letter-spacing: 0.8px;
                border-right: 1px solid rgba(255,255,255,0.1);
            }

            .items-table th:last-child {
                border-right: none;
            }

            .items-table th.text-end {
                text-align: right;
            }

            .items-table tbody tr {
                border-bottom: 1px solid #dee2e6;
            }

            .items-table tbody tr:hover {
                background-color: #f8f9fa;
            }

            .items-table tbody tr:last-child {
                border-bottom: 2px solid #2c3e50;
            }

            .items-table td {
                padding: 14px 12px;
                font-size: 13px;
                color: #2c3e50;
            }

            .items-table .product-name {
                font-weight: 600;
                color: #2c3e50;
                margin-bottom: 2px;
            }

            .items-table .product-meta {
                font-size: 11px;
                color: #6c757d;
                margin-top: 4px;
            }

            .items-table .text-end {
                text-align: right;
            }

            .items-table .item-total {
                font-weight: 700;
                color: #2c3e50;
            }

            /* Totals Section - Professional */
            .totals-wrapper {
                display: flex;
                justify-content: flex-end;
                margin-top: 25px;
                padding-top: 25px;
                border-top: 2px solid #dee2e6;
            }

            .totals-box {
                min-width: 400px;
                background: #f8f9fa;
                border: 1px solid #dee2e6;
            }

            .totals-row {
                display: flex;
                justify-content: space-between;
                padding: 10px 20px;
                font-size: 14px;
                border-bottom: 1px solid #dee2e6;
            }

            .totals-label {
                color: #6c757d;
                font-weight: 500;
            }

            .totals-value {
                font-weight: 600;
                color: #2c3e50;
                font-family: 'Courier New', monospace;
            }

            .totals-discount .totals-value {
                color: #e74c3c;
            }

            .totals-grand {
                background: linear-gradient(to right, #2c3e50, #34495e);
                color: white;
                font-size: 16px;
                font-weight: 700;
                border-bottom: none;
            }

            .totals-grand .totals-label,
            .totals-grand .totals-value {
                color: white;
            }

            /* Notes Box */
            .notes-box {
                margin: 25px 0;
                padding: 16px;
                background: #fff3cd;
                border-left: 4px solid #ffc107;
                border-radius: 4px;
            }

            .notes-box strong {
                display: block;
                color: #856404;
                font-size: 12px;
                font-weight: 700;
                text-transform: uppercase;
                margin-bottom: 8px;
                letter-spacing: 0.5px;
            }

            .notes-box p {
                margin: 0;
                color: #856404;
                font-size: 13px;
                line-height: 1.6;
            }

            /* Status Badge */
            .status-section {
                text-align: center;
                margin: 30px 0;
                padding: 20px 0;
            }

            .status-badge {
                display: inline-flex;
                align-items: center;
                gap: 8px;
                padding: 10px 25px;
                background: #27ae60;
                color: white;
                font-size: 13px;
                font-weight: 700;
                text-transform: uppercase;
                letter-spacing: 1px;
                border-radius: 4px;
                box-shadow: 0 2px 8px rgba(39, 174, 96, 0.3);
            }

            /* Footer */
            .receipt-footer {
                margin-top: 40px;
                padding-top: 25px;
                border-top: 2px solid #dee2e6;
                text-align: center;
            }

            .footer-message {
                font-size: 14px;
                color: #2c3e50;
                font-weight: 600;
                margin-bottom: 12px;
            }

            .footer-info {
                font-size: 12px;
                color: #6c757d;
                margin: 6px 0;
            }

            .footer-timestamp {
                font-size: 11px;
                color: #95a5a6;
                margin-top: 15px;
                font-style: italic;
            }

            /* Payment Method Badge */
            .payment-badge {
                display: inline-block;
                padding: 4px 10px;
                background: #3498db;
                color: white;
                font-size: 11px;
                font-weight: 600;
                border-radius: 3px;
                text-transform: uppercase;
            }
        </style>

        <div class="receipt-container">
            <!-- Action Buttons -->
            <div class="text-center mb-4 no-print">
                <button onclick="window.print()" class="btn btn-primary btn-lg">
                    <i class="fas fa-print me-2"></i> Imprimir
                </button>
                <a href="#" wire:click.prevent="downloadPDF" class="btn btn-danger btn-lg">
                    <i class="fas fa-file-pdf me-2"></i> Baixar PDF
                </a>
                <a href="{{ route('admin.pos.sales-report') }}" class="btn btn-secondary btn-lg">
                    <i class="fas fa-arrow-left me-2"></i> Voltar
                </a>
            </div>

            <!-- Professional Header -->
            <div class="receipt-header">
                <div class="company-info">
                    <h1>{{ $store_name }}</h1>
                    <p class="tagline">Sistema de Gestão Escolar</p>
                    <p><i class="fas fa-phone me-2"></i> +258 84 123 4567</p>
                    <p><i class="fas fa-envelope me-2"></i> info@copmoz.co.mz</p>
                    <p><i class="fas fa-map-marker-alt me-2"></i> Maputo, Moçambique</p>
                </div>
                <div class="receipt-number-box">
                    <div class="receipt-type">Recibo de Venda</div>
                    <div class="receipt-number">{{ $sale->sale_number }}</div>
                    <div class="receipt-date">
                        <strong>Data:</strong> {{ $sale->sale_date->format('d/m/Y') }}<br>
                        <strong>Hora:</strong> {{ $sale->sale_date->format('H:i:s') }}
                    </div>
                </div>
            </div>

            <!-- Info Grid -->
            <div class="info-grid">
                <div class="info-section">
                    <h3><i class="fas fa-user me-2"></i>Informações do Caixa</h3>
                    <div class="info-item">
                        <span class="info-label">Operador:</span>
                        <span class="info-value">{{ $sale->cashier->name ?? 'Sistema' }}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Método de Pagamento:</span>
                        <span class="info-value">
                            @if($sale->payment_method == 'cash')
                                <span class="payment-badge" style="background: #27ae60;">Dinheiro</span>
                            @elseif($sale->payment_method == 'mpesa')
                                <span class="payment-badge" style="background: #e74c3c;">M-Pesa</span>
                            @elseif($sale->payment_method == 'emola')
                                <span class="payment-badge" style="background: #9b59b6;">e-Mola</span>
                            @elseif($sale->payment_method == 'bank_transfer')
                                <span class="payment-badge" style="background: #3498db;">Transferência</span>
                            @else
                                <span class="payment-badge">{{ ucfirst($sale->payment_method) }}</span>
                            @endif
                        </span>
                    </div>
                </div>

                @if($sale->user)
                <div class="info-section" style="border-left-color: #27ae60;">
                    <h3><i class="fas fa-user-graduate me-2"></i>Informações do Cliente</h3>
                    <div class="info-item">
                        <span class="info-label">Nome:</span>
                        <span class="info-value">{{ $sale->user->name }}</span>
                    </div>
                    @if($sale->user->student_id)
                    <div class="info-item">
                        <span class="info-label">ID Estudante:</span>
                        <span class="info-value">{{ $sale->user->student_id }}</span>
                    </div>
                    @endif
                </div>
                @endif
            </div>

            <!-- Items Table -->
            <table class="items-table">
                <thead>
                    <tr>
                        <th style="width: 8%;">#</th>
                        <th style="width: 42%;">Produto</th>
                        <th style="width: 15%;" class="text-end">Quantidade</th>
                        <th style="width: 17.5%;" class="text-end">Preço Unit.</th>
                        <th style="width: 17.5%;" class="text-end">Total</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($sale->items as $index => $item)
                    <tr>
                        <td style="color: #95a5a6; font-weight: 600;">{{ $index + 1 }}</td>
                        <td>
                            <div class="product-name">{{ $item->product_name }}</div>
                            <div class="product-meta">
                                @if($item->variant)
                                    Variante: {{ $item->variant }} &bull;
                                @endif
                                SKU: {{ $item->product_sku }}
                            </div>
                        </td>
                        <td class="text-end">{{ $item->quantity }}</td>
                        <td class="text-end">{{ number_format($item->unit_price, 2) }} MT</td>
                        <td class="text-end item-total">{{ number_format($item->total, 2) }} MT</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <!-- Totals -->
            <div class="totals-wrapper">
                <div class="totals-box">
                    <div class="totals-row">
                        <span class="totals-label">Subtotal</span>
                        <span class="totals-value">{{ number_format($sale->subtotal, 2) }} MT</span>
                    </div>
                    @if($sale->discount > 0)
                    <div class="totals-row totals-discount">
                        <span class="totals-label">Desconto</span>
                        <span class="totals-value">-{{ number_format($sale->discount, 2) }} MT</span>
                    </div>
                    @endif
                    @if($sale->tax > 0)
                    <div class="totals-row">
                        <span class="totals-label">IVA (17%)</span>
                        <span class="totals-value">{{ number_format($sale->tax, 2) }} MT</span>
                    </div>
                    @endif
                    <div class="totals-row totals-grand">
                        <span class="totals-label">TOTAL A PAGAR</span>
                        <span class="totals-value">{{ number_format($sale->total, 2) }} MT</span>
                    </div>
                </div>
            </div>

            <!-- Notes -->
            @if($sale->notes)
            <div class="notes-box">
                <strong><i class="fas fa-sticky-note me-2"></i>Observações</strong>
                <p>{{ $sale->notes }}</p>
            </div>
            @endif

            <!-- Status -->
            @if($sale->status == 'completed')
            <div class="status-section">
                <div class="status-badge">
                    <i class="fas fa-check-circle"></i>
                    <span>Pagamento Confirmado</span>
                </div>
            </div>
            @endif

            <!-- Footer -->
            <div class="receipt-footer">
                <div class="footer-message">{{ $receipt_footer }}</div>
                <div class="footer-info">Este documento foi gerado eletronicamente e tem validade sem assinatura.</div>
                <div class="footer-info">Sistema de Gestão Escolar COPMOZ &copy; {{ date('Y') }}</div>
                <div class="footer-timestamp">Impresso em: {{ now()->format('d/m/Y \à\s H:i:s') }}</div>
            </div>
        </div>
    </div>
</div>
