<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    {{-- Top Banner --}}
                    <div class="card mb-3" style="border: none; border-radius: 10px; overflow: hidden; box-shadow: 0 4px 15px rgba(0,0,0,0.08);">
                        <div style="background: linear-gradient(135deg, #1a5276 0%, #2e86de 100%); padding: 20px 25px; color: white;">
                            <div class="d-flex justify-content-between align-items-start">
                                <div>
                                    <a href="{{ route('admin.secretary.pre-enrollments') }}" style="color: rgba(255,255,255,0.8); text-decoration: none; font-size: 0.8rem;">
                                        <i class="fas fa-arrow-left me-1"></i> Voltar à lista
                                    </a>
                                    <h4 class="mb-1 mt-2" style="font-weight: 700;">Pré-inscrição {{ $preEnrollment->code }}</h4>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="badge bg-{{ $preEnrollment->getStatusBadgeClass() }}" style="font-size: 0.8rem; padding: 5px 12px;">
                                            {{ $preEnrollment->getStatusLabel() }}
                                        </span>
                                        <span style="opacity: 0.8; font-size: 0.85rem;">
                                            {{ $preEnrollment->candidate_name }}
                                        </span>
                                    </div>
                                </div>
                                <div class="d-flex gap-2 mt-2">
                                    @if(!$preEnrollment->isAnulada())
                                        <a href="{{ route('admin.secretary.edit', $preEnrollment->id) }}" class="btn btn-sm" style="background: rgba(255,255,255,0.15); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 6px;">
                                            <i class="fas fa-edit me-1"></i> Editar
                                        </a>
                                    @endif
                                    @if($preEnrollment->isPendente())
                                        <button class="btn btn-sm" style="background: #27ae60; color: white; font-weight: 600; border-radius: 6px;" wire:click="confirmInscricao">
                                            <i class="fas fa-check-circle me-1"></i> Confirmar Inscrição
                                        </button>
                                        <button class="btn btn-sm" style="background: rgba(255,255,255,0.15); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 6px;" wire:click="anularInscricao">
                                            <i class="fas fa-ban me-1"></i> Anular
                                        </button>
                                    @endif
                                    @if($preEnrollment->isConfirmada())
                                        <a href="{{ route('admin.secretary.enroll', $preEnrollment->id) }}" class="btn btn-sm" style="background: #27ae60; color: white; font-weight: 600; border-radius: 6px;">
                                            <i class="fas fa-user-graduate me-1"></i> Matricular
                                        </a>
                                        <button class="btn btn-sm" style="background: rgba(255,255,255,0.15); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 6px;" wire:click="anularInscricao">
                                            <i class="fas fa-ban me-1"></i> Anular
                                        </button>
                                    @endif
                                    @if(!$preEnrollment->isAnulada())
                                        <a href="{{ route('admin.secretary.pdf', $preEnrollment->id) }}" class="btn btn-sm" style="background: #e74a3b; color: white; font-weight: 600; border-radius: 6px;" target="_blank">
                                            <i class="fas fa-file-pdf me-1"></i> Baixar Ficha
                                        </a>
                                    @endif
                                    @if($preEnrollment->isMatriculada())
                                        <span class="btn btn-sm" style="background: rgba(39,174,96,0.2); color: #d4edda; border-radius: 6px; cursor: default;">
                                            <i class="fas fa-check-double me-1"></i> Matriculado
                                        </span>
                                    @endif
                                    @if($preEnrollment->isAnulada())
                                        <span class="btn btn-sm" style="background: rgba(231,74,59,0.2); color: #f5c6cb; border-radius: 6px; cursor: default;">
                                            <i class="fas fa-ban me-1"></i> Anulado
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        {{-- Left Column --}}
                        <div class="col-md-6">
                            {{-- Dados do Candidato --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #4e73df, #224abe); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-user me-2"></i>Dados do Candidato
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    @if($preEnrollment->candidate_photo)
                                        <div class="text-center py-3" style="background: #f8f9ff; border-bottom: 1px solid #e2e8f0;">
                                            <img src="{{ Storage::url($preEnrollment->candidate_photo) }}" alt="Foto do candidato" style="max-height: 120px; border-radius: 10px; border: 3px solid #4e73df; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
                                        </div>
                                    @endif
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #f8f9ff;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Código</td><td style="padding: 0.5rem 1rem; font-weight: 700; color: #1a5276;">{{ $preEnrollment->code }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Nome</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->candidate_name }}</td></tr>
                                        <tr style="background: #f8f9ff;"><td class="text-muted" style="padding: 0.5rem 1rem;">Sexo</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->candidate_sex }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Data Nasc.</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->candidate_dob ? $preEnrollment->candidate_dob->format('d/m/Y') : '-' }}</td></tr>
                                        <tr style="background: #f8f9ff;"><td class="text-muted" style="padding: 0.5rem 1rem;">Estado Civil</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->marital_status ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Nacionalidade</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->nationality ?? '-' }}</td></tr>
                                        <tr style="background: #f8f9ff;"><td class="text-muted" style="padding: 0.5rem 1rem;">NUIT</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->nuit ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Contacto</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->candidate_phone }}</td></tr>
                                        <tr style="background: #f8f9ff;"><td class="text-muted" style="padding: 0.5rem 1rem;">WhatsApp</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->candidate_whatsapp ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Email</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->candidate_email ?? '-' }}</td></tr>
                                        <tr style="background: #f8f9ff;"><td class="text-muted" style="padding: 0.5rem 1rem;">Origem</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->candidate_origin ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Doença Crónica</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->chronic_disease ? 'Sim — ' . $preEnrollment->chronic_disease_details : 'Não' }}</td></tr>
                                    </table>
                                </div>
                            </div>

                            {{-- Documentos & Ingresso --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #1cc88a, #169b6b); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-file-alt me-2"></i>Documentos & Ingresso
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #f0fdf4;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Tipo Doc.</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->document_type ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Nº Documento</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->document_id ?? '-' }}</td></tr>
                                        <tr style="background: #f0fdf4;"><td class="text-muted" style="padding: 0.5rem 1rem;">Local Emissão</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->document_issue_place ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Validade</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->document_expiry_date ? $preEnrollment->document_expiry_date->format('d/m/Y') : '-' }}</td></tr>
                                        <tr style="background: #f0fdf4;"><td class="text-muted" style="padding: 0.5rem 1rem;">Via Ingresso</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->entry_type }}</td></tr>
                                        @if($preEnrollment->entry_type !== 'Normal')
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Inst. Origem</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->previous_institution ?? '-' }}</td></tr>
                                        <tr style="background: #f0fdf4;"><td class="text-muted" style="padding: 0.5rem 1rem;">Curso Anterior</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->previous_course ?? '-' }}</td></tr>
                                        @endif
                                    </table>
                                </div>
                            </div>

                            {{-- Morada --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #fd7e14, #e8590c); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-map-marker-alt me-2"></i>Naturalidade & Morada
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #fff8f0;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Local Nasc.</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->birth_place ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Distrito Nasc.</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->birth_district ?? '-' }}</td></tr>
                                        <tr style="background: #fff8f0;"><td class="text-muted" style="padding: 0.5rem 1rem;">Província Nasc.</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->birth_province ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Prov. Residência</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->address_province ?? '-' }}</td></tr>
                                        <tr style="background: #fff8f0;"><td class="text-muted" style="padding: 0.5rem 1rem;">Distrito Res.</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->address_district ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Bairro</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->address_bairro ?? '-' }}</td></tr>
                                        <tr style="background: #fff8f0;"><td class="text-muted" style="padding: 0.5rem 1rem;">Rua / Nº Casa</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->address_street ?? '-' }} {{ $preEnrollment->address_house_number ? ', Nº ' . $preEnrollment->address_house_number : '' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Morada</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->candidate_address ?? '-' }}</td></tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        {{-- Right Column --}}
                        <div class="col-md-6">
                            {{-- Filiação --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #f6c23e, #dda20a); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-users me-2"></i>Filiação
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #fffdf0;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Pai</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->father_name ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Tel. Pai</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->father_phone ?? '-' }}</td></tr>
                                        <tr style="background: #fffdf0;"><td class="text-muted" style="padding: 0.5rem 1rem;">Mãe</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->mother_name ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Tel. Mãe</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->mother_phone ?? '-' }}</td></tr>
                                    </table>
                                </div>
                            </div>

                            {{-- Encarregado --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #e74a3b, #be2617); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-user-tie me-2"></i>Encarregado de Educação
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #fef2f2;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Nome</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->guardian_name ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Parentesco</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_relationship ?? '-' }}</td></tr>
                                        <tr style="background: #fef2f2;"><td class="text-muted" style="padding: 0.5rem 1rem;">Contacto</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->guardian_phone ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Email</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_email ?? '-' }}</td></tr>
                                        <tr style="background: #fef2f2;"><td class="text-muted" style="padding: 0.5rem 1rem;">Morada</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_address ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Nº BI</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_document_id ?? '-' }}</td></tr>
                                        <tr style="background: #fef2f2;"><td class="text-muted" style="padding: 0.5rem 1rem;">Local Emissão BI</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_document_issue_place ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Data Emissão BI</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_document_issue_date ? $preEnrollment->guardian_document_issue_date->format('d/m/Y') : '-' }}</td></tr>
                                        <tr style="background: #fef2f2;"><td class="text-muted" style="padding: 0.5rem 1rem;">Bairro</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_bairro ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Quarteirão</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_quarteirao ?? '-' }}</td></tr>
                                        <tr style="background: #fef2f2;"><td class="text-muted" style="padding: 0.5rem 1rem;">Local Trabalho</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->guardian_workplace ?? '-' }}</td></tr>
                                    </table>
                                </div>
                            </div>

                            {{-- Contacto Emergência --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #e83e8c, #c2185b); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-phone-alt me-2"></i>Contacto de Emergência
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #fdf2f8;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Nome</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->emergency_contact_name ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Telefone</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->emergency_contact_phone ?? '-' }}</td></tr>
                                    </table>
                                </div>
                            </div>

                            {{-- Curso/Turma --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #36b9cc, #258391); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-graduation-cap me-2"></i>Curso / Turma
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #f0fdfa;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Classe</td><td style="padding: 0.5rem 1rem; font-weight: 700; color: #1a5276;">{{ $preEnrollment->desired_class ? $preEnrollment->desired_class . 'a Classe' : '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Turma</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->desiredClassroom->name ?? '-' }}</td></tr>
                                        <tr style="background: #f0fdfa;"><td class="text-muted" style="padding: 0.5rem 1rem;">Turno</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->desired_shift ?? '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Ano Lectivo</td><td style="padding: 0.5rem 1rem; font-weight: 600;">{{ $preEnrollment->academic_year ?? '-' }}</td></tr>
                                    </table>
                                </div>
                            </div>

                            {{-- Datas / Status --}}
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #6f42c1, #5a32a3); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-calendar-alt me-2"></i>Datas / Status
                                    </h6>
                                </div>
                                <div class="card-body p-0">
                                    <table class="table table-sm mb-0" style="font-size: 0.85rem;">
                                        <tr style="background: #f5f0ff;"><td class="text-muted" style="width: 35%; padding: 0.5rem 1rem;">Submetida em</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->submitted_at ? $preEnrollment->submitted_at->format('d/m/Y H:i') : '-' }}</td></tr>
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Confirmada em</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->confirmed_at ? $preEnrollment->confirmed_at->format('d/m/Y H:i') : '-' }}</td></tr>
                                        <tr style="background: #f5f0ff;"><td class="text-muted" style="padding: 0.5rem 1rem;">Cancelada em</td><td style="padding: 0.5rem 1rem;">{{ $preEnrollment->cancelled_at ? $preEnrollment->cancelled_at->format('d/m/Y H:i') : '-' }}</td></tr>
                                        @if($preEnrollment->cancellation_reason)
                                        <tr><td class="text-muted" style="padding: 0.5rem 1rem;">Motivo</td><td style="padding: 0.5rem 1rem; color: #e74a3b; font-weight: 600;">{{ $preEnrollment->cancellation_reason }}</td></tr>
                                        @endif
                                        <tr style="background: #f5f0ff;">
                                            <td class="text-muted" style="padding: 0.5rem 1rem;">Status</td>
                                            <td style="padding: 0.5rem 1rem;">
                                                <span class="badge bg-{{ $preEnrollment->getStatusBadgeClass() }}" style="font-size: 0.8rem; padding: 4px 10px;">{{ $preEnrollment->getStatusLabel() }}</span>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            {{-- Observação --}}
                            @if($preEnrollment->observation)
                            <div class="card mb-3" style="border: none; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.06);">
                                <div class="card-header" style="background: linear-gradient(135deg, #858796, #5a5c69); padding: 10px 15px; border-radius: 10px 10px 0 0;">
                                    <h6 class="mb-0" style="font-weight: 600; color: white; font-size: 0.85rem;">
                                        <i class="fas fa-sticky-note me-2"></i>Observação
                                    </h6>
                                </div>
                                <div class="card-body" style="font-size: 0.85rem;">
                                    {{ $preEnrollment->observation }}
                                </div>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
