<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-sms me-2"></i>
                        Enviar SMS
                    </h2>
                    <a href="{{ route('admin.sms') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todos os SMS
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Checkbox para modo de números personalizados -->
                                    <div class="col-12">
                                        <div class="form-check form-switch p-3 bg-light rounded">
                                            <input type="checkbox"
                                                   class="form-check-input"
                                                   id="useCustomNumbers"
                                                   wire:model="useCustomNumbers"
                                                   style="width: 3em; height: 1.5em;">
                                            <label class="form-check-label ms-2 fw-semibold" for="useCustomNumbers">
                                                <i class="fas fa-mobile-alt me-2"></i>
                                                Enviar para Números Personalizados
                                            </label>
                                            <small class="d-block text-muted ms-5 mt-1">
                                                Ative para enviar SMS para números de telefone específicos
                                            </small>
                                        </div>
                                    </div>

                                    <!-- Campos para números personalizados -->
                                    @if($useCustomNumbers)
                                        <!-- Campo de Números -->
                                        <div class="col-12">
                                            <label for="customNumbers" class="form-label fw-semibold">
                                                Números de Telefone <span class="text-danger">*</span>
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-phone"></i></span>
                                                <textarea id="customNumbers"
                                                          wire:model.defer="customNumbers"
                                                          class="form-control custom-numbers-input @error('customNumbers') is-invalid @enderror"
                                                          rows="6"
                                                          placeholder="258843211234, 258823456789&#10;843211234&#10;+258823456789&#10;&#10;Insira os números separados por vírgula, espaço ou nova linha"
                                                          required></textarea>
                                            </div>
                                            @error('customNumbers') <span class="text-danger small">{{ $message }}</span> @enderror
                                            <small class="text-muted mt-1 d-block">
                                                <i class="fas fa-info-circle me-1"></i>
                                                Suporta múltiplos formatos: +258843211234, 258843211234, 843211234
                                            </small>
                                        </div>

                                        <!-- Mensagem -->
                                        <div class="col-12">
                                            <label for="message_custom" class="form-label fw-semibold">Mensagem <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-comment-dots"></i></span>
                                                <textarea id="message_custom"
                                                          wire:model="title"
                                                          class="form-control @error('title') is-invalid @enderror"
                                                          rows="5"
                                                          placeholder="Escreva a mensagem aqui..."
                                                          required></textarea>
                                            </div>
                                            @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                                        </div>
                                    @else
                                    <!-- Enviar Para -->
                                    <div class="col-md-6">
                                        <label for="type" class="form-label fw-semibold">Enviar Para <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-users"></i></span>
                                            <select id="type"
                                                    wire:model="type"
                                                    class="form-select"
                                                    required>
                                                <optgroup label="Estudantes">
                                                    <option value="all">Todos os Estudantes</option>
                                                    <option value="class">Estudantes de Turma(s)</option>
                                                    <option value="student">Estudante Específico</option>
                                                </optgroup>
                                                <optgroup label="Encarregados">
                                                    <option value="all_guardians">Todos os Encarregados</option>
                                                    <option value="class_guardians">Encarregados de Turma(s)</option>
                                                    <option value="guardian">Encarregado Específico</option>
                                                </optgroup>
                                            </select>
                                        </div>
                                    </div>

                                    <!-- Tipo de Estudante (apenas para tipos de estudante) -->
                                    @if(in_array($type, ['all', 'class', 'student', null, '']))
                                    <div class="col-md-6">
                                        <label class="form-label fw-semibold">Tipo de Estudantes <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-check"></i></span>
                                            <div class="form-control d-flex align-items-center gap-3">
                                                <div class="form-check">
                                                    <input type="radio"
                                                           class="form-check-input @error('student_type') is-invalid @enderror"
                                                           id="student_type_regular"
                                                           name="student_type"
                                                           value="1"
                                                           wire:model="student_type"
                                                           checked
                                                           required>
                                                    <label class="form-check-label" for="student_type_regular">
                                                        Regulares
                                                    </label>
                                                </div>
                                                <div class="form-check">
                                                    <input type="radio"
                                                           class="form-check-input @error('student_type') is-invalid @enderror"
                                                           id="student_type_irregular"
                                                           name="student_type"
                                                           value="0"
                                                           wire:model="student_type"
                                                           required>
                                                    <label class="form-check-label" for="student_type_irregular">
                                                        Irregulares
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        @error('student_type') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Turmas (múltipla seleção - para estudantes ou encarregados de turma) -->
                                    @if($type == "class" || $type == "class_guardians")
                                    <div class="col-12">
                                        <label for="class_ids" class="form-label fw-semibold">
                                            Turmas <span class="text-danger">*</span>
                                            <small class="text-muted">(Segure Ctrl/Cmd para selecionar múltiplas)</small>
                                        </label>
                                        <select id="class_ids"
                                                wire:model="class_ids"
                                                class="form-select turma-multiselect @error('class_ids') is-invalid @enderror"
                                                multiple
                                                size="8"
                                                required>
                                            @foreach($Classroom as $class)
                                                <option value="{{ $class->id }}">{{ $class->class }}ª Classe - {{ $class->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('class_ids') <span class="text-danger small">{{ $message }}</span> @enderror
                                        @if(!empty($class_ids))
                                            <div class="mt-2">
                                                <small class="text-success">
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    {{ count($class_ids) }} turma(s) selecionada(s)
                                                </small>
                                            </div>
                                        @endif
                                    </div>
                                    @endif

                                    <!-- Turma para selecionar estudante -->
                                    @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="class_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                            <select id="class_id"
                                                    wire:model="class_id"
                                                    class="form-select @error('class_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a turma...</option>
                                                @foreach($Classroom as $class)
                                                    <option value="{{ $class->id }}">{{ $class->class }}ª - {{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('class_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Estudante (condicional) -->
                                    @if($type == "student")
                                    <div class="col-md-6">
                                        <label for="student_id" class="form-label fw-semibold">Estudante <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-graduate"></i></span>
                                            <select id="student_id"
                                                    wire:model="student_id"
                                                    class="form-select @error('student_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o estudante...</option>
                                                @foreach($students as $student)
                                                    <option value="{{ $student->id }}">{{ $student->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('student_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Encarregado específico -->
                                    @if($type == "guardian")
                                    <div class="col-12">
                                        <label for="guardian_id" class="form-label fw-semibold">Encarregado <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-shield"></i></span>
                                            <select id="guardian_id"
                                                    wire:model="guardian_id"
                                                    class="form-select @error('guardian_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o encarregado...</option>
                                                @foreach($guardians as $g)
                                                    <option value="{{ $g->id }}">{{ $g->name }} ({{ $g->phone }})</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('guardian_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif

                                    <!-- Mensagem -->
                                    <div class="col-12">
                                        <label for="message" class="form-label fw-semibold">Mensagem <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light align-items-start pt-2"><i class="fas fa-comment-dots"></i></span>
                                            <textarea id="message"
                                                      wire:model="title"
                                                      class="form-control @error('title') is-invalid @enderror"
                                                      rows="5"
                                                      placeholder="Escreva a mensagem aqui..."
                                                      required></textarea>
                                        </div>
                                        @error('title') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>
                                    @endif
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-paper-plane me-2"></i>Enviar SMS
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Enviando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }

        .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }

        .turma-multiselect {
            min-height: 200px !important;
            border: 2px solid #e3e6f0;
            border-radius: 0.35rem;
            padding: 0.5rem;
            background-color: #fff;
        }

        .turma-multiselect:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }

        .turma-multiselect option {
            padding: 0.75rem;
            margin-bottom: 0.25rem;
            border-radius: 0.25rem;
            cursor: pointer;
            transition: all 0.2s;
        }

        .turma-multiselect option:hover {
            background-color: #e7f3ff;
            color: #0066cc;
        }

        .turma-multiselect option:checked {
            background: linear-gradient(135deg, #0066cc 0%, #004c99 100%);
            color: white;
            font-weight: 600;
        }

        .turma-multiselect option:checked:hover {
            background: linear-gradient(135deg, #004c99 0%, #003366 100%);
        }

        .custom-numbers-input {
            font-family: 'Courier New', monospace;
            font-size: 0.95rem;
            line-height: 1.6;
        }

        .form-check-switch .form-check-input {
            cursor: pointer;
        }

        .form-check-switch .form-check-input:checked {
            background-color: #0d6efd;
            border-color: #0d6efd;
        }
    </style>
</div>
