<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <!-- Coluna Esquerda - Pesquisa e Seleção -->
                <div class="col-lg-5">
                    <!-- Card de Pesquisa -->
                    <div class="card border-0 shadow-sm mb-3">
                        <div class="card-header bg-primary text-white py-3">
                            <h5 class="mb-0">
                                <i class="fas fa-search me-2"></i>Adicionar Estudantes
                            </h5>
                        </div>
                        <div class="card-body">
                            <!-- Pesquisa por Código -->
                            <div class="mb-3 position-relative">
                                <label class="form-label fw-semibold">Pesquisar por ID do Estudante ou Nome</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-light"><i class="fas fa-search"></i></span>
                                    <input type="text"
                                           wire:model.debounce.200ms="studentCode"
                                           wire:keydown.enter="addStudentByCode"
                                           wire:keydown.escape="$set('searchResults', [])"
                                           class="form-control form-control-lg"
                                           placeholder="Pesquisar por código ou nome..."
                                           autocomplete="off">
                                    <button wire:click="addStudentByCode" class="btn btn-primary" type="button" title="Adicionar pelo código exato">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>

                                <!-- Autocomplete Dropdown -->
                                @if(count($searchResults) > 0)
                                <div class="autocomplete-dropdown">
                                    @foreach($searchResults as $student)
                                    <div wire:click="addStudent('{{ $student['id'] }}')" class="autocomplete-item">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <div>
                                                <span class="badge bg-primary me-2">{{ $student['student_id'] }}</span>
                                                <strong>{{ $student['name'] }}</strong>
                                            </div>
                                            <i class="fas fa-plus-circle text-success"></i>
                                        </div>
                                        <small class="text-muted">
                                            <i class="fas fa-graduation-cap me-1"></i>{{ $student['classroom'] }}
                                            <span class="mx-2">|</span>
                                            <i class="fas fa-phone me-1"></i>{{ $student['phone_number'] }}
                                        </small>
                                    </div>
                                    @endforeach
                                </div>
                                @endif

                                <small class="text-muted mt-1 d-block">
                                    <i class="fas fa-info-circle me-1"></i>Digite e selecione da lista ou pressione Enter para código exato
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Card de Estudantes Cadastrados Hoje -->
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-success text-white py-3 d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="fas fa-user-plus me-2"></i>Cadastrados Hoje ({{ count($todayStudents) }})
                            </h5>
                            @if(count($todayStudents) > 0)
                            <button wire:click="addAllTodayStudents" class="btn btn-sm btn-light">
                                <i class="fas fa-check-double me-1"></i>Adicionar Todos
                            </button>
                            @endif
                        </div>
                        <div class="card-body p-0">
                            @if(count($todayStudents) > 0)
                            <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                                <table class="table table-hover table-sm mb-0">
                                    <thead class="table-light sticky-top">
                                        <tr>
                                            <th>Código</th>
                                            <th>Nome</th>
                                            <th>Turma</th>
                                            <th>Hora</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($todayStudents as $student)
                                        <tr>
                                            <td><small>{{ $student['student_id'] }}</small></td>
                                            <td><small>{{ Str::limit($student['name'], 20) }}</small></td>
                                            <td><small>{{ $student['classroom'] }}</small></td>
                                            <td><small>{{ $student['created_at'] }}</small></td>
                                            <td>
                                                <button wire:click="addStudent('{{ $student['id'] }}')"
                                                        class="btn btn-xs btn-outline-success" title="Adicionar">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-inbox fa-2x mb-2"></i>
                                <p class="mb-0">Nenhum estudante cadastrado hoje</p>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Coluna Direita - Selecionados e Mensagem -->
                <div class="col-lg-7">
                    <!-- Card de Estudantes Selecionados -->
                    <div class="card border-0 shadow-sm mb-3">
                        <div class="card-header bg-info text-white py-3 d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class="fas fa-users me-2"></i>Estudantes Selecionados ({{ count($selectedStudents) }})
                            </h5>
                            @if(count($selectedStudents) > 0)
                            <button wire:click="clearSelected" class="btn btn-sm btn-light">
                                <i class="fas fa-trash me-1"></i>Limpar
                            </button>
                            @endif
                        </div>
                        <div class="card-body p-0">
                            @if(count($selectedStudents) > 0)
                            <div class="table-responsive" style="max-height: 250px; overflow-y: auto;">
                                <table class="table table-hover table-sm mb-0">
                                    <thead class="table-light sticky-top">
                                        <tr>
                                            <th>#</th>
                                            <th>Código</th>
                                            <th>Nome</th>
                                            <th>Telefone</th>
                                            <th>Turma</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($selectedStudents as $index => $student)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td><small>{{ $student['student_id'] }}</small></td>
                                            <td><small>{{ Str::limit($student['name'], 25) }}</small></td>
                                            <td><small>{{ $student['phone_number'] }}</small></td>
                                            <td><small>{{ $student['classroom'] }}</small></td>
                                            <td>
                                                <button wire:click="removeStudent({{ $index }})"
                                                        class="btn btn-xs btn-outline-danger" title="Remover">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="text-center py-4 text-muted">
                                <i class="fas fa-user-slash fa-2x mb-2"></i>
                                <p class="mb-0">Nenhum estudante selecionado</p>
                                <small>Pesquise ou adicione estudantes cadastrados hoje</small>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- Card de Mensagem -->
                    <div class="card border-0 shadow-sm">
                        <div class="card-header bg-warning py-3">
                            <h5 class="mb-0">
                                <i class="fas fa-sms me-2"></i>Mensagem SMS
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Mensagem</label>
                                <textarea wire:model="message"
                                          class="form-control @error('message') is-invalid @enderror"
                                          rows="4"
                                          placeholder="Digite a mensagem a enviar..."></textarea>
                                @error('message')
                                <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                                <small class="text-muted">
                                    Caracteres: {{ strlen($message) }}/500 |
                                    Use: <code>{nome}</code> <code>{codigo}</code> <code>{turma}</code> para personalizar
                                </small>
                            </div>

                            <div class="alert alert-info py-2">
                                <small>
                                    <i class="fas fa-info-circle me-1"></i>
                                    <strong>Variáveis disponíveis:</strong><br>
                                    <code>{nome}</code> - Nome do estudante<br>
                                    <code>{codigo}</code> - Código do estudante<br>
                                    <code>{turma}</code> - Turma do estudante
                                </small>
                            </div>

                            <!-- Destinatário -->
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Enviar para</label>
                                <div class="btn-group w-100" role="group">
                                    <input type="radio" class="btn-check" wire:model="sendTarget" value="both" id="target-both" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="target-both">
                                        <i class="fas fa-users me-1"></i>Ambos
                                    </label>

                                    <input type="radio" class="btn-check" wire:model="sendTarget" value="students" id="target-students" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="target-students">
                                        <i class="fas fa-user-graduate me-1"></i>Só Estudantes
                                    </label>

                                    <input type="radio" class="btn-check" wire:model="sendTarget" value="guardians" id="target-guardians" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="target-guardians">
                                        <i class="fas fa-user-friends me-1"></i>Só Encarregados
                                    </label>
                                </div>
                            </div>

                            <div class="d-grid">
                                <button wire:click="sendSms"
                                        class="btn btn-lg btn-success"
                                        wire:loading.attr="disabled"
                                        @if(count($selectedStudents) == 0) disabled @endif>
                                    <span wire:loading.remove wire:target="sendSms">
                                        <i class="fas fa-paper-plane me-2"></i>
                                        Enviar SMS
                                        @if($sendTarget === 'both')
                                            para {{ count($selectedStudents) }} Estudante(s) + Encarregados
                                        @elseif($sendTarget === 'students')
                                            para {{ count($selectedStudents) }} Estudante(s)
                                        @else
                                            para Encarregados de {{ count($selectedStudents) }} Estudante(s)
                                        @endif
                                    </span>
                                    <span wire:loading wire:target="sendSms">
                                        <span class="spinner-border spinner-border-sm me-2"></span>
                                        Enviando...
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .btn-xs {
            padding: 0.15rem 0.4rem;
            font-size: 0.75rem;
        }
        .sticky-top {
            position: sticky;
            top: 0;
            z-index: 1;
        }
        .autocomplete-dropdown {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: white;
            border: 1px solid #dee2e6;
            border-top: none;
            border-radius: 0 0 8px 8px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            z-index: 1050;
            max-height: 300px;
            overflow-y: auto;
        }
        .autocomplete-item {
            padding: 10px 15px;
            cursor: pointer;
            border-bottom: 1px solid #f0f0f0;
            transition: background-color 0.15s;
        }
        .autocomplete-item:hover {
            background-color: #e8f4ff;
        }
        .autocomplete-item:last-child {
            border-bottom: none;
            border-radius: 0 0 8px 8px;
        }
        .autocomplete-item .badge {
            font-size: 0.85em;
        }
    </style>
</div>
