<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="card border-0 shadow">
                <div class="card-header bg-primary text-white py-3 d-flex justify-content-between align-items-center">
                    <h2 class="h5 mb-0">
                        <i class="fas fa-user-graduate me-2"></i>
                        Adicionar Estudante
                    </h2>
                    <a href="{{ route('admin.list.students') }}" class="btn btn-sm btn-light">
                        <i class="fas fa-list me-1"></i>Ver Todos os Estudantes
                    </a>
                </div>

                <div class="card-body">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <form wire:submit.prevent="submit" class="needs-validation" novalidate>
                                <div class="row g-3">
                                    <!-- Nome Completo -->
                                    <div class="col-md-6">
                                        <label for="name" class="form-label fw-semibold">Nome Completo <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user"></i></span>
                                            <input type="text"
                                                   id="name"
                                                   wire:model="name"
                                                   class="form-control @error('name') is-invalid @enderror"
                                                   placeholder="Ex: João Silva"
                                                   required>
                                        </div>
                                        @error('name') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Número Celular -->
                                    <div class="col-md-6">
                                        <label for="phone_number" class="form-label fw-semibold">Número Celular <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-phone"></i></span>
                                            <input type="text"
                                                   id="phone_number"
                                                   wire:model="phone_number"
                                                   class="form-control @error('phone_number') is-invalid @enderror"
                                                   placeholder="Ex: 849281234"
                                                   required>
                                        </div>
                                        @error('phone_number') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Email -->
                                    <div class="col-md-6">
                                        <label for="email" class="form-label fw-semibold">Email <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-envelope"></i></span>
                                            <input type="email"
                                                   id="email"
                                                   wire:model="email"
                                                   class="form-control @error('email') is-invalid @enderror"
                                                   placeholder="Ex: joao@exemplo.com"
                                                   required>
                                        </div>
                                        @error('email') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- ID do Estudante -->
                                    <div class="col-md-6">
                                        <label for="student_id" class="form-label fw-semibold">ID do Estudante <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-id-card"></i></span>
                                            <input type="text"
                                                   id="student_id"
                                                   wire:model="student_id"
                                                   class="form-control @error('student_id') is-invalid @enderror"
                                                   placeholder="Ex: CPME1001"
                                                   {{ $auto_generate_id ? 'readonly' : '' }}
                                                   style="{{ $auto_generate_id ? 'background: #e8f5e9; font-weight: 600; color: #1a5276;' : '' }}"
                                                   required>
                                        </div>
                                        <div class="form-check form-switch mt-1">
                                            <input class="form-check-input" type="checkbox" id="auto_gen_toggle" wire:model="auto_generate_id">
                                            <label class="form-check-label small text-muted" for="auto_gen_toggle">Gerar automaticamente</label>
                                        </div>
                                        @error('student_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Sexo -->
                                    <div class="col-md-6">
                                        <label for="sex" class="form-label fw-semibold">Sexo <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-venus-mars"></i></span>
                                            <select id="sex"
                                                    wire:model="sex"
                                                    class="form-select @error('sex') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione o sexo...</option>
                                                <option value="Masculino">Masculino</option>
                                                <option value="Feminino">Feminino</option>
                                            </select>
                                        </div>
                                        @error('sex') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Data de Nascimento -->
                                    <div class="col-md-6">
                                        <label for="dob" class="form-label fw-semibold">Data de Nascimento <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-calendar"></i></span>
                                            <input type="date"
                                                   id="dob"
                                                   wire:model="dob"
                                                   class="form-control @error('dob') is-invalid @enderror"
                                                   required>
                                        </div>
                                        @error('dob') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Classe -->
                                    <div class="col-md-6">
                                        <label for="class" class="form-label fw-semibold">Classe <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-layer-group"></i></span>
                                            <select id="class"
                                                    wire:model="class"
                                                    class="form-select @error('class') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a classe...</option>
                                                @for($i = 1; $i <= 12; $i++)
                                                    <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                                @endfor
                                            </select>
                                        </div>
                                        @error('class') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Turma -->
                                    <div class="col-md-6">
                                        <label for="classroom_id" class="form-label fw-semibold">Turma <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-door-open"></i></span>
                                            <select id="classroom_id"
                                                    wire:model="classroom_id"
                                                    class="form-select @error('classroom_id') is-invalid @enderror"
                                                    required>
                                                <option value="">Selecione a turma...</option>
                                                @foreach($classes as $class)
                                                    <option value="{{ $class->id }}">{{ $class->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                        @error('classroom_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Ano de Ingresso -->
                                    <div class="col-md-6">
                                        <label for="year_edu" class="form-label fw-semibold">Ano de Ingresso <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-calendar-alt"></i></span>
                                            <select id="year_edu"
                                                    wire:model="year_edu"
                                                    class="form-select @error('year_edu') is-invalid @enderror"
                                                    required>
                                                @for($year = date('Y'); $year <= date('Y') + 5; $year++)
                                                    <option value="{{ $year }}">{{ $year }}</option>
                                                @endfor
                                            </select>
                                        </div>
                                        <small class="text-muted">Ano letivo em que o estudante ingressou na escola</small>
                                        @error('year_edu') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Separador para dados de filiação -->
                                    <div class="col-12 mt-4">
                                        <h5 class="text-primary border-bottom pb-2">
                                            <i class="fas fa-users me-2"></i>Dados de Filiação e Naturalidade
                                        </h5>
                                    </div>

                                    <!-- Nome do Pai -->
                                    <div class="col-md-6">
                                        <label for="father_name" class="form-label fw-semibold">Nome do Pai</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-male"></i></span>
                                            <input type="text"
                                                   id="father_name"
                                                   wire:model="father_name"
                                                   class="form-control @error('father_name') is-invalid @enderror"
                                                   placeholder="Ex: José Silva">
                                        </div>
                                        @error('father_name') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Nome da Mãe -->
                                    <div class="col-md-6">
                                        <label for="mother_name" class="form-label fw-semibold">Nome da Mãe</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-female"></i></span>
                                            <input type="text"
                                                   id="mother_name"
                                                   wire:model="mother_name"
                                                   class="form-control @error('mother_name') is-invalid @enderror"
                                                   placeholder="Ex: Maria Silva">
                                        </div>
                                        @error('mother_name') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Local de Nascimento -->
                                    <div class="col-md-4">
                                        <label for="birth_place" class="form-label fw-semibold">Local de Nascimento</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-map-marker-alt"></i></span>
                                            <input type="text"
                                                   id="birth_place"
                                                   wire:model="birth_place"
                                                   class="form-control @error('birth_place') is-invalid @enderror"
                                                   placeholder="Ex: Nampula">
                                        </div>
                                        @error('birth_place') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Distrito de Nascimento -->
                                    <div class="col-md-4">
                                        <label for="birth_district" class="form-label fw-semibold">Distrito de Nascimento</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-map"></i></span>
                                            <input type="text"
                                                   id="birth_district"
                                                   wire:model="birth_district"
                                                   class="form-control @error('birth_district') is-invalid @enderror"
                                                   placeholder="Ex: Nampula">
                                        </div>
                                        @error('birth_district') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Província de Nascimento -->
                                    <div class="col-md-4">
                                        <label for="birth_province" class="form-label fw-semibold">Província de Nascimento</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-globe-africa"></i></span>
                                            <select id="birth_province"
                                                    wire:model="birth_province"
                                                    class="form-select @error('birth_province') is-invalid @enderror">
                                                <option value="">Selecione...</option>
                                                <option value="Cabo Delgado">Cabo Delgado</option>
                                                <option value="Gaza">Gaza</option>
                                                <option value="Inhambane">Inhambane</option>
                                                <option value="Manica">Manica</option>
                                                <option value="Maputo">Maputo</option>
                                                <option value="Maputo Cidade">Maputo Cidade</option>
                                                <option value="Nampula">Nampula</option>
                                                <option value="Niassa">Niassa</option>
                                                <option value="Sofala">Sofala</option>
                                                <option value="Tete">Tete</option>
                                                <option value="Zambezia">Zambézia</option>
                                            </select>
                                        </div>
                                        @error('birth_province') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Separador para Encarregado -->
                                    <div class="col-12 mt-4">
                                        <h5 class="text-primary border-bottom pb-2">
                                            <i class="fas fa-user-friends me-2"></i>Encarregado de Educação
                                        </h5>
                                        <small class="text-muted">Ao preencher, será criada automaticamente uma conta no Portal do Encarregado.</small>
                                    </div>

                                    <!-- Nome do Encarregado -->
                                    <div class="col-md-4">
                                        <label for="guardian_name" class="form-label fw-semibold">Nome do Encarregado</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-user-tie"></i></span>
                                            <input type="text"
                                                   id="guardian_name"
                                                   wire:model="guardian_name"
                                                   class="form-control @error('guardian_name') is-invalid @enderror"
                                                   placeholder="Ex: José Silva">
                                        </div>
                                        @error('guardian_name') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Telefone do Encarregado -->
                                    <div class="col-md-4">
                                        <label for="guardian_phone" class="form-label fw-semibold">Telefone do Encarregado</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-phone"></i></span>
                                            <input type="text"
                                                   id="guardian_phone"
                                                   wire:model="guardian_phone"
                                                   class="form-control @error('guardian_phone') is-invalid @enderror"
                                                   placeholder="Ex: 841234567">
                                        </div>
                                        @error('guardian_phone') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Parentesco -->
                                    <div class="col-md-4">
                                        <label for="guardian_relationship" class="form-label fw-semibold">Parentesco</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-heart"></i></span>
                                            <select id="guardian_relationship"
                                                    wire:model="guardian_relationship"
                                                    class="form-select @error('guardian_relationship') is-invalid @enderror">
                                                <option value="encarregado">Encarregado</option>
                                                <option value="pai">Pai</option>
                                                <option value="mae">Mãe</option>
                                                <option value="outro">Outro</option>
                                            </select>
                                        </div>
                                        @error('guardian_relationship') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Separador para documentação -->
                                    <div class="col-12 mt-4">
                                        <h5 class="text-primary border-bottom pb-2">
                                            <i class="fas fa-id-card me-2"></i>Documentação e Foto
                                        </h5>
                                    </div>

                                    <!-- Upload de BI Opcional para Preenchimento Automático -->
                                    <div class="col-12">
                                        <div class="alert alert-info border-0 shadow-sm">
                                            <div class="d-flex align-items-start">
                                                <i class="fas fa-magic fa-2x text-info me-3 mt-1"></i>
                                                <div class="flex-grow-1">
                                                    <h6 class="alert-heading mb-2">
                                                        <strong>Preenchimento Automático (Opcional)</strong>
                                                    </h6>
                                                    <p class="mb-2 small">Carregue uma <strong>foto ou imagem</strong> do Bilhete de Identidade do estudante para preencher automaticamente os campos abaixo. <span class="text-muted">(Apenas JPG, PNG ou GIF)</span></p>

                                                    <div class="mt-3">
                                                        <label for="bi_document" class="form-label fw-semibold small">
                                                            <i class="fas fa-upload me-1"></i>Carregar BI
                                                        </label>
                                                        <input type="file"
                                                               id="bi_document"
                                                               wire:model="bi_document"
                                                               class="form-control form-control-sm"
                                                               accept="image/*,.pdf">

                                                        <!-- Loading indicator -->
                                                        <div wire:loading wire:target="bi_document" class="mt-2">
                                                            <div class="d-flex align-items-center text-primary">
                                                                <div class="spinner-border spinner-border-sm me-2" role="status">
                                                                    <span class="visually-hidden">Processando...</span>
                                                                </div>
                                                                <small><strong>Processando BI com OCR, aguarde...</strong></small>
                                                            </div>
                                                        </div>

                                                        @if($bi_processed)
                                                            <div class="alert alert-success mt-2 py-2 mb-0">
                                                                <small>
                                                                    <i class="fas fa-check-circle me-1"></i>
                                                                    <strong>Dados extraídos com sucesso!</strong> Verifique e corrija os campos abaixo se necessário.
                                                                </small>
                                                            </div>
                                                        @endif

                                                        @if($bi_document)
                                                            <div class="mt-2">
                                                                <small class="text-muted">
                                                                    <i class="fas fa-file-image me-1"></i>
                                                                    Arquivo: {{ $bi_document->getClientOriginalName() }}
                                                                </small>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Tipo de Documento -->
                                    <div class="col-md-4">
                                        <label for="document_type" class="form-label fw-semibold">Tipo de Documento</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-file-alt"></i></span>
                                            <select id="document_type"
                                                    wire:model="document_type"
                                                    class="form-select @error('document_type') is-invalid @enderror">
                                                <option value="">Selecione...</option>
                                                <option value="BI">Bilhete de Identidade</option>
                                                <option value="Cedula">Cédula Pessoal</option>
                                                <option value="Passaporte">Passaporte</option>
                                            </select>
                                        </div>
                                        @error('document_type') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Número do Documento -->
                                    <div class="col-md-4">
                                        <label for="document_id" class="form-label fw-semibold">Número do Documento</label>
                                        <div class="input-group">
                                            <span class="input-group-text bg-light"><i class="fas fa-hashtag"></i></span>
                                            <input type="text"
                                                   id="document_id"
                                                   wire:model="document_id"
                                                   class="form-control @error('document_id') is-invalid @enderror"
                                                   placeholder="Ex: 123456789A">
                                        </div>
                                        @error('document_id') <span class="text-danger small">{{ $message }}</span> @enderror
                                    </div>

                                    <!-- Foto do Estudante -->
                                    <div class="col-md-4">
                                        <label for="avatar" class="form-label fw-semibold">Foto do Estudante</label>
                                        <input type="file"
                                               id="avatar"
                                               wire:model="avatar"
                                               class="form-control @error('avatar') is-invalid @enderror"
                                               accept="image/*,.pdf">
                                        @error('avatar') <span class="text-danger small">{{ $message }}</span> @enderror
                                        <div wire:loading wire:target="avatar" class="text-info small mt-1">
                                            <span class="spinner-border spinner-border-sm"></span> Carregando...
                                        </div>

                                        <!-- Preview da foto extraída do BI -->
                                        @if($extracted_photo_path && !$avatar)
                                            <div class="mt-2">
                                                <div class="alert alert-success py-2 px-3 mb-2">
                                                    <small>
                                                        <i class="fas fa-check-circle me-1"></i>
                                                        <strong>Foto extraída do BI automaticamente</strong>
                                                    </small>
                                                </div>
                                                <img src="{{ asset('storage/' . $extracted_photo_path) }}"
                                                     class="img-thumbnail"
                                                     style="max-height: 150px; border: 2px solid #28a745;">
                                                <small class="d-block text-muted mt-1">
                                                    Pode fazer upload manual para substituir
                                                </small>
                                            </div>
                                        @elseif($avatar)
                                            <div class="mt-2">
                                                <small class="d-block text-success mb-1">
                                                    <i class="fas fa-check me-1"></i>Foto manual (irá substituir a extraída)
                                                </small>
                                                <img src="{{ $avatar->temporaryUrl() }}" class="img-thumbnail" style="max-height: 150px;">
                                            </div>
                                        @endif
                                    </div>
                                </div>

                                <!-- Botões -->
                                <div class="d-grid gap-2 mt-4">
                                    <button type="submit"
                                            class="btn btn-primary btn-lg"
                                            wire:loading.attr="disabled"
                                            wire:offline.attr="disabled">
                                        <span wire:loading.remove wire:target="submit">
                                            <i class="fas fa-save me-2"></i>Guardar Estudante
                                        </span>
                                        <span wire:loading wire:target="submit">
                                            <span class="spinner-border spinner-border-sm me-2"></span>
                                            Processando...
                                        </span>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .form-label.fw-semibold {
            font-weight: 600;
            color: #495057;
        }

        .input-group-text {
            background-color: #f8f9fa;
            border-right: none;
        }

        .input-group .form-control,
        .input-group .form-select {
            border-left: none;
        }

        .input-group .form-control:focus,
        .input-group .form-select:focus {
            border-color: #ced4da;
            box-shadow: none;
        }

        .input-group:focus-within .input-group-text {
            border-color: #80bdff;
        }
    </style>
</div>
    <!-- PDF.js Library for BI Document Upload -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.min.js"></script>
    <script>
        // Configurar PDF.js worker
        if (typeof pdfjsLib !== 'undefined') {
            pdfjsLib.GlobalWorkerOptions.workerSrc = 'https://cdnjs.cloudflare.com/ajax/libs/pdf.js/3.11.174/pdf.worker.min.js';
        }

        let isConvertingPdf = false;

        document.addEventListener('livewire:load', function() {
            const biInput = document.getElementById('bi_document');
            
            if (!biInput) return;

            // Interceptar ANTES do Livewire processar (usando capture)
            biInput.addEventListener('change', async function(e) {
                const file = e.target.files[0];
                if (!file) return;

                // Se é PDF e ainda não estamos convertendo
                if (file.type === 'application/pdf' && !isConvertingPdf) {
                    e.stopImmediatePropagation(); // Impedir Livewire de processar
                    
                    try {
                        isConvertingPdf = true;

                        // Converter PDF para imagem
                        const imageFile = await convertPdfToImage(file);
                        
                        // Substituir o arquivo PDF pelo JPEG no input
                        const dataTransfer = new DataTransfer();
                        dataTransfer.items.add(imageFile);
                        biInput.files = dataTransfer.files;

                        // Disparar evento de mudança novamente (agora com imagem)
                        const newEvent = new Event('change', { bubbles: true });
                        biInput.dispatchEvent(newEvent);
                        
                        isConvertingPdf = false;
                    } catch (error) {
                        console.error('Erro ao converter PDF:', error);
                        alert('Erro ao converter PDF. Por favor, tire uma foto do BI ou use uma imagem (JPG/PNG).');
                        biInput.value = '';
                        isConvertingPdf = false;
                    }
                }
            }, true); // true = capture phase

            async function convertPdfToImage(pdfFile) {
                return new Promise(async (resolve, reject) => {
                    try {
                        // Ler PDF como ArrayBuffer
                        const arrayBuffer = await pdfFile.arrayBuffer();

                        // Carregar PDF
                        const pdf = await pdfjsLib.getDocument({ data: arrayBuffer }).promise;

                        // Pegar primeira página
                        const page = await pdf.getPage(1);

                        // Definir escala para alta resolução (300 DPI equivalente)
                        const scale = 3.0;
                        const viewport = page.getViewport({ scale: scale });

                        // Criar canvas
                        const canvas = document.createElement('canvas');
                        const context = canvas.getContext('2d');
                        canvas.width = viewport.width;
                        canvas.height = viewport.height;

                        // Renderizar PDF no canvas
                        await page.render({
                            canvasContext: context,
                            viewport: viewport
                        }).promise;

                        // Converter canvas para Blob
                        const blob = await new Promise(resolve => {
                            canvas.toBlob(resolve, 'image/jpeg', 0.95);
                        });

                        // Criar File a partir do Blob
                        const fileName = pdfFile.name.replace('.pdf', '.jpg');
                        const imageFile = new File([blob], fileName, { type: 'image/jpeg' });

                        resolve(imageFile);
                    } catch (error) {
                        reject(error);
                    }
                });
            }
        });
    </script>
