<div class="page-content">
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="row mb-4 mt-3">
            <div class="col-12">
                <div class="d-flex justify-content-between align-items-center">
                    <div class="pt-3">
                        <h1 class="h3 mb-1 text-danger">
                            <i class="fas fa-user-times me-2"></i>Lista de Estudantes Irregulares
                        </h1>
                        <p class="text-muted mb-0">
                            Estudantes com pagamento pendente
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h5 class="card-title mb-0 text-primary">
                        <i class="fas fa-filter me-2"></i>Filtros de Pesquisa
                    </h5>
                    <div class="btn-group" role="group">
                        <button type="button" wire:click="exportPDF" class="btn btn-danger btn-sm">
                            <i class="fa fa-file-pdf me-1"></i>PDF
                        </button>
                        <button type="button" wire:click="exportExcel" class="btn btn-success btn-sm">
                            <i class="fa fa-file-excel me-1"></i>Excel
                        </button>
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="selectedClass" class="form-label">Classe</label>
                        <select class="form-select" wire:model="selectedClass" id="selectedClass">
                            <option value="">Todas</option>
                            @foreach($classes as $class)
                                <option value="{{ $class->class }}">{{ $class->class }}ª</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="selectedTurma" class="form-label">Turma</label>
                        <select class="form-select" wire:model="selectedTurma" id="selectedTurma" {{ !$selectedClass ? 'disabled' : '' }}>
                            <option value="">Todas</option>
                            @foreach($turmas as $turma)
                                <option value="{{ $turma->id }}">{{ $turma->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="search" class="form-label">Pesquisar</label>
                        <input
                            type="search"
                            wire:model.debounce.300ms="search"
                            placeholder="Buscar por nome, ID ou email..."
                            class="form-control"
                            id="search"
                        />
                    </div>
                </div>
            </div>
        </div>

        <!-- Table Card -->
        <div class="card border-0 shadow-sm">
            <div class="card-body" wire:init="loadData">
                <div class="table-responsive">
                    @if(count($models))
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th>Nome</th>
                                    <th>ID Estudante</th>
                                    <th>Classe/Turma</th>
                                    <th>Email</th>
                                    <th>Estado</th>
                                    <th class="text-end pe-4" style="width: 200px;">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($models as $model)
                                <tr style="transition: all 0.2s;">
                                    <td><span class="text-muted fw-bold">{{ $loop->iteration }}</span></td>
                                    <td>
                                        <strong class="text-dark">{{ $model->name }}</strong>
                                        <br>
                                        <small class="text-muted">{{ $model->sex }}</small>
                                    </td>
                                    <td>
                                        <span class="text-muted">{{ $model->student_id }}</span>
                                    </td>
                                    <td>
                                        @if($model->class)
                                            <span class="badge bg-primary">{{ $model->class->class }}ª {{ $model->class->name }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $model->email }}</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-danger">Irregular</span>
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button wire:click="submitcomplete('{{ $model->id }}')"
                                                class="btn btn-success btn-sm"
                                                title="Marcar como Pago">
                                                <i class="fa fa-check me-1"></i>Marcar Pago
                                            </button>
                                            <a href="{{ route('admin.edit.student', $model->slug) }}"
                                                class="btn btn-outline-primary btn-sm"
                                                title="Editar">
                                                <span class="fa fa-edit"></span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                        <div class="d-flex justify-content-center mt-3">
                            {{ $models->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <div wire:loading class="spinner-border text-primary mb-3" role="status">
                                <span class="visually-hidden">Processando...</span>
                            </div>
                            <p class="text-muted"><strong>Nenhum estudante irregular foi encontrado.</strong></p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <style>
        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
            transform: translateY(-2px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }

        .form-select:focus, .form-control:focus {
            border-color: #4e73df;
            box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
        }
    </style>
</div>
