<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-gradient-primary text-white py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h2 class="h5 mb-0">
                                <i class="fas fa-chalkboard-teacher me-2"></i>
                                Disciplinas Atribuídas aos Professores
                            </h2>
                            <small class="opacity-75">Gestão de atribuições de disciplinas por professor</small>
                        </div>
                        <a href="{{ route('admin.add.teacher.subject') }}" class="btn btn-light btn-sm shadow-sm">
                            <i class="fas fa-plus me-1"></i> Nova Atribuição
                        </a>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-3 p-3" style="background-color: #e7f3ff;">
                                        <i class="fas fa-users fa-2x" style="color: #0066cc;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Total Atribuições</h6>
                                    <h3 class="mb-0" style="color: #0066cc;">{{ $assignedSubjects->total() }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-3 p-3" style="background-color: #e8f8f5;">
                                        <i class="fas fa-calendar-check fa-2x" style="color: #00a65a;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Ano Selecionado</h6>
                                    <h3 class="mb-0" style="color: #00a65a;">{{ $filterYear ?: 'Todos' }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-3 p-3" style="background-color: #fff4e5;">
                                        <i class="fas fa-book-open fa-2x" style="color: #ff9800;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Disciplinas</h6>
                                    <h3 class="mb-0" style="color: #ff9800;">{{ $assignedSubjects->count() }}</h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="flex-shrink-0">
                                    <div class="rounded-3 p-3" style="background-color: #f3e5f5;">
                                        <i class="fas fa-filter fa-2x" style="color: #9c27b0;"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="text-muted mb-1 small">Filtros Ativos</h6>
                                    <h3 class="mb-0" style="color: #9c27b0;">
                                        {{ collect([$searchProfessor, $searchSubject, $searchClass, $filterYear])->filter()->count() }}
                                    </h3>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-bottom">
                    <h6 class="mb-0 fw-semibold">
                        <i class="fas fa-sliders-h me-2 text-primary"></i>Filtros de Pesquisa
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label fw-semibold small text-muted">
                                <i class="fas fa-calendar-alt me-1"></i> Ano Lectivo
                            </label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="fas fa-calendar-alt text-primary"></i>
                                </span>
                                <select class="form-select border-start-0" wire:model="filterYear">
                                    <option value="">Todos os anos</option>
                                    @foreach($availableYears as $year)
                                        <option value="{{ $year }}">{{ $year }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label fw-semibold small text-muted">
                                <i class="fas fa-user-tie me-1"></i> Professor
                            </label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="fas fa-user-tie text-success"></i>
                                </span>
                                <input
                                    type="text"
                                    class="form-control border-start-0"
                                    placeholder="Nome do professor..."
                                    wire:model.debounce.500ms="searchProfessor"
                                >
                                <span class="input-group-text bg-white border-start-0" wire:loading wire:target="searchProfessor">
                                    <span class="spinner-border spinner-border-sm text-success"></span>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label fw-semibold small text-muted">
                                <i class="fas fa-book me-1"></i> Disciplina
                            </label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="fas fa-book text-info"></i>
                                </span>
                                <input
                                    type="text"
                                    class="form-control border-start-0"
                                    placeholder="Nome da disciplina..."
                                    wire:model.debounce.500ms="searchSubject"
                                >
                                <span class="input-group-text bg-white border-start-0" wire:loading wire:target="searchSubject">
                                    <span class="spinner-border spinner-border-sm text-info"></span>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label fw-semibold small text-muted">
                                <i class="fas fa-graduation-cap me-1"></i> Classe
                            </label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="fas fa-graduation-cap text-warning"></i>
                                </span>
                                <select class="form-select border-start-0" wire:model="searchClass">
                                    <option value="">Todas as classes</option>
                                    @for ($i = 1; $i <= 12; $i++)
                                        <option value="{{ $i }}">{{ $i }}ª Classe</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                    </div>

                    @if($searchProfessor || $searchSubject || $searchClass || $filterYear)
                    <div class="mt-3 pt-3 border-top">
                        <button wire:click="$set('searchProfessor', '')" class="btn btn-sm btn-outline-secondary me-2">
                            <i class="fas fa-times me-1"></i> Limpar Filtros
                        </button>
                        <button wire:click="$refresh" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-sync-alt me-1"></i> Atualizar
                        </button>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Alerts -->
            @if (session()->has('success'))
                <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <strong>Sucesso!</strong> {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <strong>Erro!</strong> {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <!-- Results Counter -->
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="text-muted small">
                    <i class="fas fa-info-circle me-1"></i>
                    Mostrando <strong>{{ $assignedSubjects->count() }}</strong> de <strong>{{ $assignedSubjects->total() }}</strong> atribuições
                </div>
                <div wire:loading class="text-primary small">
                    <span class="spinner-border spinner-border-sm me-1"></span>
                    Carregando...
                </div>
            </div>

            <!-- Table Card -->
            <div class="card border-0 shadow-sm">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="border-0 px-4" style="width: 100px;">
                                        <i class="fas fa-calendar text-primary me-1"></i> Ano
                                    </th>
                                    <th class="border-0">
                                        <i class="fas fa-user-tie text-success me-1"></i> Professor
                                    </th>
                                    <th class="border-0" style="width: 120px;">
                                        <i class="fas fa-layer-group text-info me-1"></i> Classe
                                    </th>
                                    <th class="border-0" style="width: 130px;">
                                        <i class="fas fa-door-open text-warning me-1"></i> Turma
                                    </th>
                                    <th class="border-0">
                                        <i class="fas fa-book text-secondary me-1"></i> Disciplina
                                    </th>
                                    <th class="border-0 text-center" style="width: 130px;">
                                        <i class="fas fa-cog me-1"></i> Ações
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($assignedSubjects as $assignment)
                                    <tr class="border-bottom" style="transition: all 0.2s;">
                                        <td class="px-4">
                                            <span class="badge bg-primary px-3 py-2 rounded-pill">
                                                <i class="fas fa-calendar-day me-1"></i>{{ $assignment->year ?? '-' }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar-circle bg-success bg-opacity-10 text-success rounded-circle d-flex align-items-center justify-content-center me-2" style="width: 35px; height: 35px;">
                                                    <i class="fas fa-user-tie"></i>
                                                </div>
                                                <div>
                                                    <strong class="text-dark d-block">{{ data_get($assignment, 'teacher.name', '-') }}</strong>
                                                    <small class="text-muted">{{ data_get($assignment, 'teacher.email', '') }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @php
                                                $class = data_get($assignment, 'class');
                                                $badgeColor = match(true) {
                                                    $class >= 1 && $class <= 4 => 'success',
                                                    $class >= 5 && $class <= 8 => 'info',
                                                    $class >= 9 && $class <= 12 => 'warning',
                                                    default => 'secondary'
                                                };
                                            @endphp
                                            <span class="badge bg-{{ $badgeColor }} px-3 py-2">
                                                {{ $class ? $class . 'ª Classe' : '-' }}
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary bg-opacity-75 px-3 py-2">
                                                <i class="fas fa-door-open me-1"></i>{{ data_get($assignment, 'classroom.name', '-') }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <i class="fas fa-book text-muted me-2"></i>
                                                <span class="fw-medium">{{ data_get($assignment, 'subject.name', '-') }}</span>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <button
                                                wire:click="removeAssignment('{{ $assignment->id }}')"
                                                class="btn btn-danger btn-sm rounded-pill px-3"
                                                title="Remover atribuição"
                                                wire:loading.attr="disabled"
                                            >
                                                <i class="fas fa-trash-alt me-1"></i>
                                                <span wire:loading.remove wire:target="removeAssignment('{{ $assignment->id }}')">Remover</span>
                                                <span wire:loading wire:target="removeAssignment('{{ $assignment->id }}')">
                                                    <span class="spinner-border spinner-border-sm"></span>
                                                </span>
                                            </button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-5">
                                            <div class="py-5">
                                                <div class="mb-4">
                                                    <i class="fas fa-folder-open fa-4x text-muted opacity-50"></i>
                                                </div>
                                                <h5 class="text-muted mb-2">Nenhuma atribuição encontrada</h5>
                                                <p class="text-muted mb-4">
                                                    @if($searchProfessor || $searchSubject || $searchClass || $filterYear)
                                                        Não foram encontradas atribuições com os filtros aplicados.
                                                    @else
                                                        Ainda não existem disciplinas atribuídas aos professores.
                                                    @endif
                                                </p>
                                                <a href="{{ route('admin.add.teacher.subject') }}" class="btn btn-primary">
                                                    <i class="fas fa-plus me-2"></i>Criar Nova Atribuição
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($assignedSubjects->hasPages())
                        <div class="d-flex justify-content-center p-4 border-top bg-light">
                            {{ $assignedSubjects->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.table-hover tbody tr:hover {
    background-color: rgba(102, 126, 234, 0.05);
    transform: translateX(2px);
}

.avatar-circle {
    font-size: 14px;
}

.badge {
    font-weight: 500;
    letter-spacing: 0.3px;
}

.input-group-text {
    transition: all 0.2s;
}

.input-group:focus-within .input-group-text {
    border-color: #667eea;
}

.btn-outline-secondary:hover, .btn-outline-primary:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.card {
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
}
</style>
