<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card" style="border: 1px solid #e2e8f0; border-radius: 8px;">
                        <div class="card-body" style="padding: 1.5rem;">

                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0" style="color: #1e293b; font-weight: 600;">
                                    Presenças
                                    @if($active_student)
                                        <small class="text-muted ms-1" style="font-size: .85rem;">— {{ $active_student->name }}</small>
                                    @endif
                                </h5>
                            </div>

                            @if(!$active_student)
                                <div class="text-center py-4 text-muted">Nenhum estudante seleccionado.</div>
                            @else

                            {{-- Month Navigator --}}
                            <div class="d-flex align-items-center justify-content-center mb-4" style="gap: 16px;">
                                <button class="btn btn-sm btn-outline-secondary" wire:click="previousMonth">
                                    <i class="fas fa-chevron-left"></i>
                                </button>
                                <span style="font-weight: 600; color: #1e293b; font-size: 1.1rem; text-transform: capitalize;">
                                    {{ $monthLabel }}
                                </span>
                                <button class="btn btn-sm btn-outline-secondary" wire:click="nextMonth">
                                    <i class="fas fa-chevron-right"></i>
                                </button>
                            </div>

                            {{-- Summary Cards --}}
                            <div class="row mb-4 g-2">
                                <div class="col-4 col-md-2">
                                    <div style="background:#f0f9ff;border:1px solid #bae6fd;border-radius:8px;padding:12px;text-align:center;">
                                        <div style="font-size:.7rem;color:#0369a1;font-weight:600;text-transform:uppercase;">Total</div>
                                        <div style="font-size:1.5rem;font-weight:700;color:#0284c7;">{{ $summary['total'] }}</div>
                                    </div>
                                </div>
                                <div class="col-4 col-md-2">
                                    <div style="background:#f0fdf4;border:1px solid #bbf7d0;border-radius:8px;padding:12px;text-align:center;">
                                        <div style="font-size:.7rem;color:#15803d;font-weight:600;text-transform:uppercase;">Presente</div>
                                        <div style="font-size:1.5rem;font-weight:700;color:#16a34a;">{{ $summary['present'] }}</div>
                                    </div>
                                </div>
                                <div class="col-4 col-md-2">
                                    <div style="background:#fef2f2;border:1px solid #fecaca;border-radius:8px;padding:12px;text-align:center;">
                                        <div style="font-size:.7rem;color:#b91c1c;font-weight:600;text-transform:uppercase;">Falta</div>
                                        <div style="font-size:1.5rem;font-weight:700;color:#dc2626;">{{ $summary['absent'] }}</div>
                                    </div>
                                </div>
                                <div class="col-4 col-md-2">
                                    <div style="background:#fffbeb;border:1px solid #fde68a;border-radius:8px;padding:12px;text-align:center;">
                                        <div style="font-size:.7rem;color:#a16207;font-weight:600;text-transform:uppercase;">Atraso</div>
                                        <div style="font-size:1.5rem;font-weight:700;color:#d97706;">{{ $summary['late'] }}</div>
                                    </div>
                                </div>
                                <div class="col-4 col-md-2">
                                    <div style="background:#eff6ff;border:1px solid #bfdbfe;border-radius:8px;padding:12px;text-align:center;">
                                        <div style="font-size:.7rem;color:#1d4ed8;font-weight:600;text-transform:uppercase;">Justif.</div>
                                        <div style="font-size:1.5rem;font-weight:700;color:#2563eb;">{{ $summary['justified'] }}</div>
                                    </div>
                                </div>
                                <div class="col-4 col-md-2">
                                    @php $rate = $summary['rate']; @endphp
                                    <div style="background:{{ $rate >= 75 ? '#f0fdf4' : ($rate >= 50 ? '#fffbeb' : '#fef2f2') }};border:1px solid {{ $rate >= 75 ? '#bbf7d0' : ($rate >= 50 ? '#fde68a' : '#fecaca') }};border-radius:8px;padding:12px;text-align:center;">
                                        <div style="font-size:.7rem;color:#475569;font-weight:600;text-transform:uppercase;">Taxa</div>
                                        <div style="font-size:1.5rem;font-weight:700;color:{{ $rate >= 75 ? '#16a34a' : ($rate >= 50 ? '#d97706' : '#dc2626') }};">{{ $rate }}%</div>
                                    </div>
                                </div>
                            </div>

                            {{-- Calendar Grid --}}
                            @if(count($calendarData) > 0)
                            <div class="mb-3 mx-auto" style="max-width: 320px; border: 1px solid #e2e8f0; border-radius: 8px; overflow: hidden;">
                                <div class="d-flex" style="background: #f8fafc;">
                                    @foreach(['S','T','Q','Q','S','S','D'] as $dh)
                                        <div style="flex:1;text-align:center;padding:4px 0;font-size:.65rem;font-weight:600;color:#64748b;">{{ $dh }}</div>
                                    @endforeach
                                </div>
                                <div class="d-flex flex-wrap">
                                    @foreach($calendarData as $cd)
                                        <div style="width:14.28%;padding:6px 0;display:flex;align-items:center;justify-content:center;
                                                    border:1px solid #f1f5f9;
                                                    {{ !$cd['is_current_month'] ? 'opacity:.3;' : '' }}
                                                    {{ $cd['is_today'] ? 'font-weight:700;box-shadow:inset 0 0 0 2px #058fd0;' : '' }}
                                                    {{ $cd['status'] === 'present'   ? 'background:#dcfce7;color:#15803d;' : '' }}
                                                    {{ $cd['status'] === 'absent'    ? 'background:#fee2e2;color:#b91c1c;' : '' }}
                                                    {{ $cd['status'] === 'late'      ? 'background:#fef3c7;color:#a16207;' : '' }}
                                                    {{ $cd['status'] === 'justified' ? 'background:#dbeafe;color:#1d4ed8;' : '' }}">
                                            <span style="font-size:.7rem;">{{ $cd['day'] }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            {{-- Legend --}}
                            <div class="d-flex flex-wrap justify-content-center mb-3" style="gap:8px;font-size:.65rem;">
                                <span><span style="display:inline-block;width:8px;height:8px;background:#dcfce7;border:1px solid #bbf7d0;border-radius:2px;margin-right:3px;"></span>Presente</span>
                                <span><span style="display:inline-block;width:8px;height:8px;background:#fee2e2;border:1px solid #fecaca;border-radius:2px;margin-right:3px;"></span>Falta</span>
                                <span><span style="display:inline-block;width:8px;height:8px;background:#fef3c7;border:1px solid #fde68a;border-radius:2px;margin-right:3px;"></span>Atraso</span>
                                <span><span style="display:inline-block;width:8px;height:8px;background:#dbeafe;border:1px solid #bfdbfe;border-radius:2px;margin-right:3px;"></span>Justif.</span>
                            </div>
                            @endif

                            {{-- Records grouped by day --}}
                            @php
                                $grouped = $attendances->groupBy(fn($a) => \Carbon\Carbon::parse($a->date)->format('Y-m-d'));
                                $borderColor = ['present'=>'#16a34a','absent'=>'#dc2626','late'=>'#d97706','justified'=>'#2563eb'];
                            @endphp

                            @if($grouped->isEmpty())
                                <div class="text-center py-4">
                                    <i class="fas fa-calendar-check" style="font-size: 3rem; color: #cbd5e1;"></i>
                                    <p class="mt-2 text-muted">Sem registos para {{ $monthLabel }}</p>
                                </div>
                            @else
                                @foreach($grouped as $date => $dayRecords)
                                    @php
                                        $statuses = $dayRecords->pluck('status');
                                        $dominant = $statuses->contains('absent') ? 'absent'
                                            : ($statuses->contains('late') ? 'late'
                                            : ($statuses->contains('justified') ? 'justified' : 'present'));
                                        $bc = $borderColor[$dominant] ?? '#cbd5e1';
                                    @endphp
                                    <div class="card mb-2" style="border: 1px solid #e2e8f0; border-radius: 8px; border-left: 4px solid {{ $bc }};">
                                        <div class="card-body p-3">
                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                <div>
                                                    <span style="font-weight: 600; color: #1e293b;">
                                                        {{ \Carbon\Carbon::parse($date)->locale('pt')->isoFormat('dddd') }}
                                                    </span>
                                                    <span class="text-muted ms-2" style="font-size: 0.85rem;">
                                                        {{ \Carbon\Carbon::parse($date)->format('d/m/Y') }}
                                                    </span>
                                                </div>
                                                <span class="badge bg-light text-dark">{{ $dayRecords->count() }} aulas</span>
                                            </div>
                                            <table class="table table-sm mb-0" style="font-size: 0.8rem;">
                                                <tbody>
                                                    @foreach($dayRecords as $r)
                                                        <tr>
                                                            <td style="border: 0; padding: 4px 8px; font-weight: 500;">
                                                                <i class="fas fa-book me-1" style="color: #94a3b8; font-size: 0.7rem;"></i>
                                                                {{ $r->subject ?? 'Geral' }}
                                                            </td>
                                                            <td style="border: 0; padding: 4px 8px;">
                                                                @include('livewire.user.attendance._status-badge', ['status' => $r->status])
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
