<div>
    <div class="page-content">
        <div class="main-wrapper">
            <div class="row">
                <div class="col">
                    <div class="card" style="border: 1px solid #e2e8f0; border-radius: 8px;">
                        <div class="card-body" wire:init="loadData" style="padding: 1.5rem;">

                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <h5 class="card-title mb-0" style="color: #1e293b; font-weight: 600;">Minha Presença</h5>
                                <a href="{{ route('user.attendance.pdf', ['month' => $month, 'year' => $year, 'view' => $viewMode]) }}"
                                   class="btn btn-sm btn-outline-danger" target="_blank">
                                    <i class="fas fa-file-pdf me-1"></i> Baixar Relatório
                                </a>
                            </div>

                            <!-- Tabs -->
                            <ul class="nav nav-pills mb-4" style="gap: 6px;">
                                <li class="nav-item">
                                    <a class="nav-link {{ $viewMode === 'day' ? 'active' : '' }}" href="#"
                                       wire:click.prevent="setViewMode('day')"
                                       style="{{ $viewMode === 'day' ? 'background: #058fd0;' : 'color: #475569;' }}">
                                        <i class="fas fa-calendar-day me-1"></i> Dia
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ $viewMode === 'week' ? 'active' : '' }}" href="#"
                                       wire:click.prevent="setViewMode('week')"
                                       style="{{ $viewMode === 'week' ? 'background: #058fd0;' : 'color: #475569;' }}">
                                        <i class="fas fa-calendar-week me-1"></i> Semana
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ $viewMode === 'month' ? 'active' : '' }}" href="#"
                                       wire:click.prevent="setViewMode('month')"
                                       style="{{ $viewMode === 'month' ? 'background: #058fd0;' : 'color: #475569;' }}">
                                        <i class="fas fa-calendar-alt me-1"></i> Mês
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link {{ $viewMode === 'year' ? 'active' : '' }}" href="#"
                                       wire:click.prevent="setViewMode('year')"
                                       style="{{ $viewMode === 'year' ? 'background: #058fd0;' : 'color: #475569;' }}">
                                        <i class="fas fa-calendar me-1"></i> Ano
                                    </a>
                                </li>
                            </ul>

                            @if(!$readyToLoad)
                                <div class="text-center py-4">
                                    <div class="spinner-border text-primary" role="status"></div>
                                    <p class="mt-2 text-muted">A carregar...</p>
                                </div>
                            @else
                                <!-- Summary Cards -->
                                <div class="row mb-4 g-2">
                                    <div class="col-4 col-md-2">
                                        <div style="background: #f0f9ff; border: 1px solid #bae6fd; border-radius: 8px; padding: 12px; text-align: center;">
                                            <div style="font-size: 0.7rem; color: #0369a1; font-weight: 600; text-transform: uppercase;">Total</div>
                                            <div style="font-size: 1.5rem; font-weight: 700; color: #0284c7;">{{ $summary['total'] }}</div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-md-2">
                                        <div style="background: #f0fdf4; border: 1px solid #bbf7d0; border-radius: 8px; padding: 12px; text-align: center;">
                                            <div style="font-size: 0.7rem; color: #15803d; font-weight: 600; text-transform: uppercase;">Presente</div>
                                            <div style="font-size: 1.5rem; font-weight: 700; color: #16a34a;">{{ $summary['present'] }}</div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-md-2">
                                        <div style="background: #fef2f2; border: 1px solid #fecaca; border-radius: 8px; padding: 12px; text-align: center;">
                                            <div style="font-size: 0.7rem; color: #b91c1c; font-weight: 600; text-transform: uppercase;">Falta</div>
                                            <div style="font-size: 1.5rem; font-weight: 700; color: #dc2626;">{{ $summary['absent'] }}</div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-md-2">
                                        <div style="background: #fffbeb; border: 1px solid #fde68a; border-radius: 8px; padding: 12px; text-align: center;">
                                            <div style="font-size: 0.7rem; color: #a16207; font-weight: 600; text-transform: uppercase;">Atraso</div>
                                            <div style="font-size: 1.5rem; font-weight: 700; color: #d97706;">{{ $summary['late'] }}</div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-md-2">
                                        <div style="background: #eff6ff; border: 1px solid #bfdbfe; border-radius: 8px; padding: 12px; text-align: center;">
                                            <div style="font-size: 0.7rem; color: #1d4ed8; font-weight: 600; text-transform: uppercase;">Justif.</div>
                                            <div style="font-size: 1.5rem; font-weight: 700; color: #2563eb;">{{ $summary['justified'] }}</div>
                                        </div>
                                    </div>
                                    <div class="col-4 col-md-2">
                                        <div style="background: {{ $summary['rate'] >= 75 ? '#f0fdf4' : ($summary['rate'] >= 50 ? '#fffbeb' : '#fef2f2') }}; border: 1px solid {{ $summary['rate'] >= 75 ? '#bbf7d0' : ($summary['rate'] >= 50 ? '#fde68a' : '#fecaca') }}; border-radius: 8px; padding: 12px; text-align: center;">
                                            <div style="font-size: 0.7rem; color: #475569; font-weight: 600; text-transform: uppercase;">Taxa</div>
                                            <div style="font-size: 1.5rem; font-weight: 700; color: {{ $summary['rate'] >= 75 ? '#16a34a' : ($summary['rate'] >= 50 ? '#d97706' : '#dc2626') }};">{{ $summary['rate'] }}%</div>
                                        </div>
                                    </div>
                                </div>

                                {{-- ============ DAY VIEW ============ --}}
                                @if($viewMode === 'day')
                                    <div class="d-flex align-items-center justify-content-center mb-3" style="gap: 12px;">
                                        <input type="date" class="form-control" wire:model="selectedDate"
                                               style="max-width: 200px; border-radius: 6px; border: 1px solid #cbd5e1;">
                                    </div>

                                    @if($records->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-hover mb-0" style="font-size: 0.875rem;">
                                                <thead style="background: #f8fafc;">
                                                    <tr>
                                                        <th style="color: #64748b; font-weight: 600; font-size: 0.75rem; text-transform: uppercase;">Disciplina</th>
                                                        <th style="color: #64748b; font-weight: 600; font-size: 0.75rem; text-transform: uppercase;">Estado</th>
                                                        <th style="color: #64748b; font-weight: 600; font-size: 0.75rem; text-transform: uppercase;">Hora</th>
                                                        <th style="color: #64748b; font-weight: 600; font-size: 0.75rem; text-transform: uppercase;">Observação</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($records as $record)
                                                        <tr>
                                                            <td style="font-weight: 500;">
                                                                <i class="fas fa-book me-1" style="color: #94a3b8;"></i>
                                                                {{ $record->subject ?? 'Geral' }}
                                                            </td>
                                                            <td>@include('livewire.user.attendance._status-badge', ['status' => $record->status])</td>
                                                            <td style="color: #64748b;">{{ $record->created_at->format('H:i') }}</td>
                                                            <td style="color: #64748b;">{{ $record->observation ?? '-' }}</td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="text-center py-4">
                                            <i class="fas fa-calendar-check" style="font-size: 3rem; color: #cbd5e1;"></i>
                                            <p class="mt-2 text-muted">Sem registos para {{ \Carbon\Carbon::parse($selectedDate)->format('d/m/Y') }}</p>
                                        </div>
                                    @endif

                                {{-- ============ WEEK VIEW ============ --}}
                                @elseif($viewMode === 'week')
                                    <div class="d-flex align-items-center justify-content-center mb-3" style="gap: 16px;">
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="previousWeek">
                                            <i class="fas fa-chevron-left"></i>
                                        </button>
                                        <span style="font-weight: 600; color: #1e293b;">
                                            {{ \Carbon\Carbon::parse($week_start)->format('d/m') }} - {{ \Carbon\Carbon::parse($week_start)->addDays(4)->format('d/m/Y') }}
                                        </span>
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="nextWeek">
                                            <i class="fas fa-chevron-right"></i>
                                        </button>
                                    </div>

                                    @foreach($weekDays as $wd)
                                        <div class="card mb-2" style="border: 1px solid #e2e8f0; border-radius: 8px; border-left: 4px solid {{ $wd['status'] === 'present' ? '#16a34a' : ($wd['status'] === 'absent' ? '#dc2626' : ($wd['status'] === 'late' ? '#d97706' : ($wd['status'] === 'justified' ? '#2563eb' : '#cbd5e1'))) }};">
                                            <div class="card-body p-3">
                                                <div class="d-flex justify-content-between align-items-center mb-2">
                                                    <div>
                                                        <span style="font-weight: 600; color: #1e293b;">{{ $wd['day_name'] }}</span>
                                                        <span class="text-muted ms-2" style="font-size: 0.85rem;">{{ $wd['day'] }}/{{ $wd['month'] }}</span>
                                                    </div>
                                                    <span class="badge bg-light text-dark">{{ $wd['records']->count() }} aulas</span>
                                                </div>
                                                @if($wd['records']->count() > 0)
                                                    <table class="table table-sm mb-0" style="font-size: 0.8rem;">
                                                        <tbody>
                                                            @foreach($wd['records'] as $r)
                                                                <tr>
                                                                    <td style="border: 0; padding: 4px 8px;">
                                                                        <i class="fas fa-book me-1" style="color: #94a3b8; font-size: 0.7rem;"></i>
                                                                        {{ $r->subject ?? 'Geral' }}
                                                                    </td>
                                                                    <td style="border: 0; padding: 4px 8px;">@include('livewire.user.attendance._status-badge', ['status' => $r->status])</td>
                                                                    <td style="border: 0; padding: 4px 8px; color: #94a3b8;">{{ $r->created_at->format('H:i') }}</td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                @else
                                                    <p class="mb-0 text-muted" style="font-size: 0.8rem;">Sem registos</p>
                                                @endif
                                            </div>
                                        </div>
                                    @endforeach

                                {{-- ============ MONTH VIEW ============ --}}
                                @elseif($viewMode === 'month')
                                    <!-- Month Navigator -->
                                    <div class="d-flex align-items-center justify-content-center mb-3" style="gap: 16px;">
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="previousMonth">
                                            <i class="fas fa-chevron-left"></i>
                                        </button>
                                        <span style="font-weight: 600; color: #1e293b; font-size: 1.1rem;">
                                            {{ $monthNames[$month - 1] }} {{ $year }}
                                        </span>
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="nextMonth">
                                            <i class="fas fa-chevron-right"></i>
                                        </button>
                                    </div>

                                    <!-- Calendar Grid -->
                                    @if(count($calendarData) > 0)
                                        <div class="mb-3 mx-auto" style="max-width: 320px; border: 1px solid #e2e8f0; border-radius: 8px; overflow: hidden;">
                                            <div class="d-flex" style="background: #f8fafc;">
                                                @foreach(['S','T','Q','Q','S','S','D'] as $dh)
                                                    <div style="flex: 1; text-align: center; padding: 4px 0; font-size: 0.65rem; font-weight: 600; color: #64748b;">{{ $dh }}</div>
                                                @endforeach
                                            </div>
                                            <div class="d-flex flex-wrap">
                                                @foreach($calendarData as $cd)
                                                    <div wire:click="selectDate('{{ $cd['date'] }}')"
                                                         style="width: 14.28%; padding: 6px 0; display: flex; align-items: center; justify-content: center; cursor: pointer;
                                                                border: 1px solid #f1f5f9; border-radius: 0;
                                                                {{ !$cd['is_current_month'] ? 'opacity: 0.3;' : '' }}
                                                                {{ $cd['is_today'] ? 'font-weight: 700; box-shadow: inset 0 0 0 2px #058fd0;' : '' }}
                                                                {{ $cd['status'] === 'present' ? 'background: #dcfce7; color: #15803d;' : '' }}
                                                                {{ $cd['status'] === 'absent' ? 'background: #fee2e2; color: #b91c1c;' : '' }}
                                                                {{ $cd['status'] === 'late' ? 'background: #fef3c7; color: #a16207;' : '' }}
                                                                {{ $cd['status'] === 'justified' ? 'background: #dbeafe; color: #1d4ed8;' : '' }}">
                                                        <span style="font-size: 0.7rem;">{{ $cd['day'] }}</span>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>

                                        <!-- Legend -->
                                        <div class="d-flex flex-wrap justify-content-center mb-3" style="gap: 8px; font-size: 0.65rem;">
                                            <span><span style="display: inline-block; width: 8px; height: 8px; background: #dcfce7; border: 1px solid #bbf7d0; border-radius: 2px; margin-right: 3px;"></span>Presente</span>
                                            <span><span style="display: inline-block; width: 8px; height: 8px; background: #fee2e2; border: 1px solid #fecaca; border-radius: 2px; margin-right: 3px;"></span>Falta</span>
                                            <span><span style="display: inline-block; width: 8px; height: 8px; background: #fef3c7; border: 1px solid #fde68a; border-radius: 2px; margin-right: 3px;"></span>Atraso</span>
                                            <span><span style="display: inline-block; width: 8px; height: 8px; background: #dbeafe; border: 1px solid #bfdbfe; border-radius: 2px; margin-right: 3px;"></span>Justif.</span>
                                        </div>
                                    @endif

                                    <!-- Records grouped by day -->
                                    @php
                                        $grouped = $records->groupBy(function($r) { return $r->date->format('Y-m-d'); });
                                    @endphp

                                    @if($grouped->count() > 0)
                                        @foreach($grouped as $date => $dayRecords)
                                            <div class="card mb-2" style="border: 1px solid #e2e8f0; border-radius: 8px;">
                                                <div class="card-body p-3">
                                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                                        <div>
                                                            <span style="font-weight: 600; color: #1e293b;">
                                                                {{ \Carbon\Carbon::parse($date)->translatedFormat('l') }}
                                                            </span>
                                                            <span class="text-muted ms-2" style="font-size: 0.85rem;">
                                                                {{ \Carbon\Carbon::parse($date)->format('d/m/Y') }}
                                                            </span>
                                                        </div>
                                                        <span class="badge bg-light text-dark">{{ $dayRecords->count() }} aulas</span>
                                                    </div>
                                                    <table class="table table-sm mb-0" style="font-size: 0.8rem;">
                                                        <tbody>
                                                            @foreach($dayRecords as $r)
                                                                <tr>
                                                                    <td style="border: 0; padding: 4px 8px; font-weight: 500;">
                                                                        <i class="fas fa-book me-1" style="color: #94a3b8; font-size: 0.7rem;"></i>
                                                                        {{ $r->subject ?? 'Geral' }}
                                                                    </td>
                                                                    <td style="border: 0; padding: 4px 8px;">@include('livewire.user.attendance._status-badge', ['status' => $r->status])</td>
                                                                    <td style="border: 0; padding: 4px 8px; color: #94a3b8;">{{ $r->created_at->format('H:i') }}</td>
                                                                </tr>
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <div class="text-center py-4">
                                            <i class="fas fa-calendar-check" style="font-size: 3rem; color: #cbd5e1;"></i>
                                            <p class="mt-2 text-muted">Sem registos para {{ $monthNames[$month - 1] }} {{ $year }}</p>
                                        </div>
                                    @endif

                                {{-- ============ YEAR VIEW ============ --}}
                                @elseif($viewMode === 'year')
                                    <div class="d-flex align-items-center justify-content-center mb-3" style="gap: 16px;">
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="previousYear">
                                            <i class="fas fa-chevron-left"></i>
                                        </button>
                                        <span style="font-weight: 600; color: #1e293b; font-size: 1.1rem;">{{ $year }}</span>
                                        <button class="btn btn-sm btn-outline-secondary" wire:click="nextYear">
                                            <i class="fas fa-chevron-right"></i>
                                        </button>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-hover mb-0" style="font-size: 0.85rem;">
                                            <thead style="background: #f8fafc;">
                                                <tr>
                                                    <th style="color: #64748b; font-weight: 600; font-size: 0.75rem;">Mês</th>
                                                    <th class="text-center" style="color: #64748b; font-weight: 600; font-size: 0.75rem;">Total</th>
                                                    <th class="text-center" style="color: #16a34a; font-weight: 600; font-size: 0.75rem;">Presente</th>
                                                    <th class="text-center" style="color: #dc2626; font-weight: 600; font-size: 0.75rem;">Falta</th>
                                                    <th class="text-center" style="color: #d97706; font-weight: 600; font-size: 0.75rem;">Atraso</th>
                                                    <th class="text-center" style="color: #2563eb; font-weight: 600; font-size: 0.75rem;">Justif.</th>
                                                    <th class="text-center" style="color: #64748b; font-weight: 600; font-size: 0.75rem;">Taxa</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($monthsSummary as $ms)
                                                    @if($ms['total'] > 0)
                                                        <tr style="cursor: pointer;" wire:click="$set('month', {{ $ms['month'] }})" wire:click.self="setViewMode('month')">
                                                            <td style="font-weight: 500;">{{ $ms['month_name'] }}</td>
                                                            <td class="text-center">{{ $ms['total'] }}</td>
                                                            <td class="text-center" style="color: #16a34a;">{{ $ms['present'] }}</td>
                                                            <td class="text-center" style="color: #dc2626;">{{ $ms['absent'] }}</td>
                                                            <td class="text-center" style="color: #d97706;">{{ $ms['late'] }}</td>
                                                            <td class="text-center" style="color: #2563eb;">{{ $ms['justified'] }}</td>
                                                            <td class="text-center">
                                                                <span class="badge" style="background: {{ $ms['rate'] >= 75 ? '#dcfce7' : ($ms['rate'] >= 50 ? '#fef3c7' : '#fee2e2') }}; color: {{ $ms['rate'] >= 75 ? '#15803d' : ($ms['rate'] >= 50 ? '#a16207' : '#b91c1c') }};">
                                                                    {{ $ms['rate'] }}%
                                                                </span>
                                                            </td>
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>

                                    @if(collect($monthsSummary)->sum('total') === 0)
                                        <div class="text-center py-4">
                                            <i class="fas fa-calendar-check" style="font-size: 3rem; color: #cbd5e1;"></i>
                                            <p class="mt-2 text-muted">Sem registos para {{ $year }}</p>
                                        </div>
                                    @endif
                                @endif
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
