<div>
    <div class="page-content">
        <div class="main-wrapper">
            <!-- Header Section -->
            <div class="student-header">
                <div class="student-info-card">
                    <div class="student-avatar">
                        {{ substr($student->name, 0, 2) }}
                    </div>
                    <div class="student-details">
                        <h2>{{ $student->name }}</h2>
                        <p>ID do Estudante: {{ $student->student_id }} | {{ $student->classroom->class ?? 'N/A' }} Classe | Turma: {{ $student->classroom->name ?? 'N/A' }}</p>
                    </div>
                </div>
            </div>

            @php
                // Configuration
                $currentYear = now()->year;
                $months = ['January', 'February', 'March', 'April', 'May', 'June',
                          'July', 'August', 'September', 'October', 'November', 'December'];

                // Initialize totals
                $totals = [
                    'expected' => 0,
                    'paid' => 0,
                    'pending' => 0,
                    'overdue' => 0,
                    'fines' => 0,
                    'general' => 0
                ];

                // Check data availability
                $hasFeeStructures = isset($feestructures) && count($feestructures) > 0;
                $actualFee = $fee ?? 0;

                // Build fees lookup table for performance
                $paidFeesLookup = [];
                if (isset($fees) && count($fees) > 0) {
                    foreach ($fees as $paidFee) {
                        $key = $paidFee->month . '_' . $paidFee->year;
                        $paidFeesLookup[$key] = $paidFee;
                    }
                }

                // Calculate totals efficiently
                if ($hasFeeStructures) {
                    foreach ($months as $index => $month) {
                        $monthData = [
                            'amount' => 0,
                            'fine' => 0,
                            'isPaid' => false,
                            'isOverdue' => false
                        ];
                        
                        // Calculate base amount from fee structures
                        foreach ($feestructures as $feeStructure) {
                            $monthsInFeeStructure = explode(',', $feeStructure->months);
                            
                            if (in_array($month, $monthsInFeeStructure)) {
                                $monthData['amount'] += $feeStructure->monthly_fee;
                                
                                // Check if overdue and calculate fines
                                if (!isset($paidFeesLookup[$month . '_' . $currentYear]) && isset($feeStructure->payment_due_day)) {
                                    $paymentDueDate = Carbon\Carbon::createFromDate($currentYear, $index + 1, $feeStructure->payment_due_day);
                                    
                                    if (Carbon\Carbon::now()->gt($paymentDueDate)) {
                                        $monthData['isOverdue'] = true;
                                        
                                        // Calculate fine based on type
                                        if ($feeStructure->palenty_type == 'fixed') {
                                            $monthData['fine'] += $feeStructure->late_penalty_percentage ?? 0;
                                        } elseif ($feeStructure->palenty_type == 'percentage') {
                                            $monthData['fine'] += ($monthData['amount'] * ($feeStructure->late_penalty_percentage ?? 0)) / 100;
                                        }
                                    }
                                }
                            }
                        }
                        
                        // Skip months with no fees
                        if ($monthData['amount'] == 0) continue;
                        
                        // Update totals
                        $totals['expected'] += $monthData['amount'];
                        
                        // Check if paid
                        $feeKey = $month . '_' . $currentYear;
                        if (isset($paidFeesLookup[$feeKey])) {
                            $monthData['isPaid'] = true;
                            $totals['paid'] += $paidFeesLookup[$feeKey]->amount;
                        } else {
                            $totals['pending'] += $monthData['amount'];
                            
                            if ($monthData['isOverdue']) {
                                $totals['overdue'] += $monthData['amount'];
                                $totals['fines'] += $monthData['fine'];
                            }
                        }
                    }
                    
                    $totals['general'] = $totals['expected'] + $totals['fines'];
                    
                } else if ($actualFee > 0) {
                    // Fallback calculation
                    $totals['expected'] = $actualFee * 12;
                    $totals['paid'] = isset($fees) ? $fees->sum('amount') : 0;
                    $totals['pending'] = max(0, $totals['expected'] - $totals['paid']);
                    $totals['general'] = $totals['expected'];
                }

                // Calculate percentage safely
                $paidPercentage = $totals['expected'] > 0 ? round(($totals['paid'] / $totals['expected']) * 100, 1) : 0;
            @endphp

            <!-- Summary Cards -->
            <div class="summary-cards">
                <div class="summary-card">
                    <div class="summary-card-icon card-total">
                        <i class="fas fa-file-invoice-dollar"></i>
                    </div>
                    <h3>Total de Taxas</h3>
                    <div class="amount">{{ number_format($totals['expected'], 2, ',', '.') }} MT</div>
                    <p class="description">Ano letivo {{ $currentYear }}</p>
                </div>
                
                <div class="summary-card">
                    <div class="summary-card-icon card-paid">
                        <i class="fas fa-check-circle"></i>
                    </div>
                    <h3>Já Pago</h3>
                    <div class="amount">{{ number_format($totals['paid'], 2, ',', '.') }} MT</div>
                    <p class="description">{{ $paidPercentage }}% do total</p>
                </div>
                
                <div class="summary-card">
                    <div class="summary-card-icon card-pending">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>Pendente</h3>
                    <div class="amount">{{ number_format($totals['pending'], 2, ',', '.') }} MT</div>
                    <p class="description">A pagar</p>
                </div>
                
                <div class="summary-card">
                    <div class="summary-card-icon card-overdue">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <h3>Em Atraso</h3>
                    <div class="amount">{{ number_format($totals['overdue'], 2, ',', '.') }} MT</div>
                    <p class="description">Com multas</p>
                </div>
            </div>

            <!-- Fee Table Section -->
            <div class="fee-section">
                <div class="section-header">
                    <h2>
                        <i class="fas fa-list"></i>
                        Detalhes das Taxas - {{ $currentYear }}
                    </h2>
                    <div class="fee-filters">
                        <button class="filter-btn active" data-filter="all">Todas</button>
                        <button class="filter-btn" data-filter="pending">Pendentes</button>
                        <button class="filter-btn" data-filter="paid">Pagas</button>
                        <button class="filter-btn" data-filter="overdue">Em Atraso</button>
                    </div>
                </div>

                <div class="fee-table-container">
                    <table class="table table-striped table-hover fee-table">
                        <thead>
                            <tr>
                                <th>Grupo de Taxas</th>
                                <th>Código</th>
                                <th>Vencimento</th>
                                <th>Estado</th>
                                <th>Montante Base</th>
                                <th>Desconto</th>
                                <th>Multa</th>
                                <th>Total a Pagar</th>
                                <th>Pago</th>
                                <th>Saldo</th>
                                <th>Data</th>
                                <th>Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($months as $index => $month)
                                @php
                                    // Initialize month data
                                    $monthData = [
                                        'status' => 'Unpaid',
                                        'baseAmount' => 0,
                                        'totalAmountWithFines' => 0,
                                        'calculatedFine' => 0,
                                        'appliedDiscount' => 0,
                                        'feeNames' => [],
                                        'paymentDueDate' => null,
                                        'paidAmount' => 0,
                                        'paidDate' => null,
                                        'isOverdue' => false,
                                        'dataStatus' => 'pending'
                                    ];

                                    // Process fee structures for this month
                                    foreach ($feestructures as $feeStructure) {
                                        $monthsInFeeStructure = explode(',', $feeStructure->months);

                                        if (in_array($month, $monthsInFeeStructure)) {
                                            $monthData['baseAmount'] += $feeStructure->monthly_fee;
                                            $monthData['feeNames'][] = $feeStructure->fee_name;

                                            // Set payment due date
                                            if (isset($feeStructure->payment_due_day) && !$monthData['paymentDueDate']) {
                                                $monthData['paymentDueDate'] = Carbon\Carbon::createFromDate($currentYear, $index + 1, $feeStructure->payment_due_day);
                                            }

                                            // Calculate fine if overdue
                                            if ($monthData['paymentDueDate'] && now()->gt($monthData['paymentDueDate'])) {
                                                if ($feeStructure->palenty_type == 'fixed') {
                                                    $monthData['calculatedFine'] += $feeStructure->late_penalty_percentage ?? 0;
                                                } elseif ($feeStructure->palenty_type == 'percentage') {
                                                    $monthData['calculatedFine'] += ($monthData['baseAmount'] * ($feeStructure->late_penalty_percentage ?? 0)) / 100;
                                                }
                                            }
                                        }
                                    }

                                    // Skip months with no fees
                                    if ($monthData['baseAmount'] == 0) continue;

                                    // Set total amount
                                    $monthData['totalAmountWithFines'] = $monthData['baseAmount'] + $monthData['calculatedFine'];

                                    // Check if paid using lookup
                                    $feeKey = $month . '_' . $currentYear;
                                    if (isset($paidFeesLookup[$feeKey])) {
                                        $paidFee = $paidFeesLookup[$feeKey];
                                        $monthData['status'] = 'Paid';
                                        $monthData['paidAmount'] = $paidFee->amount;
                                        $monthData['paidDate'] = $paidFee->created_at ?? now();
                                        $monthData['appliedDiscount'] = $paidFee->discount ?? 0;
                                        $monthData['calculatedFine'] = $paidFee->fine ?? 0;
                                        $monthData['totalAmountWithFines'] = $monthData['paidAmount'];
                                    }

                                    // Determine status
                                    $monthData['isOverdue'] = $monthData['paymentDueDate'] && $monthData['status'] != 'Paid' && now()->gt($monthData['paymentDueDate']);
                                    
                                    if ($monthData['status'] == 'Paid') {
                                        $monthData['dataStatus'] = 'paid';
                                    } elseif ($monthData['isOverdue']) {
                                        $monthData['dataStatus'] = 'overdue';
                                    }
                                @endphp

                                <tr class="{{ $monthData['isOverdue'] ? 'table-warning' : '' }}" data-status="{{ $monthData['dataStatus'] }}">
                                    <td data-label="Mes/Ano">{{ $month }} {{ $currentYear }}</td>
                                    <td data-label="Código">{{ implode(', ', $monthData['feeNames']) ?: 'N/A' }}</td>
                                    <td data-label="Vencimento">
                                        {{ $monthData['paymentDueDate'] ? $monthData['paymentDueDate']->format('d/m/Y') : 'N/A' }}
                                    </td>
                                    <td data-label="Estado">
                                        @if($monthData['status'] == 'Unpaid')
                                            @if($monthData['isOverdue'])
                                                <span class="badge bg-warning text-dark">Em Atraso</span>
                                            @else
                                                <span class="badge bg-danger">Não Pago</span>
                                            @endif
                                        @else
                                            <span class="badge bg-success">Pago</span>
                                        @endif
                                    </td>
                                    <td data-label="Montante Base">{{ number_format($monthData['baseAmount'], 2, ',', '.') }} MT</td>
                                    <td data-label="Desconto">
                                        @if($monthData['appliedDiscount'] > 0)
                                            <span class="text-success fw-bold">-{{ number_format($monthData['appliedDiscount'], 2, ',', '.') }} MT</span>
                                        @else
                                            <span class="text-muted">0,00 MT</span>
                                        @endif
                                    </td>
                                    <td data-label="Multa">
                                        <span class="{{ $monthData['calculatedFine'] > 0 ? 'text-danger fw-bold' : 'text-muted' }}">
                                            {{ number_format($monthData['calculatedFine'], 2, ',', '.') }} MT
                                        </span>
                                    </td>
                                    <td data-label="Total a Pagar">
                                        <strong>{{ number_format($monthData['totalAmountWithFines'], 2, ',', '.') }} MT</strong>
                                    </td>
                                    <td data-label="Pago">{{ $monthData['status'] == 'Paid' ? number_format($monthData['paidAmount'], 2, ',', '.') . ' MT' : '0,00 MT' }}</td>
                                    <td data-label="Saldo">{{ $monthData['status'] != 'Paid' ? number_format($monthData['totalAmountWithFines'], 2, ',', '.') . ' MT' : '0,00 MT' }}</td>
                                    <td data-label="Data">
                                        {{ $monthData['status'] == 'Paid' && $monthData['paidDate'] ? $monthData['paidDate']->format('d/m/Y') : 'N/A' }}
                                    </td>
                                    <td data-label="Ação">
                                        @if ($monthData['status'] == 'Unpaid')
                                            <button
                                                onclick="openPaymentModal('{{ $month }}', {{ $currentYear }}, {{ $monthData['baseAmount'] }}, {{ $monthData['calculatedFine'] }}, {{ $monthData['totalAmountWithFines'] }}, '{{ implode(', ', $monthData['feeNames']) }}', {{ $monthData['appliedDiscount'] }})"
                                                class="btn btn-primary btn-sm">
                                                Pagar
                                            </button>
                                        @else
                                            <span class="text-muted">✔ Pago</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="quick-actions">
                <div class="action-btn" onclick="window.print()">
                    <i class="fas fa-file-download"></i>
                    <h4>Baixar Extrato</h4>
                    <p>Exportar histórico completo</p>
                </div>
                
                <div class="action-btn">
                    <i class="fas fa-receipt"></i>
                    <h4>Meus Recibos</h4>
                    <p>Ver pagamentos realizados</p>
                </div>
                
                <div class="action-btn">
                    <i class="fas fa-credit-card"></i>
                    <h4>Pagar Pendentes</h4>
                    <p>Total: {{ number_format($totals['pending'], 2, ',', '.') }} MT</p>
                </div>
                
                <div class="action-btn">
                    <i class="fas fa-question-circle"></i>
                    <h4>Suporte</h4>
                    <p>Falar com financeiro</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Payment Modal -->
    <div class="modal fade" id="collectFeeModal" tabindex="-1" role="dialog" aria-labelledby="collectFeeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <form id="paymentForm" onsubmit="submitPayment(event)">
                    <div class="modal-header bg-primary text-white">
                        <h5 class="modal-title" id="collectFeeModalLabel">
                            <i class="fas fa-credit-card me-2"></i>Efetuar Pagamento
                        </h5>
                        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fechar"></button>
                    </div>
                    
                    <div class="modal-body">
                        <!-- Fee Details Display -->
                        <div class="fee-details-card mb-4">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title text-primary">
                                        <i class="fas fa-info-circle me-2"></i>Detalhes da Taxa
                                    </h6>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <p><strong>Período:</strong> <span id="modalPeriod">-</span></p>
                                            <p><strong>Taxa:</strong> <span id="modalFeeName">-</span></p>
                                        </div>
                                        <div class="col-md-6">
                                            <p><strong>Valor Base:</strong> <span id="modalBaseAmount">0,00 MT</span></p>
                                            <p><strong>Multa Calculada:</strong> <span id="modalCalculatedFine" class="text-danger">0,00 MT</span></p>
                                        </div>
                                    </div>
                                    <hr>
                                    <p class="mb-0"><strong>Total a Pagar:</strong> <span id="modalTotalAmount" class="text-success fs-5">0,00 MT</span></p>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Form -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="amount" class="form-label">
                                        <i class="fas fa-money-bill-wave me-1"></i>Montante a Pagar *
                                    </label>
                                    <div class="input-group">
                                        <input type="number"
                                               class="form-control"
                                               id="amount"
                                               name="amount"
                                               step="0.01"
                                               min="0"
                                               readonly
                                               required>
                                        <span class="input-group-text">MT</span>
                                    </div>
                                    <small class="text-muted">Valor fixo (base + multa aplicável)</small>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="fine" class="form-label">
                                        <i class="fas fa-exclamation-triangle me-1"></i>Multa por Atraso
                                    </label>
                                    <div class="input-group">
                                        <input type="number"
                                               class="form-control"
                                               id="fine"
                                               name="fine"
                                               step="0.01"
                                               min="0"
                                               readonly>
                                        <span class="input-group-text">MT</span>
                                    </div>
                                    <small class="text-muted">Multa calculada automaticamente</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="paymentMode" class="form-label">
                                        <i class="fas fa-credit-card me-1"></i>Modo de Pagamento *
                                    </label>
                                    <select class="form-control" id="paymentMode" name="paymentMode" required>
                                        <option value="">Selecione o método</option>
                                    {{-- <option value="Cash">Dinheiro</option>
                                        <option value="Transfer">Transferência Bancária</option>
                                        <option value="MPesa">M-Pesa</option>
                                        <option value="eMola">e-Mola</option>
                                        <option value="Card">Cartão</option> --}}
                                        
                                        <option value="Reference">Entidade e Referencia</option>
                                        <option value="MPesa">M-Pesa</option>
                                        <option value="eMola">e-Mola</option>
                                            
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="note" class="form-label">
                                        <i class="fas fa-sticky-note me-1"></i>Observações
                                    </label>
                                    <textarea class="form-control"
                                              id="note"
                                              name="note"
                                              rows="3"
                                              placeholder="Observações (opcional)"></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- Hidden fields -->
                        <input type="hidden" id="hiddenMonth" name="month">
                        <input type="hidden" id="hiddenYear" name="year">
                        <input type="hidden" id="hiddenDiscount" name="discount" value="0">

                        <!-- Payment Summary -->
                        <div class="payment-summary mt-3">
                            <div class="card border-success">
                                <div class="card-body bg-light">
                                    <h6 class="text-success mb-3">
                                        <i class="fas fa-calculator me-2"></i>Resumo do Pagamento
                                    </h6>
                                    <div class="row text-center">
                                        <div class="col-4">
                                            <div class="border-end">
                                                <div class="text-muted small">Valor Base</div>
                                                <div class="fw-bold" id="summaryBase">0,00 MT</div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="border-end">
                                                <div class="text-muted small">Multa</div>
                                                <div class="fw-bold text-warning" id="summaryFine">0,00 MT</div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="text-muted small">Total a Pagar</div>
                                            <div class="fw-bold text-success fs-5" id="summaryTotal">0,00 MT</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                            <i class="fas fa-times me-1"></i>Cancelar
                        </button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check me-1"></i>Confirmar Pagamento
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
                                            

<style>
/* Optimized CSS - Combined and minified */
.page-content{background:#f0f2f5;min-height:100vh;padding:20px}
.main-wrapper{max-width:1200px;margin:0 auto}
.student-header{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%);color:#fff;padding:30px;border-radius:20px;margin-bottom:30px;box-shadow:0 10px 30px rgba(0,0,0,.1)}
.student-info-card{display:flex;align-items:center;gap:20px}
.student-avatar{width:80px;height:80px;border-radius:50%;background:#fff;color:#667eea;display:flex;align-items:center;justify-content:center;font-size:32px;font-weight:700;text-transform:uppercase}
.student-details h2{margin:0 0 5px;font-size:28px}
.student-details p{margin:0;opacity:.9}
.summary-cards{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:20px;margin-bottom:30px}
.summary-card{background:#fff;padding:25px;border-radius:15px;box-shadow:0 5px 20px rgba(0,0,0,.08);transition:transform .3s ease}
.summary-card:hover{transform:translateY(-5px)}
.summary-card-icon{width:50px;height:50px;border-radius:12px;display:flex;align-items:center;justify-content:center;font-size:24px;margin-bottom:15px}
.card-total{background:#e3f2fd;color:#1976d2}
.card-paid{background:#e8f5e9;color:#388e3c}
.card-pending{background:#fff3e0;color:#f57c00}
.card-overdue{background:#ffebee;color:#d32f2f}
.summary-card h3{font-size:14px;color:#666;font-weight:500;margin-bottom:5px}
.summary-card .amount{font-size:28px;font-weight:700;color:#333;margin-bottom:5px}
.summary-card .description{font-size:12px;color:#999}
.fee-section{background:#fff;border-radius:15px;padding:25px;box-shadow:0 5px 20px rgba(0,0,0,.08);margin-bottom:30px}
.section-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;padding-bottom:15px;border-bottom:2px solid #f0f2f5}
.section-header h2{font-size:20px;color:#333;margin:0;display:flex;align-items:center;gap:10px}
.fee-filters{display:flex;gap:10px}
.filter-btn{padding:8px 16px;border:1px solid #ddd;border-radius:8px;background:#fff;cursor:pointer;transition:all .3s ease;font-size:14px;-webkit-tap-highlight-color:transparent;touch-action:manipulation;user-select:none;-webkit-user-select:none}
.filter-btn:active{transform:scale(.95);background:#f0f0f0}
.filter-btn.active{background:#667eea;color:#fff;border-color:#667eea}
.fee-table-container{overflow-x:auto}
.fee-table{width:100%;border-collapse:collapse}
.fee-table th{text-align:left;padding:12px;font-size:13px;font-weight:600;color:#666;border-bottom:2px solid #f0f2f5}
.fee-table td{padding:16px 12px;border-bottom:1px solid #f0f2f5}
.fee-table tr:hover{background-color:#f8f9fa}
.quick-actions{display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:15px;margin-top:30px}
.action-btn{background:#fff;border:2px solid #e0e0e0;padding:20px;border-radius:12px;text-align:center;cursor:pointer;transition:all .3s ease}
.action-btn:hover{border-color:#667eea;background:#f8f9ff;transform:translateY(-3px)}
.action-btn i{font-size:32px;color:#667eea;margin-bottom:10px;display:block}
.action-btn h4{font-size:16px;margin-bottom:5px;color:#333}
.action-btn p{font-size:13px;color:#666;margin:0}
.text-muted{color:#999!important;font-size:13px}
.form-control[readonly]{background-color:#f8f9fa;border-color:#dee2e6;color:#6c757d;cursor:not-allowed}
.form-control[readonly]:focus{background-color:#f8f9fa;border-color:#dee2e6;box-shadow:none}
.fee-details-card .card{border:1px solid #e3f2fd}
.payment-summary .card{border:1px solid #c8e6c9}
.modal-header.bg-primary{background:linear-gradient(135deg,#667eea 0%,#764ba2 100%)!important}
.form-label{font-weight:600;color:#495057}
.input-group-text{background-color:#f8f9fa;border-color:#ced4da}
.modal-loading-overlay{position:absolute;top:0;left:0;right:0;bottom:0;background:rgba(255,255,255,.9);display:none;align-items:center;justify-content:center;z-index:9999;flex-direction:column;gap:15px}
.modal-loading-overlay.active{display:flex}
.modal-loading-spinner{width:50px;height:50px;border:4px solid #f3f3f3;border-top:4px solid #667eea;border-radius:50%;animation:spin 1s linear infinite}
@keyframes spin{0%{transform:rotate(0deg)}100%{transform:rotate(360deg)}}

/* Responsive Design */
@media (max-width:992px){
    .page-content{padding:15px 10px}
    .student-header{padding:20px 15px}
    .student-avatar{width:60px;height:60px;font-size:24px}
    .student-details h2{font-size:20px}
    .summary-cards{grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:15px}
    .summary-card{padding:20px}
    .fee-section{padding:20px 15px}
    .section-header{flex-direction:column;align-items:flex-start;gap:15px}
    .fee-filters{width:100%;overflow-x:auto;padding-bottom:5px}
    .filter-btn{flex-shrink:0;padding:6px 12px;font-size:13px;min-width:60px;height:35px;display:inline-flex;align-items:center;justify-content:center}
    .fee-table thead{display:none!important}
    .fee-table tbody tr{display:block!important;margin-bottom:15px;border:1px solid #e9ecef;border-radius:10px;padding:15px;background:#fff;box-shadow:0 2px 10px rgba(0,0,0,.05)}
        .fee-table tbody td{display:flex!important;justify-content:space-between;align-items:center;padding:8px 0;border:none!important;border-bottom:1px solid #f1f3f4!important;white-space:normal;word-break:break-word}
            .fee-table tbody td:last-child{border-bottom:none!important}
            .fee-table tbody td::before{content:attr(data-label);font-weight:600;color:#495057;flex:0 0 35%;margin-right:10px;font-size:.8rem}
                .fee-table tbody td .badge,.fee-table tbody td .btn{margin-left:auto}
                .fee-table tbody tr.filter-hidden{display:none!important;height:0!important;margin:0!important;padding:0!important;border:none!important}
                .quick-actions{grid-template-columns:1fr 1fr;gap:10px}
                .action-btn{padding:15px 10px}
                .modal-dialog{margin:10px;max-width:calc(100% - 20px)}
            }
            @media (max-width:576px){
                .summary-cards{grid-template-columns:1fr}
                .student-info-card{flex-direction:column;text-align:center;gap:15px}
                .fee-table tbody td{flex-direction:column;align-items:flex-start}
                .fee-table tbody td::before{margin-bottom:5px;flex:none}
                .quick-actions{grid-template-columns:1fr}
            }
            </style>

            //V2
            <script>
            (function () {
                'use strict';

                // =========================
                // Config
                // =========================
                const CONFIG = {
                    PAYMENT_TIMEOUT: 5000,
                    ANIMATION_DURATION: 300,
                    VIBRATION_DURATION: 20,
                    CURRENCY_LOCALE: 'pt-MZ',
                    CURRENCY_OPTIONS: { minimumFractionDigits: 2, maximumFractionDigits: 2 }
                };

                // =========================
                // State + DOM Cache
                // =========================
                const state = {
                    currentFeeData: {},
                    isProcessingPayment: false,
                    paymentTimeout: null
                };

                const elements = {};

                function initializeElements() {
                    elements.modal = document.getElementById('collectFeeModal');
                    elements.form = document.getElementById('paymentForm');
                    elements.submitBtn = elements.form?.querySelector('button[type="submit"]');
                    elements.paymentModeSelect = document.getElementById('paymentMode');

                    // Modal display elements
                    const ids = [
                        'modalPeriod','modalFeeName','modalBaseAmount','modalCalculatedFine','modalTotalAmount',
                        'amount','fine','hiddenMonth','hiddenYear','hiddenDiscount','summaryBase','summaryFine','summaryTotal'
                    ];
                    ids.forEach(id => elements[id] = document.getElementById(id));

                    return true;
                }

                // =========================
                // Utils
                // =========================
                const utils = {
                    formatCurrency(amount) {
                        const number = parseFloat(amount) || 0;
                        return new Intl.NumberFormat(CONFIG.CURRENCY_LOCALE, CONFIG.CURRENCY_OPTIONS).format(number) + ' MT';
                    },
                    parseNumber(v) { return parseFloat(v) || 0; },
                };

                // =========================
                // Modal: abrir/preencher
                // =========================
                window.openPaymentModal = function (month, year, baseAmount, calculatedFine, totalAmount, feeName, existingDiscount = 0) {
                    state.currentFeeData = {
                        month,
                        year,
                        baseAmount: utils.parseNumber(baseAmount),
                        calculatedFine: utils.parseNumber(calculatedFine),
                        totalAmount: utils.parseNumber(totalAmount),
                        feeName: feeName || 'Taxa Escolar',
                        existingDiscount: utils.parseNumber(existingDiscount)
                    };

                    state.isProcessingPayment = false;

                    if (typeof $ !== 'undefined') $('#collectFeeModal').modal('show');

                    setTimeout(() => {
                        initializeElements();
                        updateModalDisplay();
                    }, 200);
                };

                function updateModalDisplay() {
                    if (!state.currentFeeData.month) return;

                    if (!elements.modalPeriod) initializeElements();

                    elements.modalPeriod && (elements.modalPeriod.textContent = `${state.currentFeeData.month} ${state.currentFeeData.year}`);
                    elements.modalFeeName && (elements.modalFeeName.textContent = state.currentFeeData.feeName);
                    elements.modalBaseAmount && (elements.modalBaseAmount.textContent = utils.formatCurrency(state.currentFeeData.baseAmount));
                    elements.modalCalculatedFine && (elements.modalCalculatedFine.textContent = utils.formatCurrency(state.currentFeeData.calculatedFine));
                    elements.modalTotalAmount && (elements.modalTotalAmount.textContent = utils.formatCurrency(state.currentFeeData.totalAmount));

                    elements.amount && (elements.amount.value = state.currentFeeData.totalAmount.toFixed(2));
                    elements.fine && (elements.fine.value = state.currentFeeData.calculatedFine.toFixed(2));
                    elements.hiddenMonth && (elements.hiddenMonth.value = state.currentFeeData.month);
                    elements.hiddenYear && (elements.hiddenYear.value = state.currentFeeData.year);
                    elements.hiddenDiscount && (elements.hiddenDiscount.value = 0);

                    updatePaymentSummary();
                }

                function updatePaymentSummary() {
                    if (!state.currentFeeData.month) return;
                    if (!elements.summaryBase) initializeElements();

                    elements.summaryBase && (elements.summaryBase.textContent = utils.formatCurrency(state.currentFeeData.baseAmount));
                    elements.summaryFine && (elements.summaryFine.textContent  = utils.formatCurrency(state.currentFeeData.calculatedFine));
                    elements.summaryTotal && (elements.summaryTotal.textContent = utils.formatCurrency(state.currentFeeData.totalAmount));
                }

                // =========================
                // Loading helpers
                // =========================
                function createLoadingOverlay() {
                    const overlay = document.createElement('div');
                    overlay.className = 'modal-loading-overlay';
                    overlay.innerHTML = `
                        <div class="modal-loading-spinner"></div>
                        <p class="text-muted" data-overlay-text>Processando...</p>
                    `;
                    return overlay;
                }

                function showLoadingState(label = 'Processando...') {
                    if (!elements.submitBtn) elements.submitBtn = document.querySelector('#paymentForm button[type="submit"]');
                    if (elements.submitBtn) {
                        const originalText = elements.submitBtn.innerHTML;
                        elements.submitBtn.innerHTML = `<i class="fas fa-spinner fa-spin me-1"></i>${label}`;
                        elements.submitBtn.disabled = true;
                        elements.submitBtn.dataset.originalText = originalText;
                    }

                    const modalContent = document.querySelector('#collectFeeModal .modal-content');
                    if (modalContent && !modalContent.querySelector('.modal-loading-overlay')) {
                        modalContent.style.position = 'relative';
                        modalContent.appendChild(createLoadingOverlay());
                    }

                    // Atualiza texto do overlay se existir
                    const txt = document.querySelector('.modal-loading-overlay [data-overlay-text]');
                    if (txt) txt.textContent = label;

                    setTimeout(() => {
                        const overlay = document.querySelector('.modal-loading-overlay');
                        if (overlay) overlay.classList.add('active');
                    }, CONFIG.ANIMATION_DURATION);
                }

                function resetPaymentForm() {
                    state.isProcessingPayment = false;

                    if (elements.submitBtn) {
                        elements.submitBtn.innerHTML = elements.submitBtn.dataset.originalText || '<i class="fas fa-check me-1"></i>Confirmar Pagamento';
                        elements.submitBtn.disabled = false;
                    }

                    const overlay = document.querySelector('.modal-loading-overlay');
                    if (overlay) overlay.classList.remove('active');
                }

                function hideModalAndShowSuccess() {
                    state.isProcessingPayment = false;
                    if (state.paymentTimeout) { clearTimeout(state.paymentTimeout); state.paymentTimeout = null; }

                    try {
                        if (typeof $ !== 'undefined' && $.fn.modal) {
                            const $modal = $('#collectFeeModal');
                            if ($modal.length && $modal.hasClass('show')) {
                                $modal.modal('hide');
                                setTimeout(() => {
                                    document.querySelectorAll('.modal-backdrop').forEach(b => b?.parentNode?.removeChild(b));
                                    document.body.classList.remove('modal-open');
                                    document.body.style.removeProperty('padding-right');
                                    document.body.style.removeProperty('overflow');
                                }, 500);
                            }
                        }
                    } catch (e) {
                        document.querySelectorAll('.modal-backdrop').forEach(el => el.remove());
                        document.body.classList.remove('modal-open');
                        document.body.style = '';
                    }

                    setTimeout(() => {
                        if (typeof Swal !== 'undefined') {
                            Swal.fire({
                                icon: 'success',
                                title: 'Pagamento Efetuado!',
                                text: 'O pagamento foi processado com sucesso.',
                                confirmButtonColor: '#28a745',
                                allowOutsideClick: false
                            }).then(() => window.location.reload());
                        } else {
                            alert('Pagamento efetuado com sucesso!');
                            window.location.reload();
                        }
                    }, CONFIG.ANIMATION_DURATION);
                }

                // =========================
                // Submit: fluxo normal vs referência
                // =========================
                window.submitPayment = function (event) {
                    event.preventDefault();
                    if (state.isProcessingPayment) return;

                    state.isProcessingPayment = true;

                    const formData = new FormData(event.target);
                    const paymentData = Object.fromEntries(formData);

                    if (!paymentData.paymentMode) {
                        alert('Por favor, selecione um método de pagamento.');
                        state.isProcessingPayment = false;
                        return;
                    }

                    const isReference = paymentData.paymentMode === 'Reference' || paymentData.paymentMode === 'Entity_Reference';

                    if (isReference) {
                        // Desvio para geração de referência + PDF
                        showLoadingState('Gerando referência...');
                        try {
                            if (typeof Livewire !== 'undefined') {
                                Livewire.emit('generateReference', paymentData);
                            } else {
                                throw new Error('Livewire not available');
                            }
                        } catch (error) {
                            console.error('Reference error:', error);
                            resetPaymentForm();
                        }
                        return;
                    }

                    // Fluxo NORMAL
                    showLoadingState('Processando...');
                    state.paymentTimeout = setTimeout(() => {
                        if (state.isProcessingPayment) hideModalAndShowSuccess();
                    }, CONFIG.PAYMENT_TIMEOUT);

                    try {
                        if (typeof Livewire !== 'undefined') {
                            Livewire.emit('collectPayment', paymentData);
                        } else {
                            throw new Error('Livewire not available');
                        }
                    } catch (error) {
                        console.error('Payment error:', error);
                        resetPaymentForm();
                    }
                };

                // =========================
                // Filtro (lista)
                // =========================
                class FilterSystem {
                    constructor() {
                        this.filterButtons = null;
                        this.tableContainer = null;
                    }
                    init() {
                        setTimeout(() => {
                            this.filterButtons = document.querySelectorAll('.filter-btn');
                            this.tableContainer = document.querySelector('.fee-table-container');
                            if (!this.tableContainer) return;
                            this.setupFilters();
                            this.injectStyles();
                            this.applyFilter('all');
                        }, 50);
                    }
                    setupFilters() {
                        this.filterButtons.forEach(button => {
                            const newButton = button.cloneNode(true);
                            button.parentNode.replaceChild(newButton, button);
                            this.setupButton(newButton);
                        });
                    }
                    setupButton(button) {
                        const handleClick = (e) => {
                            e.preventDefault(); e.stopPropagation();
                            document.querySelectorAll('.filter-btn').forEach(btn => btn.classList.remove('active'));
                            button.classList.add('active');
                            button.classList.add('clicking');
                            if ('vibrate' in navigator) navigator.vibrate(CONFIG.VIBRATION_DURATION);
                            const filterType = button.getAttribute('data-filter');
                            setTimeout(() => { this.applyFilter(filterType); button.classList.remove('clicking'); }, 150);
                            button.blur();
                        };
                        button.addEventListener('click', handleClick);
                        button.addEventListener('touchend', handleClick, { passive: false });

                        button.addEventListener('touchstart', () => button.classList.add('clicking'), { passive: true });
                        button.addEventListener('touchcancel', () => button.classList.remove('clicking'), { passive: true });

                        let lastTap = 0;
                        button.addEventListener('touchstart', (e) => {
                            const now = Date.now(), delta = now - lastTap;
                            if (delta < 500 && delta > 0) e.preventDefault();
                            lastTap = now;
                        }, { passive: false });

                        Object.assign(button.style, {
                            cursor: 'pointer', touchAction: 'manipulation', webkitTapHighlightColor: 'transparent',
                            webkitUserSelect: 'none', userSelect: 'none', transition: 'all 0.2s ease'
                        });

                        button.setAttribute('role', 'button');
                        button.setAttribute('tabindex', '0');
                        button.setAttribute('aria-pressed', 'false');
                        button.addEventListener('keydown', (e) => {
                            if (e.key === 'Enter' || e.key === ' ') { e.preventDefault(); button.click(); }
                        });
                    }
                    applyFilter(filterType) {
                        const tbody = this.tableContainer.querySelector('tbody');
                        const rows = Array.from(tbody.querySelectorAll('tr[data-status]'));
                        let visibleCount = 0;

                        rows.forEach(row => row.classList.remove('filtered-hidden', 'filtered-visible'));

                        rows.forEach(row => {
                            const status = row.getAttribute('data-status');
                            const show = filterType === 'all' || status === filterType;
                            if (show) {
                                row.style.display = ''; row.style.visibility = ''; row.style.opacity = '1';
                                row.style.height = ''; row.style.overflow = ''; row.classList.add('filtered-visible');
                                if (window.innerWidth <= 768) row.querySelectorAll('td').forEach(td => td.style.display = '');
                                visibleCount++;
                            } else {
                                row.style.display = 'none'; row.style.visibility = 'hidden'; row.style.opacity = '0';
                                row.style.height = '0'; row.style.overflow = 'hidden'; row.classList.add('filtered-hidden');
                            }
                        });

                        tbody.style.display = 'none'; tbody.offsetHeight; tbody.style.display = '';

                        this.handleNoResults(tbody, visibleCount);
                        this.updateButtonStates(filterType);
                    }
                    handleNoResults(tbody, visibleCount) {
                        let noResultsMsg = tbody.querySelector('.no-results-message');
                        if (visibleCount === 0) {
                            if (!noResultsMsg) {
                                noResultsMsg = document.createElement('tr');
                                noResultsMsg.className = 'no-results-message';
                                noResultsMsg.innerHTML = '<td colspan="100%" style="text-align:center; padding:20px;">Nenhum resultado encontrado para este filtro.</td>';
                            }
                            tbody.appendChild(noResultsMsg);
                        } else if (noResultsMsg) {
                            noResultsMsg.remove();
                        }
                    }
                    updateButtonStates(filterType) {
                        this.filterButtons = document.querySelectorAll('.filter-btn');
                        this.filterButtons.forEach(btn => {
                            const btnFilter = btn.getAttribute('data-filter');
                            const active = btnFilter === filterType;
                            btn.classList.toggle('active', active);
                            btn.setAttribute('aria-pressed', active ? 'true' : 'false');
                        });
                    }
                    injectStyles() {
                        const style = document.createElement('style');
                        style.textContent = `
                            .fee-table-container tbody tr.filtered-hidden { display:none!important; height:0!important; overflow:hidden!important; opacity:0!important; visibility:collapse!important; line-height:0!important; padding:0!important; margin:0!important; border:none!important; }
                            .fee-table-container tbody tr.filtered-visible { display:table-row!important; visibility:visible!important; opacity:1!important; }
                            @media (max-width:768px){ .fee-table-container tbody tr.filtered-visible { display:block!important; } }
                            .filter-btn{ transition:all .15s ease; position:relative; overflow:hidden; }
                            .filter-btn:active, .filter-btn.clicking{ background-color:#e3f2fd!important; color:#1976d2!important; transform:scale(.97); box-shadow: inset 0 2px 4px rgba(0,0,0,.1); }
                            .filter-btn.active{ background-color:#e3f2fd; color:#1976d2; font-weight:600; }
                            .filter-btn::after{ content:''; position:absolute; top:50%; left:50%; width:0; height:0; border-radius:50%; background:rgba(25,118,210,.3); transform:translate(-50%,-50%); transition: width .4s, height .4s; }
                            .filter-btn.clicking::after{ width:100px; height:100px; }
                            .no-results-message td{ color:#666; font-style:italic; }
                        `;
                        document.head.appendChild(style);
                    }
                }

                // =========================
                // DOM Ready
                // =========================
                document.addEventListener('DOMContentLoaded', () => {
                    initializeElements();

                    // Troca texto do botão conforme o método de pagamento
                    if (elements.paymentModeSelect && elements.submitBtn) {
                        elements.paymentModeSelect.addEventListener('change', function () {
                            const isReference = this.value === 'Reference' || this.value === 'Entity_Reference';
                            elements.submitBtn.innerHTML = isReference
                                ? '<i class="fas fa-barcode me-1"></i>Gerar Referência'
                                : '<i class="fas fa-check me-1"></i>Confirmar Pagamento';
                            elements.submitBtn.dataset.mode = isReference ? 'reference' : 'normal';
                        });
                    }

                    // Filtros da tabela
                    const filterSystem = new FilterSystem();
                    filterSystem.init();

                    // Eventos do modal
                    if (typeof $ !== 'undefined') {
                        $('#collectFeeModal').on('shown.bs.modal', function () {
                            initializeElements();
                            updateModalDisplay();
                        });

                        $('#collectFeeModal .btn-secondary, #collectFeeModal .btn-close').on('click', function () {
                            if (!state.isProcessingPayment) $('#collectFeeModal').modal('hide');
                        });
                    }

                    // Livewire integration
                    if (typeof Livewire !== 'undefined') {
                        document.addEventListener('livewire:load', () => {
                            // Pagamento concluído (fluxo normal)
                            Livewire.on('paymentSuccess', () => hideModalAndShowSuccess());
                            window.addEventListener('payment-success', () => hideModalAndShowSuccess());

                            // Erro no pagamento
                            Livewire.on('paymentError', (message) => {
                                state.isProcessingPayment = false;
                                if (state.paymentTimeout) { clearTimeout(state.paymentTimeout); state.paymentTimeout = null; }
                                resetPaymentForm();
                                if (typeof Swal !== 'undefined') {
                                    Swal.fire({ icon: 'error', title: 'Erro no Pagamento', text: message || 'Ocorreu um erro ao processar o pagamento.', confirmButtonColor: '#dc3545' });
                                } else { alert('Erro: ' + (message || 'Ocorreu um erro ao processar o pagamento.')); }
                            });

                            // ✅ Referência pronta (abrir/baixar PDF)
                            Livewire.on('referenceReady', (payload) => {
                                state.isProcessingPayment = false;
                                resetPaymentForm();
                                if (typeof $ !== 'undefined') $('#collectFeeModal').modal('hide');

                                if (typeof Swal !== 'undefined') {
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Referência gerada',
                                        text: 'Vamos abrir a fatura com a Entidade e Referência.',
                                        confirmButtonColor: '#28a745',
                                        timer: 500,
                                        showConfirmButton: false
                                    });
                                }
                                if (payload?.pdf_url) window.open(payload.pdf_url, '_blank');
                            });

                            // ❌ Erro na geração de referência
                            Livewire.on('referenceError', (message) => {
                                state.isProcessingPayment = false;
                                resetPaymentForm();
                                if (typeof Swal !== 'undefined') {
                                    Swal.fire({ icon: 'error', title: 'Erro ao gerar referência', text: message || 'Não foi possível gerar a referência.', confirmButtonColor: '#dc3545' });
                                } else { alert(message || 'Não foi possível gerar a referência.'); }
                            });

                            // Envio para o método collectFee (mantido)
                            Livewire.on('collectPayment', (data) => {
                                if (window.livewire?.components?.length > 0) {
                                    const component = window.livewire.components[0];
                                    component.set('month', data.month);
                                    component.set('year', data.year);
                                    component.set('amount', data.amount);
                                    component.set('fine', data.fine);
                                    component.set('discount', data.discount || 0);
                                    component.set('paymentMode', data.paymentMode);
                                    component.set('note', data.note || '');
                                    component.call('collectFee');
                                }
                            });
                        });
                    }
    
   

                    // Otimizações mobile (backdrop/scroll)
                    if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
                        document.addEventListener('touchstart', (e) => {
                            if (e.target.matches('.btn, .filter-btn')) e.target.style.touchAction = 'manipulation';
                        });

                        if (typeof $ !== 'undefined') {
                            $('#collectFeeModal').on('shown.bs.modal', () => {
                                document.body.style.position = 'fixed';
                                document.body.style.width = '100%';
                            });

                            $('#collectFeeModal').on('hidden.bs.modal', () => {
                                document.body.style.position = '';
                                document.body.style.width = '';
                                setTimeout(() => {
                                    document.querySelectorAll('.modal-backdrop').forEach(b => b?.parentNode?.removeChild(b));
                                    document.body.classList.remove('modal-open');
                                }, CONFIG.ANIMATION_DURATION);
                            });

                            $('#collectFeeModal').on('hide.bs.modal', function (e) {
                                if (state.isProcessingPayment) { e.preventDefault(); return false; }
                            });
                        }
                    }
                });
            })();
            </script>

