<div class="page-content">
    <div class="main-wrapper">
        <!-- Page Header -->
        <div style="margin-bottom: 30px;">
            <h2 style="margin: 0; font-size: 28px; color: #2c3e50; font-weight: 600;">
                <i class="fas fa-receipt me-2" style="color: #667eea;"></i>
                Minhas Referências de Pagamento
            </h2>
            <p style="margin: 8px 0 0 0; color: #6c757d; font-size: 15px;">
                Visualize e gerencie suas referências de pagamento agrupadas por mês
            </p>
        </div>

        <!-- Filtros (opcional) -->
        <div class="card shadow-sm mb-4" style="border-radius: 12px; border: none;">
            <div class="card-body" style="background: #f8f9fa; border-radius: 12px;">
                <div class="row g-3 align-items-end">
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">
                            <i class="fas fa-calendar me-1 text-primary"></i> Ano
                        </label>
                        <select class="form-select" wire:model="selectedYear">
                            @for ($i = now()->year; $i >= now()->year - 5; $i--)
                                <option value="{{ $i }}">{{ $i }}</option>
                            @endfor
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-semibold">
                            <i class="fas fa-filter me-1 text-success"></i> Status
                        </label>
                        <select class="form-select" wire:model="filterStatus">
                            <option value="">Todos</option>
                            <option value="pending">Pendentes</option>
                            <option value="approved">Aprovados</option>
                            <option value="paid">Pagos</option>
                            <option value="expired">Expirados</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>

        <!-- Componente de Referências Agrupadas -->
        @if(isset($payment_references) && $payment_references->count() > 0)
            <x-payment-references-grouped
                :references="$payment_references"
                :showActions="true"
            />
        @else
            <div class="empty-state" style="text-align: center; padding: 4rem 2rem; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); border-radius: 12px;">
                <div style="font-size: 5rem; color: #90a4ae; opacity: 0.5; margin-bottom: 1rem;">
                    <i class="fas fa-receipt"></i>
                </div>
                <h4 class="text-muted">Nenhuma referência encontrada</h4>
                <p class="text-muted mb-0">Você ainda não possui referências de pagamento geradas.</p>
            </div>
        @endif

        <!-- Resumo de Estatísticas (opcional) -->
        @if(isset($payment_references) && $payment_references->count() > 0)
        <div class="row g-3 mt-4">
            <div class="col-md-3">
                <div class="card shadow-sm" style="border-left: 4px solid #667eea;">
                    <div class="card-body">
                        <h6 class="text-muted mb-2">Total de Referências</h6>
                        <h3 class="mb-0">{{ $payment_references->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow-sm" style="border-left: 4px solid #4caf50;">
                    <div class="card-body">
                        <h6 class="text-muted mb-2">Pagas</h6>
                        <h3 class="mb-0">{{ $payment_references->where('status', 'paid')->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow-sm" style="border-left: 4px solid #ff9800;">
                    <div class="card-body">
                        <h6 class="text-muted mb-2">Pendentes</h6>
                        <h3 class="mb-0">{{ $payment_references->where('status', 'pending')->count() }}</h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card shadow-sm" style="border-left: 4px solid #2196f3;">
                    <div class="card-body">
                        <h6 class="text-muted mb-2">Valor Total</h6>
                        <h3 class="mb-0">{{ number_format($payment_references->sum('amount'), 2) }} MT</h3>
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>

<script>
function payReference(referenceId) {
    // Implementar lógica de pagamento
    alert('Pagar referência: ' + referenceId);
}

function viewReference(referenceId) {
    // Implementar lógica para visualizar detalhes
    alert('Ver referência: ' + referenceId);
}
</script>
