<div class="page-content">
    <div class="main-wrapper">
        <div class="row justify-content-center">
            <div class="col-12 col-md-8 col-lg-6">

                <div class="card border-0 shadow">
                    <div class="card-header bg-primary text-white py-3">
                        <h5 class="mb-0">
                            <i class="fas fa-rotate me-2"></i>
                            Reservar Vaga — Ano Lectivo {{ $academicYear }}
                        </h5>
                    </div>

                    <div class="card-body p-4">

                        @if($existingRenewal)
                            <!-- Already submitted -->
                            <div class="text-center py-3">
                                @if($existingRenewal->status === 'pendente')
                                    <div class="mb-3">
                                        <span class="badge bg-warning text-dark fs-6 px-3 py-2">
                                            <i class="fas fa-clock me-1"></i>Aguardando Confirmação
                                        </span>
                                    </div>
                                    <p class="text-muted">A sua reserva foi submetida e está a aguardar confirmação pela secretaria.</p>
                                @elseif($existingRenewal->status === 'confirmada')
                                    <div class="mb-3">
                                        <span class="badge bg-success fs-6 px-3 py-2">
                                            <i class="fas fa-check-circle me-1"></i>Reserva Confirmada
                                        </span>
                                    </div>
                                    <p class="text-muted">A sua vaga para o ano {{ $academicYear }} foi confirmada pela secretaria.</p>
                                @else
                                    <div class="mb-3">
                                        <span class="badge bg-danger fs-6 px-3 py-2">
                                            <i class="fas fa-times-circle me-1"></i>Renovação Cancelada
                                        </span>
                                    </div>
                                    <p class="text-muted">A sua renovação foi cancelada. Contacte a secretaria para mais informações.</p>
                                @endif

                                <div class="alert alert-light border mt-3 text-start">
                                    <div class="row g-2">
                                        <div class="col-6">
                                            <small class="text-muted d-block">Classe actual</small>
                                            <strong>{{ $fromClass }}ª Classe</strong>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted d-block">Próxima classe</small>
                                            <strong>{{ $toClass }}ª Classe</strong>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted d-block">Turma actual</small>
                                            <strong>{{ $classroom->name ?? '—' }}</strong>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted d-block">Submetido em</small>
                                            <strong>{{ $existingRenewal->created_at->format('d/m/Y') }}</strong>
                                        </div>
                                    </div>
                                </div>

                                <a href="{{ route('user.home') }}" class="btn btn-outline-secondary mt-2">
                                    <i class="fas fa-arrow-left me-1"></i>Voltar ao Início
                                </a>
                            </div>

                        @else
                            <!-- Ready to submit -->
                            <div class="text-center mb-4">
                                <div class="rounded-circle d-inline-flex align-items-center justify-content-center mb-3"
                                     style="width:72px;height:72px;background:#dbeafe;">
                                    <i class="fas fa-graduation-cap fa-2x text-primary"></i>
                                </div>
                                <h5 class="fw-bold">Reservar a sua vaga para {{ $academicYear }}</h5>
                                <p class="text-muted">Confirme que pretende continuar no próximo ano lectivo.</p>
                            </div>

                            <div class="alert alert-light border mb-4">
                                <div class="row g-3">
                                    <div class="col-6 text-center">
                                        <small class="text-muted d-block mb-1">Classe actual</small>
                                        <span class="badge bg-secondary fs-6 px-3">{{ $fromClass }}ª Classe</span>
                                    </div>
                                    <div class="col-6 text-center">
                                        <small class="text-muted d-block mb-1">Avança para</small>
                                        <span class="badge bg-primary fs-6 px-3">{{ $toClass }}ª Classe</span>
                                    </div>
                                    <div class="col-12 text-center">
                                        <small class="text-muted d-block mb-1">Turma actual</small>
                                        <strong>{{ $classroom->name ?? '—' }}</strong>
                                    </div>
                                </div>
                            </div>

                            <div class="d-grid gap-2">
                                <button wire:click="submit"
                                        wire:loading.attr="disabled"
                                        class="btn btn-primary btn-lg">
                                    <span wire:loading.remove wire:target="submit">
                                        <i class="fas fa-check me-2"></i>Reservar Vaga para {{ $academicYear }}
                                    </span>
                                    <span wire:loading wire:target="submit">
                                        <span class="spinner-border spinner-border-sm me-2"></span>A processar...
                                    </span>
                                </button>
                                <a href="{{ route('user.home') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-arrow-left me-1"></i>Cancelar
                                </a>
                            </div>
                        @endif

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
