<div class="page-content">
    <div class="main-wrapper">
        <div wire:init="loadData">
            <!-- Hero Header -->
            <div class="dashboard-hero">
                <div class="hero-content">
                    <div class="welcome-section">
                        @php
                            // Extrair iniciais: primeira letra do primeiro nome + primeira letra do segundo nome
                            $nameParts = explode(' ', trim($user->name));
                            $initials = strtoupper(substr($nameParts[0], 0, 1));
                            if (count($nameParts) > 1) {
                                $initials .= strtoupper(substr($nameParts[1], 0, 1));
                            }

                            // Verificar se avatar existe e não está vazio
                            $hasAvatar = !empty($user->avatar) && $user->avatar !== null;
                        @endphp

                        <div class="avatar-circle {{ $hasAvatar ? 'has-image' : '' }}"
                             @if($hasAvatar) style="background-image: url('{{ asset($user->avatar) }}');" @endif>
                            @if(!$hasAvatar)
                                {{ $initials }}
                            @endif
                        </div>
                        <div>
                            <h1 class="welcome-title">Bem-vindo, {{ $user->name }}!</h1>
                            <p class="welcome-subtitle">Acompanhe seu progresso acadêmico</p>
                        </div>
                    </div>
                    <div class="student-info-badges">
                        <div class="info-badge academic-year">
                            <i class="fas fa-calendar-alt"></i>
                            <div class="badge-content">
                                <span class="badge-label">Ano Letivo</span>
                                <span class="badge-value">{{ $academic_year }}</span>
                            </div>
                        </div>
                        <div class="info-badge class-badge">
                            <i class="fas fa-graduation-cap"></i>
                            <div class="badge-content">
                                <span class="badge-label">Classe</span>
                                <span class="badge-value">{{ $class_grade }}ª</span>
                            </div>
                        </div>
                        <div class="info-badge classroom-badge">
                            <i class="fas fa-users"></i>
                            <div class="badge-content">
                                <span class="badge-label">Turma</span>
                                <span class="badge-value">{{ $classroom_name }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Renewal Banner — topo, antes de tudo -->
            @if($renewalOpen && !$studentRenewal)
            <a href="{{ route('user.renewal') }}" class="text-decoration-none d-block mb-3">
                <div style="background:linear-gradient(135deg,#dc2626 0%,#b91c1c 100%);border-radius:.7rem;padding:1.1rem 1.4rem;display:flex;align-items:center;gap:1rem;box-shadow:0 6px 20px rgba(185,28,28,.4);">
                    <div style="width:54px;height:54px;border-radius:50%;background:rgba(255,255,255,.18);display:flex;align-items:center;justify-content:center;flex-shrink:0;">
                        <i class="fas fa-rotate" style="color:#fff;font-size:1.4rem;"></i>
                    </div>
                    <div style="flex:1;min-width:0;">
                        <div style="color:#fff;font-weight:700;font-size:1rem;letter-spacing:.01em;">
                            ⚠️ Reservar Vaga — Ano Lectivo {{ $renewalYear }}
                        </div>
                        <div style="color:rgba(255,255,255,.85);font-size:.82rem;margin-top:.2rem;">
                            O período de renovação está aberto. Clique aqui para garantir o seu lugar no próximo ano lectivo.
                        </div>
                    </div>
                    <i class="fas fa-chevron-right" style="color:rgba(255,255,255,.65);font-size:1.1rem;flex-shrink:0;"></i>
                </div>
            </a>
            @elseif($studentRenewal)
            @php
                $rColor   = $studentRenewal->status === 'confirmada' ? '#16a34a' : ($studentRenewal->status === 'cancelada' ? '#dc2626' : '#d97706');
                $rBg      = $studentRenewal->status === 'confirmada' ? '#f0fdf4' : ($studentRenewal->status === 'cancelada' ? '#fef2f2' : '#fffbeb');
                $rIconBg  = $studentRenewal->status === 'confirmada' ? '#d1fae5' : ($studentRenewal->status === 'cancelada' ? '#fee2e2' : '#fef9c3');
                $rIcon    = $studentRenewal->status === 'confirmada' ? 'check-circle' : ($studentRenewal->status === 'cancelada' ? 'times-circle' : 'clock');
                $rLabel   = $studentRenewal->status === 'confirmada' ? 'Confirmada' : ($studentRenewal->status === 'cancelada' ? 'Cancelada' : 'Aguardando Confirmação');
                $rMsg     = $studentRenewal->status === 'confirmada' ? 'A sua vaga para '.$renewalYear.' está garantida.' : ($studentRenewal->status === 'cancelada' ? 'Contacte a secretaria para mais informações.' : 'A sua reserva foi submetida e está a ser processada.');
            @endphp
            <div class="d-flex align-items-center gap-3 mb-3 p-3"
                 style="background:{{ $rBg }};border-left:5px solid {{ $rColor }};border-radius:.6rem;">
                <div style="width:48px;height:48px;border-radius:50%;background:{{ $rIconBg }};display:flex;align-items:center;justify-content:center;flex-shrink:0;">
                    <i class="fas fa-{{ $rIcon }} fa-lg" style="color:{{ $rColor }};"></i>
                </div>
                <div>
                    <div class="fw-bold" style="color:{{ $rColor }};">Renovação {{ $renewalYear }}: {{ $rLabel }}</div>
                    <small class="text-muted">{{ $rMsg }}</small>
                </div>
            </div>
            @endif

            @if(!empty($noticeboard) && count($noticeboard) != 0)
            <!-- Notices Banner -->
            <div class="notices-banner">
                <div class="notices-header">
                    <h3>
                        <i class="fas fa-bell"></i>
                        Comunicados Importantes
                    </h3>
                    <span class="badge-count">{{ count($noticeboard) }}</span>
                </div>
                <div class="notices-list">
                    @foreach($noticeboard as $notice)
                    <div class="notice-item">
                        <div class="notice-icon">
                            <i class="fas fa-info-circle"></i>
                        </div>
                        <div class="notice-content">
                            <h4>{{ $notice->title }}</h4>
                            @if($notice->media_url)
                            <a href="{{ $notice->media_url }}" class="notice-link">
                                <i class="fas fa-paperclip"></i>
                                {{ $notice->media_name }}
                            </a>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif

            <!-- Payment Status Alert -->
            @if (!$user->is_paid)
            <div class="payment-alert">
                <div class="alert-icon">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div class="alert-content">
                    <h3>Pagamento Pendente</h3>
                    <p>Por favor, efetue o pagamento da taxa escolar para aceder aos resultados e relatórios.</p>
                    <a href="{{ route('user.fee.collection') }}" class="alert-btn">
                        <i class="fas fa-credit-card"></i>
                        Pagar Agora
                    </a>
                </div>
            </div>
            @endif

            <!-- Comunicados Card (Full Width) -->
            <a href="{{ route('admin.user.notice') }}" class="access-card-full card-notices">
                <div class="card-icon-wrapper">
                    <div class="card-icon">
                        <i class="fas fa-bullhorn"></i>
                    </div>
                    @if(count($noticeboard) > 0)
                    <div class="card-badge">{{ count($noticeboard) }}</div>
                    @endif
                </div>
                <div class="card-content">
                    <h3>Comunicados Importantes</h3>
                    <p>Ver todas as notificações e avisos</p>
                    <div class="card-footer">
                        <span class="card-link">
                            Ver Comunicados
                            <i class="fas fa-arrow-right"></i>
                        </span>
                    </div>
                </div>
            </a>

            <!-- Disciplinas Card (Full Width) -->
            <div class="info-card-full info-subjects-full">
                <div class="info-icon">
                    <i class="fas fa-book"></i>
                </div>
                <div class="info-content">
                    <span class="info-label">Disciplinas</span>
                    <h2 class="info-value">{{ $subjects }}</h2>
                    <p class="info-desc">Disciplinas matriculadas neste ano letivo</p>
                </div>
            </div>

            <!-- Quick Access Cards -->
            <div class="cards-grid">
                @if ($user->is_paid)
                <a href="{{ route('user.exams') }}" class="access-card card-exams">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <i class="fas fa-file-alt"></i>
                        </div>
                    </div>
                    <div class="card-content">
                        <h3>Testes e Exames</h3>
                        <p>Consultar resultados</p>
                        <div class="card-footer">
                            <span class="card-link">
                                Ver Resultados
                                <i class="fas fa-arrow-right"></i>
                            </span>
                        </div>
                    </div>
                </a>
                @else
                <div class="access-card card-locked">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <i class="fas fa-lock"></i>
                        </div>
                    </div>
                    <div class="card-content">
                        <h3>Testes e Exames</h3>
                        <p class="text-warning">Pagamento necessário</p>
                        <div class="card-footer">
                            <span class="card-link disabled">
                                Bloqueado
                                <i class="fas fa-lock"></i>
                            </span>
                        </div>
                    </div>
                </div>
                @endif

                @if ($user->is_paid)
                <a href="{{ route('admin.user.downloads') }}" class="access-card card-materials">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <i class="fas fa-download"></i>
                        </div>
                        @if($notifications > 0)
                        <div class="card-badge">{{ $notifications }}</div>
                        @endif
                    </div>
                    <div class="card-content">
                        <h3>Matrizes</h3>
                        <p>Materiais didácticos</p>
                        <div class="card-footer">
                            <span class="card-link">
                                Baixar Arquivos
                                <i class="fas fa-arrow-right"></i>
                            </span>
                        </div>
                    </div>
                </a>
                @else
                <div class="access-card card-locked">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <i class="fas fa-lock"></i>
                        </div>
                    </div>
                    <div class="card-content">
                        <h3>Matrizes</h3>
                        <p class="text-warning">Pagamento necessário</p>
                        <div class="card-footer">
                            <span class="card-link disabled">
                                Bloqueado
                                <i class="fas fa-lock"></i>
                            </span>
                        </div>
                    </div>
                </div>
                @endif

                <a href="{{ route('admin.user.fee') }}" class="access-card card-payments">
                    <div class="card-icon-wrapper">
                        <div class="card-icon">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        @if($notifications_payment > 0)
                        <div class="card-badge">{{ $notifications_payment }}</div>
                        @endif
                    </div>
                    <div class="card-content">
                        <h3>Pagamentos</h3>
                        <p>Taxas escolares e histórico</p>
                        <div class="card-footer">
                            <span class="card-link">
                                Ver Pagamentos
                                <i class="fas fa-arrow-right"></i>
                            </span>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
</div>

<style>
/* Student Dashboard Professional Styles - Aligned with AdminLTE */

/* Hero Header */
.dashboard-hero {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 20px;
    padding: 2rem;
    margin-bottom: 2rem;
    box-shadow: 0 10px 40px rgba(102, 126, 234, 0.3);
}

.hero-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
    flex-wrap: wrap;
    gap: 1rem;
}

.welcome-section {
    display: flex;
    align-items: center;
    gap: 1.5rem;
}

.avatar-circle {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: rgba(255, 255, 255, 0.25);
    backdrop-filter: blur(10px);
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    font-weight: 700;
    border: 3px solid rgba(255, 255, 255, 0.3);
    position: relative;
    overflow: hidden;
}

/* Avatar com imagem */
.avatar-circle.has-image {
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    backdrop-filter: none;
}

.welcome-title {
    color: white;
    font-size: 2rem;
    font-weight: 700;
    margin: 0 0 0.5rem;
}

.welcome-subtitle {
    color: rgba(255, 255, 255, 0.9);
    margin: 0;
    font-size: 1rem;
}

/* Student Info Badges */
.student-info-badges {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.info-badge {
    background: rgba(255, 255, 255, 0.25);
    backdrop-filter: blur(12px);
    border: 1px solid rgba(255, 255, 255, 0.3);
    padding: 0.875rem 1.25rem;
    border-radius: 14px;
    color: white;
    display: flex;
    align-items: center;
    gap: 0.875rem;
    transition: all 0.3s ease;
}

.info-badge:hover {
    background: rgba(255, 255, 255, 0.35);
    transform: translateY(-2px);
}

.info-badge i {
    font-size: 1.5rem;
    opacity: 0.95;
}

.badge-content {
    display: flex;
    flex-direction: column;
    gap: 0.125rem;
}

.badge-label {
    font-size: 0.75rem;
    opacity: 0.9;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.badge-value {
    font-size: 1.125rem;
    font-weight: 700;
    line-height: 1;
}

/* Notices Banner */
.notices-banner {
    background: linear-gradient(135deg, #fff5e1 0%, #ffe0b2 100%);
    border-radius: 16px;
    padding: 1.5rem;
    margin-bottom: 2rem;
    border-left: 4px solid #ff9800;
}

.notices-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.notices-header h3 {
    color: #e65100;
    font-size: 1.25rem;
    font-weight: 700;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.badge-count {
    background: #ff9800;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 12px;
    font-size: 0.875rem;
    font-weight: 600;
}

.notices-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.notice-item {
    background: white;
    border-radius: 12px;
    padding: 1rem;
    display: flex;
    gap: 1rem;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
}

.notice-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    background: #fff3e0;
    color: #ff9800;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.25rem;
    flex-shrink: 0;
}

.notice-content h4 {
    color: #333;
    font-size: 1rem;
    font-weight: 600;
    margin: 0 0 0.5rem;
}

.notice-link {
    color: #ff9800;
    text-decoration: none;
    font-size: 0.875rem;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 500;
}

.notice-link:hover {
    text-decoration: underline;
}

/* Payment Alert */
.payment-alert {
    background: linear-gradient(135deg, #fff3e0 0%, #ffe0b2 100%);
    border-radius: 16px;
    padding: 1.75rem;
    margin-bottom: 2rem;
    display: flex;
    gap: 1.5rem;
    align-items: flex-start;
    border-left: 4px solid #f57c00;
    box-shadow: 0 4px 20px rgba(245, 124, 0, 0.1);
}

.alert-icon {
    width: 60px;
    height: 60px;
    border-radius: 14px;
    background: #ff9800;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    flex-shrink: 0;
}

.alert-content h3 {
    color: #e65100;
    font-size: 1.25rem;
    font-weight: 700;
    margin: 0 0 0.5rem;
}

.alert-content p {
    color: #6d4c41;
    margin: 0 0 1rem;
}

.alert-btn {
    background: #ff9800;
    color: white;
    padding: 0.75rem 1.5rem;
    border-radius: 10px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    font-weight: 600;
    transition: all 0.3s ease;
}

.alert-btn:hover {
    background: #f57c00;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(245, 124, 0, 0.3);
}

/* Full Width Cards */
.access-card-full {
    background: white;
    border-radius: 16px;
    padding: 1.75rem;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
}

.access-card-full::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: currentColor;
}

.access-card-full:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
}

.card-notices {
    color: #f59e0b;
    background: linear-gradient(135deg, #fff 0%, #fffbeb 100%);
}

.info-card-full {
    background: linear-gradient(135deg, #fff 0%, #eff6ff 100%);
    border-radius: 16px;
    padding: 1.75rem;
    display: flex;
    gap: 1.5rem;
    align-items: center;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
    margin-bottom: 1.5rem;
    border-left: 4px solid #3b82f6;
}

.info-subjects-full .info-icon {
    width: 70px;
    height: 70px;
    border-radius: 16px;
    background: #3b82f6;
    color: white;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
    flex-shrink: 0;
}

.info-subjects-full .info-label {
    display: block;
    font-size: 0.875rem;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.5rem;
}

.info-subjects-full .info-value {
    font-size: 2.5rem;
    font-weight: 700;
    color: #111827;
    margin: 0 0 0.5rem;
    line-height: 1;
}

.info-subjects-full .info-desc {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

/* Cards Grid */
.cards-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2rem;
}

.access-card {
    background: white;
    border-radius: 16px;
    padding: 1.75rem;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.06);
    position: relative;
    overflow: hidden;
}

.access-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 4px;
    background: currentColor;
}

.access-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
}

.card-exams { color: #3b82f6; }
.card-payments { color: #10b981; }
.card-materials { color: #8b5cf6; }
.card-confirmations { color: #f59e0b; }
.card-locked { color: #9ca3af; opacity: 0.7; cursor: not-allowed; }

.card-locked:hover {
    transform: none;
}

.card-icon-wrapper {
    position: relative;
    margin-bottom: 1.25rem;
}

.card-icon {
    width: 70px;
    height: 70px;
    border-radius: 16px;
    color: white !important;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.card-exams .card-icon {
    background: #3b82f6;
}

.card-payments .card-icon {
    background: #10b981;
}

.card-materials .card-icon {
    background: #8b5cf6;
}

.card-notices .card-icon {
    background: #f59e0b;
}

.card-locked .card-icon {
    background: #9ca3af;
}

.card-badge {
    position: absolute;
    top: -8px;
    right: -8px;
    background: #ef4444;
    color: white;
    width: 28px;
    height: 28px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
    font-weight: 700;
    border: 3px solid white;
}

.card-content h3 {
    color: #111827;
    font-size: 1.25rem;
    font-weight: 700;
    margin: 0 0 0.5rem;
}

.card-content p {
    color: #6b7280;
    margin: 0 0 1rem;
    font-size: 0.875rem;
}

.card-footer {
    padding-top: 1rem;
    border-top: 1px solid #f3f4f6;
}

.card-link {
    color: currentColor;
    font-weight: 600;
    font-size: 0.875rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.card-link.disabled {
    color: #9ca3af;
}

/* Info Cards Row */
.info-cards-row {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
    gap: 1.25rem;
}

.info-card {
    background: white;
    border-radius: 14px;
    padding: 1.5rem;
    display: flex;
    gap: 1.25rem;
    align-items: center;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
}

.info-icon {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.75rem;
    flex-shrink: 0;
}

.info-subjects .info-icon {
    background: #eff6ff;
    color: #3b82f6;
}

.info-notices .info-icon {
    background: #fef3c7;
    color: #f59e0b;
}

.info-year .info-icon {
    background: #f3e8ff;
    color: #8b5cf6;
}

.info-label {
    display: block;
    font-size: 0.75rem;
    font-weight: 600;
    color: #6b7280;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 0.25rem;
}

.info-value {
    font-size: 1.875rem;
    font-weight: 700;
    color: #111827;
    margin: 0 0 0.25rem;
    line-height: 1;
}

.info-desc {
    font-size: 0.875rem;
    color: #6b7280;
    margin: 0;
}

.info-link {
    color: currentColor;
    text-decoration: none;
    font-weight: 500;
}

.info-link:hover {
    text-decoration: underline;
}

/* Responsive Design */
@media (max-width: 768px) {
    .student-dashboard {
        padding: 1rem;
    }

    .dashboard-hero {
        padding: 1.5rem;
    }

    .welcome-section {
        flex-direction: column;
        text-align: center;
        width: 100%;
    }

    .welcome-title {
        font-size: 1.5rem;
    }

    .avatar-circle {
        width: 70px;
        height: 70px;
        font-size: 1.75rem;
    }

    .hero-content {
        flex-direction: column;
        align-items: center;
        text-align: center;
    }

    .student-info-badges {
        justify-content: center;
        width: 100%;
    }

    .info-badge {
        flex: 1;
        min-width: 140px;
        justify-content: center;
    }

    .access-card-full,
    .info-card-full {
        flex-direction: column;
        text-align: center;
    }

    .cards-grid {
        grid-template-columns: 1fr;
        gap: 1.25rem;
    }

    .info-cards-row {
        grid-template-columns: 1fr;
    }

    .payment-alert {
        flex-direction: column;
        text-align: center;
    }

    .alert-icon {
        margin: 0 auto;
    }
}

@media (max-width: 576px) {
    .dashboard-hero {
        padding: 1.25rem;
    }

    .welcome-title {
        font-size: 1.25rem;
    }

    .avatar-circle {
        width: 60px;
        height: 60px;
        font-size: 1.5rem;
    }

    .student-info-badges {
        flex-direction: column;
        width: 100%;
    }

    .info-badge {
        width: 100%;
        justify-content: flex-start;
    }

    .badge-value {
        font-size: 1rem;
    }

    .card-icon {
        width: 60px;
        height: 60px;
        font-size: 1.75rem;
    }

    .card-content h3 {
        font-size: 1.125rem;
    }

    .info-value {
        font-size: 1.5rem;
    }

    .notices-header h3 {
        font-size: 1.125rem;
    }

    .notice-item {
        flex-direction: column;
    }
}

@media (max-width: 375px) {
    .welcome-title {
        font-size: 1.1rem;
    }

    .date-badge {
        padding: 0.5rem 1rem;
        font-size: 0.875rem;
    }

    .card-icon {
        width: 50px;
        height: 50px;
        font-size: 1.5rem;
    }

    .info-icon {
        width: 50px;
        height: 50px;
        font-size: 1.5rem;
    }
}
</style>
