<div class="verification-card">
    <div class="verification-header">
        <div class="logo-circle">
            <i class="fas fa-graduation-cap"></i>
        </div>
        <h1>COLÉGIO POLITÉCNICO DE MOÇAMBIQUE</h1>
        <p>Sistema de Verificação de Certificados</p>
    </div>

    <div class="verification-body">
        <!-- Search Form -->
        <div class="mb-4">
            <label class="form-label fw-semibold">Código de Verificação</label>
            <div class="input-group">
                <input type="text"
                       class="form-control search-input"
                       placeholder="Insira o código do certificado..."
                       wire:model.defer="verificationCode"
                       wire:keydown.enter="verify">
                <button class="btn btn-verify text-white" wire:click="verify" wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="verify">
                        <i class="fas fa-search me-2"></i>Verificar
                    </span>
                    <span wire:loading wire:target="verify">
                        <i class="fas fa-spinner fa-spin me-2"></i>A verificar...
                    </span>
                </button>
            </div>
            <small class="text-muted mt-2 d-block">
                <i class="fas fa-info-circle me-1"></i>
                Escaneie o QR Code do certificado ou insira o código manualmente.
            </small>
        </div>

        <!-- Error Message -->
        @if($error)
        <div class="alert alert-danger d-flex align-items-center" role="alert">
            <i class="fas fa-exclamation-circle me-2 fa-lg"></i>
            <div>{{ $error }}</div>
        </div>
        @endif

        <!-- Result -->
        @if($result)
        <div class="result-card shadow-sm">
            @if($result['valid'])
            <!-- Valid Certificate -->
            <div class="valid-badge">
                <i class="fas fa-check-circle fa-3x mb-2"></i>
                <h4 class="mb-1">CERTIFICADO VÁLIDO</h4>
                <p class="mb-0">Este certificado é autêntico</p>
            </div>
            <div class="p-4">
                <div class="info-row">
                    <span class="info-label">Número do Certificado</span>
                    <span class="info-value">{{ $result['certificate']->certificate_number }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Nome do Estudante</span>
                    <span class="info-value">{{ $result['certificate']->student_name }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Código do Estudante</span>
                    <span class="info-value">{{ $result['certificate']->student_id_number }}</span>
                </div>
                @if($result['certificate']->student_dob)
                <div class="info-row">
                    <span class="info-label">Data de Nascimento</span>
                    <span class="info-value">{{ \Carbon\Carbon::parse($result['certificate']->student_dob)->format('d/m/Y') }}</span>
                </div>
                @endif
                <div class="info-row">
                    <span class="info-label">Classe / Turma</span>
                    <span class="info-value">12ª Classe - {{ $result['certificate']->turma_name }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Ano Lectivo</span>
                    <span class="info-value">{{ $result['certificate']->academic_year }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">Nota Final</span>
                    <span class="info-value">
                        <span class="badge bg-success fs-6">{{ number_format($result['certificate']->final_average, 2) }}</span>
                    </span>
                </div>
                <div class="info-row">
                    <span class="info-label">Data de Emissão</span>
                    <span class="info-value">{{ $result['certificate']->issued_at->format('d/m/Y') }}</span>
                </div>

                @if($result['integrity_verified'])
                <div class="mt-3 p-3 bg-success bg-opacity-10 rounded">
                    <div class="d-flex align-items-center text-success">
                        <i class="fas fa-shield-alt me-2"></i>
                        <span class="fw-semibold">Integridade verificada - Documento não foi alterado</span>
                    </div>
                </div>
                @endif

                <!-- Grades Table -->
                <div class="mt-4">
                    <h6 class="fw-semibold mb-3">
                        <i class="fas fa-list-ol me-2"></i>Notas por Disciplina
                    </h6>
                    <div class="table-responsive">
                        <table class="table table-sm table-bordered">
                            <thead class="table-light">
                                <tr>
                                    <th>Disciplina</th>
                                    <th class="text-center">1º Trim</th>
                                    <th class="text-center">2º Trim</th>
                                    <th class="text-center">3º Trim</th>
                                    <th class="text-center">MFD</th>
                                    <th class="text-center">NE</th>
                                    <th class="text-center">Final</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($result['certificate']->subject_grades as $subject => $grades)
                                <tr>
                                    <td>{{ $subject }}</td>
                                    <td class="text-center">{{ $grades['nf1'] }}</td>
                                    <td class="text-center">{{ $grades['nf2'] }}</td>
                                    <td class="text-center">{{ $grades['nf3'] }}</td>
                                    <td class="text-center">{{ $grades['mfd'] }}</td>
                                    <td class="text-center">{{ $grades['ne'] ?? '-' }}</td>
                                    <td class="text-center fw-bold">{{ $grades['final'] }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            @else
            <!-- Invalid Certificate -->
            <div class="invalid-badge">
                <i class="fas fa-times-circle fa-3x mb-2"></i>
                <h4 class="mb-1">CERTIFICADO INVÁLIDO</h4>
                @if($result['status'] === 'revoked')
                <p class="mb-0">Este certificado foi revogado</p>
                @else
                <p class="mb-0">Falha na verificação de integridade</p>
                @endif
            </div>
            <div class="p-4">
                @if($result['certificate'])
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    @if($result['status'] === 'revoked')
                    <strong>Certificado Revogado</strong><br>
                    Este certificado foi revogado em {{ $result['certificate']->revoked_at ? $result['certificate']->revoked_at->format('d/m/Y') : 'data desconhecida' }}.
                    @if($result['certificate']->revocation_reason)
                    <br>Motivo: {{ $result['certificate']->revocation_reason }}
                    @endif
                    @else
                    <strong>Falha na Verificação</strong><br>
                    A integridade do documento não pode ser verificada. O certificado pode ter sido alterado.
                    @endif
                </div>
                @endif
            </div>
            @endif
        </div>

        <!-- New Search Button -->
        @if($searched)
        <div class="text-center mt-4">
            <button class="btn btn-outline-secondary" wire:click="clearSearch">
                <i class="fas fa-search me-2"></i>Nova Verificação
            </button>
        </div>
        @endif
        @endif

        <!-- Instructions -->
        @if(!$searched)
        <div class="mt-4 p-4 bg-light rounded">
            <h6 class="fw-semibold mb-3">
                <i class="fas fa-question-circle me-2 text-primary"></i>Como verificar?
            </h6>
            <ol class="mb-0 ps-3">
                <li class="mb-2">Escaneie o QR Code no certificado com o seu telemóvel</li>
                <li class="mb-2">Ou copie o código de verificação que aparece no certificado</li>
                <li class="mb-2">Cole o código no campo acima e clique em "Verificar"</li>
                <li>Confira se os dados apresentados correspondem ao certificado</li>
            </ol>
        </div>
        @endif
    </div>
</div>
