<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <META NAME="ROBOTS" CONTENT="INDEX, FOLLOW">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name', '')); ?></title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('assets/images/logo.png')); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('assets/images/logo.png')); ?>" type="image/x-icon">

    <meta name="author" content="">
    <meta property="og:type" content="website" />
    <meta property="og:title" content="<?php echo e(config('app.name')); ?>" />
    <meta property="og:image" content="<?php echo e(asset('assets/images/logo.png')); ?>" />
    <meta property="og:description" content="" />

    <!-- Styles -->
    <link href="https://fonts.googleapis.com/css?family=Poppins:400,500,700,800&display=swap" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/font-awesome/css/all.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/plugins/DataTables/datatables.min.css')); ?>" rel="stylesheet">

    <!-- Theme Styles -->
    <link href="<?php echo e(asset('assets/css/main.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/sidebar-toggle-fix.css')); ?>" rel="stylesheet">
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo view('laravel-trix::trixassets')->render(); ?>
    <style>
        .footer-text-left {
            font-size: 15px;
            padding-left: 500px;
            float: center;
            word-spacing: 20px;
        }
    </style>
</head>

<body>
    <div class='loader' wire:loading>
        <div class='spinner-grow text-primary' role='status'>
            <span class='sr-only'>Processando...</span>
        </div>
    </div>



    <div class="page-container">
        <?php if(Auth::guard('admin')->check()): ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('amTwWuw')) {
    $componentId = $_instance->getRenderedChildComponentId('amTwWuw');
    $componentTag = $_instance->getRenderedChildComponentTagName('amTwWuw');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('amTwWuw');
} else {
    $response = \Livewire\Livewire::mount('admin.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('amTwWuw', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('admin.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('3FLp9cI')) {
    $componentId = $_instance->getRenderedChildComponentId('3FLp9cI');
    $componentTag = $_instance->getRenderedChildComponentTagName('3FLp9cI');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('3FLp9cI');
} else {
    $response = \Livewire\Livewire::mount('admin.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('3FLp9cI', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php elseif(Auth::guard('guardian')->check()): ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('guardian.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('5cOKRzG')) {
    $componentId = $_instance->getRenderedChildComponentId('5cOKRzG');
    $componentTag = $_instance->getRenderedChildComponentTagName('5cOKRzG');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('5cOKRzG');
} else {
    $response = \Livewire\Livewire::mount('guardian.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('5cOKRzG', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('guardian.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('0BYN1Rv')) {
    $componentId = $_instance->getRenderedChildComponentId('0BYN1Rv');
    $componentTag = $_instance->getRenderedChildComponentTagName('0BYN1Rv');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('0BYN1Rv');
} else {
    $response = \Livewire\Livewire::mount('guardian.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('0BYN1Rv', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php elseif(Auth::guard('web')->check()): ?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.inc.header', [])->html();
} elseif ($_instance->childHasBeenRendered('znnxAXU')) {
    $componentId = $_instance->getRenderedChildComponentId('znnxAXU');
    $componentTag = $_instance->getRenderedChildComponentTagName('znnxAXU');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('znnxAXU');
} else {
    $response = \Livewire\Livewire::mount('user.inc.header', []);
    $html = $response->html();
    $_instance->logRenderedChild('znnxAXU', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
            <?php
if (! isset($_instance)) {
    $html = \Livewire\Livewire::mount('user.inc.sidebar', [])->html();
} elseif ($_instance->childHasBeenRendered('wnA1Rx3')) {
    $componentId = $_instance->getRenderedChildComponentId('wnA1Rx3');
    $componentTag = $_instance->getRenderedChildComponentTagName('wnA1Rx3');
    $html = \Livewire\Livewire::dummyMount($componentId, $componentTag);
    $_instance->preserveRenderedChild('wnA1Rx3');
} else {
    $response = \Livewire\Livewire::mount('user.inc.sidebar', []);
    $html = $response->html();
    $_instance->logRenderedChild('wnA1Rx3', $response->id(), \Livewire\Livewire::getRootElementTagName($html));
}
echo $html;
?>
        <?php endif; ?>
        <?php echo e($slot); ?>

        <div class="container">
            <div class="row">
                <div class="col-md-2"></div>
                     </div>
                </div>
                <div class="col-md-2"></div>
            </div>

        </div>

        <footer style="text-align:center; padding:20px 0 10px; color:#6c757d; font-size:13px;">
            &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name')); ?> - Desenvolvido por <a href="https://www.ifix.co.mz" target="_blank" style="color:#058fd0; text-decoration:none;">iFix, Lda</a>
        </footer>

    </div>

    <!-- Javascripts -->
    <script src="<?php echo e(asset('assets/plugins/jquery/jquery-3.4.1.min.js')); ?>"></script>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="<?php echo e(asset('assets/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <script src="<?php echo e(asset('assets/plugins/perfectscroll/perfect-scrollbar.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/apexcharts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/main.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/dashboard.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/DataTables/datatables.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <?php echo $__env->yieldContent('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/sweetalert.js')); ?>"></script>
    <?php if (isset($component)) { $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'livewire-alert::components.scripts','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('livewire-alert::scripts'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $attributes = $__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__attributesOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6)): ?>
<?php $component = $__componentOriginal8344cca362e924d63cb0780eb5ae3ae6; ?>
<?php unset($__componentOriginal8344cca362e924d63cb0780eb5ae3ae6); ?>
<?php endif; ?>
    <?php echo \Livewire\Livewire::scripts(); ?>

</body>

</html>
<?php /**PATH /home/salum3x/public_html/siga.copmoz.ac.mz/resources/views/layouts/app.blade.php ENDPATH**/ ?>