<?php

namespace App\Http\Livewire\Admin\Admins;

use App\Models\Admin;
use App\Traits\SysPermissions;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;
use Exception;
use Twilio\Rest\Client;
use Illuminate\Support\Facades\URL;
class EditAdmin extends Component
{
    use FindGuard, SysPermissions, LivewireAlert;

    public $user;
    public $name, $role;
    public $phone_number;
    public $email, $is_active;
    public $is_dormant;
    public $validatedData;
    public $access = [];

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function mount(string $slug)
    {
        $this->user = Admin::query()->firstWhere('slug', $slug);
        if (!$this->user) {
            return redirect()->route('admin.list.admins');
        } else {
            $this->name = $this->user->name;
            $this->phone_number = $this->user->phone_number;
            $this->email = $this->user->email;
            $this->role = $this->user->role;
            $this->is_active = $this->user->is_active;
        }
        foreach ($this->user->getPermissionNames() as $permissionName) {
            $this->access[] = $permissionName;
        }

    }

    protected function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'role' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255'],
            'phone_number' => ['required', 'numeric'],
            'is_active' => ['required'],
        ];
    }

    /**
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    /**
     * update user password here
     */
    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }

    public function linkOrRemovePrivilege(string $privilege)
    {
        // check if it exists in array
        if (in_array($privilege, $this->access)) {
            unset($this->access[array_search($privilege, $this->access)]);
            if ($this->user->hasPermissionTo($privilege)) {
                $this->user->revokePermissionTo($privilege);
                $this->user->refresh();
                $this->emit('noteAdded');
                $this->alert('warning', 'Privilégio revogado ' . $privilege);
            }
        } else {
            $this->access[] = $privilege;
            $this->user->givePermissionTo($privilege);
            $this->user->refresh();
            $this->emit('noteAdded');
            $this->alert('info', 'Privilégio concedido ' . $privilege);
        }
    }

    public function confirmed()
    {
        $this->user->fill($this->validatedData);
        if ($this->user->isClean()) {
            $this->alert('warning', 'Pelo menos um valor deve mudar.');
            return redirect()->back();
        }

               // generate password
        $password = rand(100000, 500000);
        // $password = rand(100000, 500000);
        // create officer here
        $hod = Admin::query()->where('id', $this->user->id)->update([
            'name' => $this->name,
            'email' => $this->email,
            'role' => $this->role,
            'phone_number' => $this->phone_number,
            'password' => bcrypt($password),
        ]);
        // todo send sms
        try {
            $account_sid = getenv("TWILIO_SID");
            $auth_token = getenv("TWILIO_TOKEN");
            $twilio_number = getenv("TWILIO_FROM");

            $client = new Client($account_sid, $auth_token);

            // Generate the callback URL based on your route
            $callbackUrl = route('admin.login');

            // Include the URL on a new line using \n
           $message = "Ola " . $this->name . ", Voce foi registado no sistema de gestao escolar COPMOZ, o seu Email: $this->email \ne a sua senha:" . $password . "\n \nLink para login: $callbackUrl";

            $client->messages->create('+258' . $this->phone_number, [
                'from' => $twilio_number,
                'body' => $message,
            ]);
        } catch (Exception $e) {
            $this->alert('error', 'Error Has Just Occurred. For SMS Notifications');
        }
        Note::createSystemNotification(Admin::class, 'Atualização da conta Admin', 'Você atualizou a conta com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', 'Atualizado com sucesso Admin ' . $this->name);
        return redirect()->route('admin.list.admins');
    }

    public function render()
    {
        return view('livewire.admin.admins.edit-admin', [
            'permissions' => $this->permissions()
        ]);
    }
}
