<?php

namespace App\Http\Livewire\Admin\Grades;

use App\Models\Admin;
use App\Models\Grade;
use Illuminate\Validation\ValidationException;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;
use Note\Note;

class AddGrade extends Component
{
    use FindGuard, LivewireAlert;

    public $name, $class, $validatedData;
    public $updateMode = false;
    public $user;
    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    protected array $rules = [
        'name' => ['required', 'string', 'max:255'],
        'class' => ['required', 'string', 'max:255'],
    ];

    /**
     * D0 real time validations
     * @param $propertyName
     * @throws ValidationException
     */
    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function submit()
    {
        $this->validatedData = $this->validate();
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim, eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        Grade::Create([
            'name' => $this->name,
            'class' => $this->class,
        ]);
        Note::createSystemNotification(Admin::class, 'Detalhes', ' Adicionado com sucesso ' . $this->name);
        $this->emit('noteAdded');
        $this->alert('success', ' Adicionado com sucesso ' . $this->name);
        $this->reset();
    }

    public function cancelled()
    {
        $this->alert('error', 'Você cancelou.');
    }
    public function render()
    {
        return view('livewire.admin.grades.add-grade');
    }
}
