<?php

namespace App\Http\Livewire\Admin\Teachers;

use App\Models\Admin;
use App\Models\TeacherSubject;
use Livewire\Component;
use Livewire\WithPagination;
use LaravelMultipleGuards\Traits\FindGuard;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Note\Note;
class ListTeachers extends Component
{
    protected $lazy = false;
    use WithPagination, FindGuard, LivewireAlert;

    public $search, $delete;

    protected $queryString = ['search'];

    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public bool $readyToLoad = false;

    public function loadData()
    {
        $this->readyToLoad = true;
    }

    protected $listeners = [
        'confirmed',
        'cancelled'
    ];

    public function submit($id)
    {
        $this->delete = TeacherSubject::query()->firstWhere('id', $id);
        $this->confirm('Tem certeza de que deseja prosseguir?', [
            'toast' => false,
            'position' => 'center',
            'showConfirmButton' => true,
            'confirmButtonText' => 'Sim eu tenho certeza!',
            'cancelButtonText' => 'Não, cancelar!',
            'onConfirmed' => 'confirmed',
            'onDismissed' => 'cancelled'
        ]);
    }

    public function confirmed()
    {
        //check if already enrolled
        // $check = TeacherSubject::query()->where('id', $this->delete->id)->get();
        // if (count($check) >= 1) {
        //     $this->alert('warning', 'sorry this model has subscribers.');
        //     return back();
        // }
        TeacherSubject::where('id', $this->delete->id)->delete();
        Note::createSystemNotification(Admin::class, 'Professor/Disciplina', 'Excluído com sucesso ');
        $this->emit('noteAdded');
        $this->alert('success', 'Professor/Disciplina - excluído com sucesso ');
        return back();


    }

    public function cancelled()
    {
        $this->alert('error', 'Cancelado.');
    }


    public function render()
    {
        return view('livewire.admin.teachers.list-teachers', [
            'users' => $this->readyToLoad
                ? TeacherSubject::query()
                    ->latest('updated_at')
                    ->where(function ($query) {
                        $query->orWhere('teacher_id', 'like', '%' . $this->search . '%')
                            ->orWhere('classroom_id', 'like', '%' . $this->search . '%')
  			                ->orWhereRelation('teacher', 'name', 'like', '%'. $this->search . '%')
  			                ->orWhereRelation('teacher', 'email', 'like', '%'. $this->search . '%')
 			                ->orWhereRelation('teacher', 'phone_number', 'like', '%'. $this->search . '%')
                            ->orWhere('class', 'like', '%' . $this->search . '%');
                    })
                    ->paginate(10)
                : []
        ]);
    }
}
