<?php

namespace App\Http\Livewire\User\Inc;

use Jantinnerezo\LivewireAlert\LivewireAlert;
use LaravelMultipleGuards\Traits\FindGuard;
use Livewire\Component;

class Sidebar extends Component
{
    // Disable lazy loading for this component
    protected $lazy = false;
    use FindGuard, LivewireAlert;
    public $user;

    public function logout()
    {
        $this->findGuardType()->logout();
        return redirect()->route('login');
    }

    public function render()
    {
        $this->user= $this->findGuardType()->user();
        return view('livewire.user.inc.sidebar');
    }
}
